/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAbstractView.h"

#include "AbstractView.h"
#include "Document.h"
#include "JSDocument.h"
#include "JSMedia.h"
#include "Media.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSAbstractView);

/* Hash table */

static const HashTableValue JSAbstractViewTableValues[3] =
{
    { "document", DontDelete|ReadOnly, (intptr_t)jsAbstractViewDocument, (intptr_t)0 },
    { "media", DontDelete|ReadOnly, (intptr_t)jsAbstractViewMedia, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSAbstractViewTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSAbstractViewTableValues, 0 };
#else
    { 4, 3, JSAbstractViewTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSAbstractViewPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSAbstractViewPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSAbstractViewPrototypeTableValues, 0 };
#else
    { 1, 0, JSAbstractViewPrototypeTableValues, 0 };
#endif

const ClassInfo JSAbstractViewPrototype::s_info = { "AbstractViewPrototype", 0, &JSAbstractViewPrototypeTable, 0 };

JSObject* JSAbstractViewPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAbstractView>(exec, globalObject);
}

const ClassInfo JSAbstractView::s_info = { "AbstractView", 0, &JSAbstractViewTable, 0 };

JSAbstractView::JSAbstractView(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<AbstractView> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSAbstractView::~JSAbstractView()
{
    forgetDOMObject(this, impl());
}

JSObject* JSAbstractView::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSAbstractViewPrototype(JSAbstractViewPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSAbstractView::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAbstractView, Base>(exec, &JSAbstractViewTable, this, propertyName, slot);
}

bool JSAbstractView::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSAbstractView, Base>(exec, &JSAbstractViewTable, this, propertyName, descriptor);
}

JSValue jsAbstractViewDocument(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSAbstractView* castedThis = static_cast<JSAbstractView*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    AbstractView* imp = static_cast<AbstractView*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->document()));
    return result;
}

JSValue jsAbstractViewMedia(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSAbstractView* castedThis = static_cast<JSAbstractView*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    AbstractView* imp = static_cast<AbstractView*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->media()));
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, AbstractView* object)
{
    return getDOMObjectWrapper<JSAbstractView>(exec, globalObject, object);
}
AbstractView* toAbstractView(JSC::JSValue value)
{
    return value.inherits(&JSAbstractView::s_info) ? static_cast<JSAbstractView*>(asObject(value))->impl() : 0;
}

}
