/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WORKERS)

#include "JSAbstractWorker.h"

#include "AbstractWorker.h"
#include "Event.h"
#include "EventListener.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "RegisteredEventListener.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSAbstractWorker);

/* Hash table */

static const HashTableValue JSAbstractWorkerTableValues[3] =
{
    { "onerror", DontDelete, (intptr_t)jsAbstractWorkerOnerror, (intptr_t)setJSAbstractWorkerOnerror },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsAbstractWorkerConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSAbstractWorkerTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSAbstractWorkerTableValues, 0 };
#else
    { 4, 3, JSAbstractWorkerTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSAbstractWorkerConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSAbstractWorkerConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSAbstractWorkerConstructorTableValues, 0 };
#else
    { 1, 0, JSAbstractWorkerConstructorTableValues, 0 };
#endif

class JSAbstractWorkerConstructor : public DOMConstructorObject {
public:
    JSAbstractWorkerConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSAbstractWorkerConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSAbstractWorkerPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSAbstractWorkerConstructor::s_info = { "AbstractWorkerConstructor", 0, &JSAbstractWorkerConstructorTable, 0 };

bool JSAbstractWorkerConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAbstractWorkerConstructor, DOMObject>(exec, &JSAbstractWorkerConstructorTable, this, propertyName, slot);
}

bool JSAbstractWorkerConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSAbstractWorkerConstructor, DOMObject>(exec, &JSAbstractWorkerConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSAbstractWorkerPrototypeTableValues[4] =
{
    { "addEventListener", DontDelete|Function, (intptr_t)jsAbstractWorkerPrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsAbstractWorkerPrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsAbstractWorkerPrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSAbstractWorkerPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSAbstractWorkerPrototypeTableValues, 0 };
#else
    { 8, 7, JSAbstractWorkerPrototypeTableValues, 0 };
#endif

const ClassInfo JSAbstractWorkerPrototype::s_info = { "AbstractWorkerPrototype", 0, &JSAbstractWorkerPrototypeTable, 0 };

JSObject* JSAbstractWorkerPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAbstractWorker>(exec, globalObject);
}

bool JSAbstractWorkerPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSAbstractWorkerPrototypeTable, this, propertyName, slot);
}

bool JSAbstractWorkerPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSAbstractWorkerPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSAbstractWorker::s_info = { "AbstractWorker", 0, &JSAbstractWorkerTable, 0 };

JSAbstractWorker::JSAbstractWorker(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<AbstractWorker> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSAbstractWorker::~JSAbstractWorker()
{
    impl()->invalidateJSEventListeners(this);
    forgetDOMObject(this, impl());
}

void JSAbstractWorker::markChildren(MarkStack& markStack)
{
    Base::markChildren(markStack);
    impl()->markJSEventListeners(markStack);
}

JSObject* JSAbstractWorker::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSAbstractWorkerPrototype(JSAbstractWorkerPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSAbstractWorker::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSAbstractWorker, Base>(exec, &JSAbstractWorkerTable, this, propertyName, slot);
}

bool JSAbstractWorker::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSAbstractWorker, Base>(exec, &JSAbstractWorkerTable, this, propertyName, descriptor);
}

JSValue jsAbstractWorkerOnerror(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSAbstractWorker* castedThis = static_cast<JSAbstractWorker*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    AbstractWorker* imp = static_cast<AbstractWorker*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsAbstractWorkerConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSAbstractWorker* domObject = static_cast<JSAbstractWorker*>(asObject(slot.slotBase()));
    return JSAbstractWorker::getConstructor(exec, domObject->globalObject());
}
void JSAbstractWorker::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSAbstractWorker, Base>(exec, propertyName, value, &JSAbstractWorkerTable, this, slot);
}

void setJSAbstractWorkerOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    AbstractWorker* imp = static_cast<AbstractWorker*>(static_cast<JSAbstractWorker*>(thisObject)->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}

JSValue JSAbstractWorker::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAbstractWorkerConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsAbstractWorkerPrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSAbstractWorker::s_info))
        return throwError(exec, TypeError);
    JSAbstractWorker* castedThisObj = static_cast<JSAbstractWorker*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsAbstractWorkerPrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSAbstractWorker::s_info))
        return throwError(exec, TypeError);
    JSAbstractWorker* castedThisObj = static_cast<JSAbstractWorker*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsAbstractWorkerPrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSAbstractWorker::s_info))
        return throwError(exec, TypeError);
    JSAbstractWorker* castedThisObj = static_cast<JSAbstractWorker*>(asObject(thisValue));
    AbstractWorker* imp = static_cast<AbstractWorker*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(args.at(0));


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return result;
}

AbstractWorker* toAbstractWorker(JSC::JSValue value)
{
    return value.inherits(&JSAbstractWorker::s_info) ? static_cast<JSAbstractWorker*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WORKERS)
