/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCoordinates.h"

#include "Coordinates.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCoordinates);

/* Hash table */

static const HashTableValue JSCoordinatesTableValues[8] =
{
    { "latitude", DontDelete|ReadOnly, (intptr_t)jsCoordinatesLatitude, (intptr_t)0 },
    { "longitude", DontDelete|ReadOnly, (intptr_t)jsCoordinatesLongitude, (intptr_t)0 },
    { "altitude", DontDelete|ReadOnly, (intptr_t)jsCoordinatesAltitude, (intptr_t)0 },
    { "accuracy", DontDelete|ReadOnly, (intptr_t)jsCoordinatesAccuracy, (intptr_t)0 },
    { "altitudeAccuracy", DontDelete|ReadOnly, (intptr_t)jsCoordinatesAltitudeAccuracy, (intptr_t)0 },
    { "heading", DontDelete|ReadOnly, (intptr_t)jsCoordinatesHeading, (intptr_t)0 },
    { "speed", DontDelete|ReadOnly, (intptr_t)jsCoordinatesSpeed, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCoordinatesTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSCoordinatesTableValues, 0 };
#else
    { 16, 15, JSCoordinatesTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSCoordinatesPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCoordinatesPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCoordinatesPrototypeTableValues, 0 };
#else
    { 1, 0, JSCoordinatesPrototypeTableValues, 0 };
#endif

const ClassInfo JSCoordinatesPrototype::s_info = { "CoordinatesPrototype", 0, &JSCoordinatesPrototypeTable, 0 };

JSObject* JSCoordinatesPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCoordinates>(exec, globalObject);
}

const ClassInfo JSCoordinates::s_info = { "Coordinates", 0, &JSCoordinatesTable, 0 };

JSCoordinates::JSCoordinates(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Coordinates> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSCoordinates::~JSCoordinates()
{
    forgetDOMObject(this, impl());
}

JSObject* JSCoordinates::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCoordinatesPrototype(JSCoordinatesPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSCoordinates::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCoordinates, Base>(exec, &JSCoordinatesTable, this, propertyName, slot);
}

bool JSCoordinates::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCoordinates, Base>(exec, &JSCoordinatesTable, this, propertyName, descriptor);
}

JSValue jsCoordinatesLatitude(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSCoordinates* castedThis = static_cast<JSCoordinates*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Coordinates* imp = static_cast<Coordinates*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->latitude());
    return result;
}

JSValue jsCoordinatesLongitude(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSCoordinates* castedThis = static_cast<JSCoordinates*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Coordinates* imp = static_cast<Coordinates*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->longitude());
    return result;
}

JSValue jsCoordinatesAltitude(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSCoordinates* castedThis = static_cast<JSCoordinates*>(asObject(slot.slotBase()));
    return castedThis->altitude(exec);
}

JSValue jsCoordinatesAccuracy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSCoordinates* castedThis = static_cast<JSCoordinates*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Coordinates* imp = static_cast<Coordinates*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->accuracy());
    return result;
}

JSValue jsCoordinatesAltitudeAccuracy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSCoordinates* castedThis = static_cast<JSCoordinates*>(asObject(slot.slotBase()));
    return castedThis->altitudeAccuracy(exec);
}

JSValue jsCoordinatesHeading(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSCoordinates* castedThis = static_cast<JSCoordinates*>(asObject(slot.slotBase()));
    return castedThis->heading(exec);
}

JSValue jsCoordinatesSpeed(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSCoordinates* castedThis = static_cast<JSCoordinates*>(asObject(slot.slotBase()));
    return castedThis->speed(exec);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Coordinates* object)
{
    return getDOMObjectWrapper<JSCoordinates>(exec, globalObject, object);
}
Coordinates* toCoordinates(JSC::JSValue value)
{
    return value.inherits(&JSCoordinates::s_info) ? static_cast<JSCoordinates*>(asObject(value))->impl() : 0;
}

}
