/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSDOMWindow_h
#define JSDOMWindow_h

#include "DOMWindow.h"
#include "JSDOMWindowBase.h"

namespace WebCore {

class DOMWindow;

class JSDOMWindowShell;

class JSDOMWindow : public JSDOMWindowBase {
    typedef JSDOMWindowBase Base;
public:
    JSDOMWindow(NonNullPassRefPtr<JSC::Structure>, PassRefPtr<DOMWindow>, JSDOMWindowShell*);
    virtual ~JSDOMWindow();
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }

    virtual void markChildren(JSC::MarkStack&);

    virtual bool deleteProperty(JSC::ExecState*, const JSC::Identifier&);
    virtual void getPropertyNames(JSC::ExecState*, JSC::PropertyNameArray&, JSC::EnumerationMode mode = JSC::ExcludeDontEnumProperties);
    virtual bool defineOwnProperty(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&, bool shouldThrow);
    virtual void getOwnPropertyNames(JSC::ExecState*, JSC::PropertyNameArray&, JSC::EnumerationMode mode = JSC::ExcludeDontEnumProperties);
    virtual void defineGetter(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSObject* getterFunction, unsigned attributes);
    virtual void defineSetter(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSObject* setterFunction, unsigned attributes);
    virtual JSC::JSValue lookupGetter(JSC::ExecState*, const JSC::Identifier& propertyName);
    virtual JSC::JSValue lookupSetter(JSC::ExecState*, const JSC::Identifier& propertyName);

    // Custom attributes
    JSC::JSValue history(JSC::ExecState*) const;
    JSC::JSValue location(JSC::ExecState*) const;
    void setLocation(JSC::ExecState*, JSC::JSValue);
    JSC::JSValue event(JSC::ExecState*) const;
    JSC::JSValue crypto(JSC::ExecState*) const;
    JSC::JSValue image(JSC::ExecState*) const;
    JSC::JSValue option(JSC::ExecState*) const;
    JSC::JSValue webGLArrayBuffer(JSC::ExecState*) const;
    JSC::JSValue webGLByteArray(JSC::ExecState*) const;
    JSC::JSValue webGLUnsignedByteArray(JSC::ExecState*) const;
    JSC::JSValue webGLShortArray(JSC::ExecState*) const;
    JSC::JSValue webGLUnsignedShortArray(JSC::ExecState*) const;
    JSC::JSValue webGLIntArray(JSC::ExecState*) const;
    JSC::JSValue webGLUnsignedIntArray(JSC::ExecState*) const;
    JSC::JSValue webGLFloatArray(JSC::ExecState*) const;
    JSC::JSValue webKitCSSMatrix(JSC::ExecState*) const;
    JSC::JSValue webKitPoint(JSC::ExecState*) const;
    JSC::JSValue xmlHttpRequest(JSC::ExecState*) const;
    JSC::JSValue xsltProcessor(JSC::ExecState*) const;
    JSC::JSValue audio(JSC::ExecState*) const;

    // Custom functions
    JSC::JSValue open(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue showModalDialog(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue postMessage(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue setTimeout(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue setInterval(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue atob(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue btoa(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue addEventListener(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue removeEventListener(JSC::ExecState*, const JSC::ArgList&);
    DOMWindow* impl() const
    {
        return static_cast<DOMWindow*>(Base::impl());
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesMarkChildren | JSC::OverridesGetPropertyNames | JSC::ImplementsHasInstance | JSC::NeedsThisConversion | JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

DOMWindow* toDOMWindow(JSC::JSValue);

class JSDOMWindowPrototype : public JSC::JSObject {
    typedef JSC::JSObject Base;
public:
    void* operator new(size_t);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
    JSDOMWindowPrototype(NonNullPassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesMarkChildren | JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionGetSelection(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionFocus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionBlur(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionClose(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionPrint(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionStop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionOpen(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionShowModalDialog(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionAlert(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionConfirm(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionPrompt(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionFind(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionScrollBy(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionScrollTo(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionScroll(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionMoveBy(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionMoveTo(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionResizeBy(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionResizeTo(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionGetComputedStyle(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionGetMatchedCSSRules(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionWebkitConvertPointFromPageToNode(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionWebkitConvertPointFromNodeToPage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionOpenDatabase(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionPostMessage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionSetTimeout(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionClearTimeout(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionSetInterval(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionClearInterval(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionAtob(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionBtoa(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionAddEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionRemoveEventListener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionDispatchEvent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionCaptureEvents(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionReleaseEvents(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
// Attributes

JSC::JSValue jsDOMWindowScreen(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowHistory(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowLocationbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowLocationbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMenubar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMenubar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPersonalbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowPersonalbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScrollbars(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScrollbars(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStatusbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStatusbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowToolbar(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowToolbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNavigator(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNavigator(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClientInformation(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowClientInformation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowLocation(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEvent(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEvent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCrypto(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowFrameElement(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowOffscreenBuffering(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOffscreenBuffering(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOuterHeight(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOuterHeight(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOuterWidth(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOuterWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInnerHeight(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowInnerHeight(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInnerWidth(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowInnerWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenX(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenX(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenY(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenY(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenLeft(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenLeft(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenTop(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScreenTop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScrollX(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScrollX(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScrollY(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowScrollY(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPageXOffset(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowPageYOffset(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowClosed(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowLength(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowLength(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowName(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowName(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStatus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDefaultStatus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDefaultStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDefaultstatus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDefaultstatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSelf(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSelf(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWindow(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowFrames(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowFrames(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOpener(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOpener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowParent(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowParent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTop(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDocument(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowMedia(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowDevicePixelRatio(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDevicePixelRatio(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSessionStorage(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowLocalStorage(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsDOMWindowConsole(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowConsole(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnabort(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnabort(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnbeforeunload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnbeforeunload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnblur(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnblur(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOncanplay(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOncanplay(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOncanplaythrough(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOncanplaythrough(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnchange(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnclick(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnclick(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOncontextmenu(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOncontextmenu(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndblclick(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOndblclick(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndrag(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOndrag(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragend(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOndragend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragenter(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOndragenter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragleave(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOndragleave(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragover(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOndragover(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragstart(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOndragstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndrop(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOndrop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndurationchange(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOndurationchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnemptied(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnemptied(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnended(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnended(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnerror(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnerror(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnfocus(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnfocus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnhashchange(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnhashchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOninput(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOninput(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOninvalid(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOninvalid(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnkeydown(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnkeydown(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnkeypress(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnkeypress(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnkeyup(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnkeyup(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnloadeddata(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnloadeddata(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnloadedmetadata(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnloadedmetadata(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnloadstart(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnloadstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmessage(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmessage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmousedown(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmousedown(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmousemove(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmousemove(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmouseout(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmouseout(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmouseover(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmouseover(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmouseup(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmouseup(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmousewheel(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnmousewheel(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnoffline(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnoffline(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnonline(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnonline(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpagehide(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnpagehide(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpageshow(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnpageshow(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpause(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnpause(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnplay(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnplay(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnplaying(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnplaying(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpopstate(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnpopstate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnprogress(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnprogress(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnratechange(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnratechange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnresize(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnresize(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnscroll(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnscroll(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnseeked(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnseeked(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnseeking(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnseeking(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnselect(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnselect(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnstalled(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnstalled(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnstorage(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnstorage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnsubmit(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnsubmit(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnsuspend(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnsuspend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOntimeupdate(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOntimeupdate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnunload(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnunload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnvolumechange(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnvolumechange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwaiting(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwaiting(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnreset(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnreset(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnsearch(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnsearch(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkitanimationend(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkitanimationend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkitanimationiteration(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkitanimationiteration(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkitanimationstart(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkitanimationstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkittransitionend(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOnwebkittransitionend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStyleSheetConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStyleSheetConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSStyleSheetConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSStyleSheetConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSValueConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSPrimitiveValueConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSPrimitiveValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSValueListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSValueListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitCSSTransformValueConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitCSSTransformValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSCharsetRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSCharsetRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSFontFaceRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSFontFaceRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSImportRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSImportRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSMediaRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSMediaRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSPageRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSPageRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSStyleRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSStyleRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSVariablesRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSVariablesRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSVariablesDeclarationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSVariablesDeclarationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSStyleDeclarationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSStyleDeclarationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMediaListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMediaListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCounterConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCounterConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSRuleListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCSSRuleListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowRectConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowRGBColorConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowRGBColorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStyleSheetListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStyleSheetListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDOMExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMImplementationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDOMImplementationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDocumentFragmentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDocumentFragmentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDocumentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNodeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNodeListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNodeListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNamedNodeMapConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNamedNodeMapConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCharacterDataConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCharacterDataConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowAttrConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowAttrConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTextConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTextConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCommentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCommentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCDATASectionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCDATASectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDocumentTypeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDocumentTypeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNotationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNotationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEntityConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEntityConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEntityReferenceConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEntityReferenceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowProcessingInstructionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowProcessingInstructionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDocumentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAnchorElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAnchorElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAppletElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAppletElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAreaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAreaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBRElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBaseElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBaseElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBaseFontElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBaseFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBlockquoteElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBlockquoteElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBodyElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLBodyElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLButtonElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLButtonElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLCanvasElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLCanvasElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDataGridElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDataGridElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDataGridCellElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDataGridCellElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDataGridColElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDataGridColElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDListElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDirectoryElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDirectoryElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDivElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLDivElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLEmbedElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLEmbedElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFieldSetElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFieldSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFontElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFormElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFormElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFrameElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFrameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFrameSetElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLFrameSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHRElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHeadElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHeadElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHeadingElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHeadingElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHtmlElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLHtmlElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLIFrameElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLIFrameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLImageElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLImageElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLInputElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLInputElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLIsIndexElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLIsIndexElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLIElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLIElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLabelElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLabelElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLegendElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLegendElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLinkElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLLinkElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMapElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMapElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMarqueeElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMarqueeElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMenuElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMenuElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMetaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMetaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLModElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLModElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLOListElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLOListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLObjectElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLObjectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLOptGroupElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLOptGroupElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLOptionElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLOptionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLParagraphElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLParagraphElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLParamElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLParamElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLPreElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLPreElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLQuoteElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLQuoteElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLScriptElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLScriptElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLSelectElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLSelectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLStyleElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLStyleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableCaptionElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableCaptionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableCellElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableCellElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableColElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableColElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableRowElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableRowElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableSectionElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTableSectionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTextAreaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTextAreaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTitleElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLTitleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLUListElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLUListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLCollectionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLCollectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAllCollectionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAllCollectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowImageConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowImageConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCanvasRenderingContext2DConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowCanvasRenderingContext2DConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowImageDataConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowImageDataConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLRenderingContextConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebGLRenderingContextConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTextMetricsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTextMetricsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLArrayBufferConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebGLArrayBufferConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLByteArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebGLByteArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLUnsignedByteArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebGLUnsignedByteArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLShortArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebGLShortArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLUnsignedShortArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebGLUnsignedShortArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLIntArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebGLIntArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLUnsignedIntArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebGLUnsignedIntArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebGLFloatArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebGLFloatArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowBeforeLoadEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowBeforeLoadEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowKeyboardEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowKeyboardEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMouseEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMouseEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMutationEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMutationEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOverflowEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowOverflowEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPageTransitionEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowPageTransitionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowProgressEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowProgressEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTextEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowTextEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowUIEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowUIEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitAnimationEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitAnimationEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitTransitionEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitTransitionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWheelEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWheelEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMessageEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMessageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEventExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowEventExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitCSSKeyframeRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitCSSKeyframeRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitCSSKeyframesRuleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitCSSKeyframesRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitCSSMatrixConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitCSSMatrixConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitPointConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowWebKitPointConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClipboardConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowClipboardConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFileConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowFileConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFileListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowFileListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowBlobConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowBlobConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNodeFilterConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowNodeFilterConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowRangeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowRangeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowRangeExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowRangeExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLDocumentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMParserConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowDOMParserConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLSerializerConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLSerializerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLHttpRequestConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLHttpRequestConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLHttpRequestUploadConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLHttpRequestUploadConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLHttpRequestExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXMLHttpRequestExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXSLTProcessorConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowXSLTProcessorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPluginConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowPluginConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPluginArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowPluginArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMimeTypeConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMimeTypeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMimeTypeArrayConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMimeTypeArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClientRectConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowClientRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClientRectListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowClientRectListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStorageConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStorageConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStorageEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowStorageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowAudioConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowAudioConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAudioElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLAudioElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMediaElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLMediaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLVideoElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowHTMLVideoElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMediaErrorConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowMediaErrorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAngleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAngleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedAngleConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedAngleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedBooleanConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedBooleanConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedEnumerationConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedEnumerationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedIntegerConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedIntegerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedLengthConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedLengthConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedLengthListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedLengthListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedNumberConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedNumberConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedNumberListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedNumberListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedPreserveAspectRatioConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedRectConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedStringConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedStringConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimatedTransformListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimatedTransformListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGCircleElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGCircleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGClipPathElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGClipPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGColorConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGColorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGCursorElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGCursorElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGDefsElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGDefsElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGDescElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGDescElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGDocumentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGElementInstanceConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGElementInstanceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGElementInstanceListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGElementInstanceListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGEllipseElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGEllipseElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGExceptionConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGGElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGGElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGGradientElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGGradientElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGImageElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGImageElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGLengthConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGLengthConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGLengthListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGLengthListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGLinearGradientElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGLinearGradientElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGLineElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGLineElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGMarkerElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGMarkerElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGMaskElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGMaskElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGMatrixConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGMatrixConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGMetadataElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGMetadataElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGNumberConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGNumberConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGNumberListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGNumberListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPaintConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPaintConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegArcAbsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegArcAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegArcRelConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegArcRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegClosePathConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegClosePathConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicAbsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegCurvetoCubicAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicRelConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegCurvetoCubicRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicSmoothAbsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegCurvetoCubicSmoothAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicSmoothRelConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegCurvetoCubicSmoothRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticAbsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegCurvetoQuadraticAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticRelConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegCurvetoQuadraticRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticSmoothAbsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegCurvetoQuadraticSmoothAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoAbsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegLinetoAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoHorizontalAbsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegLinetoHorizontalAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoHorizontalRelConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegLinetoHorizontalRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoRelConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegLinetoRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoVerticalAbsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegLinetoVerticalAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegLinetoVerticalRelConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegLinetoVerticalRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegMovetoAbsConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegMovetoAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPathSegMovetoRelConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPathSegMovetoRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPatternElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPatternElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPointConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPointConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPointListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPointListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPolygonElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPolygonElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPolylineElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPolylineElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGPreserveAspectRatioConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGRadialGradientElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGRadialGradientElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGRectConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGRectElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGRectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGRenderingIntentConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGRenderingIntentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGScriptElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGScriptElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGStopElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGStopElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGStringListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGStringListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGStyleElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGStyleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGSVGElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGSVGElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGSwitchElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGSwitchElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGSymbolElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGSymbolElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTextContentElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTextContentElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTextElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTextElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTextPathElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTextPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTextPositioningElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTextPositioningElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTitleElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTitleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTransformConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTransformConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTransformListConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTransformListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTRefElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTRefElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGTSpanElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGTSpanElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGUnitTypesConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGUnitTypesConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGUseElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGUseElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGViewElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGViewElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGZoomEventConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGZoomEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimateColorElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimateColorElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimateElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimateElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAnimateTransformElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAnimateTransformElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGSetElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGAltGlyphElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGAltGlyphElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFontElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFontFaceElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGFontFaceElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFontFaceFormatElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGFontFaceFormatElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFontFaceNameElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGFontFaceNameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFontFaceSrcElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGFontFaceSrcElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGFontFaceUriElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGFontFaceUriElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGGlyphElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGGlyphElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGMissingGlyphElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGMissingGlyphElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSVGForeignObjectElementConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSDOMWindowSVGForeignObjectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);

} // namespace WebCore

#endif
