/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATABASE)

#include "JSDatabase.h"

#include "Database.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSDatabase);

/* Hash table */

static const HashTableValue JSDatabaseTableValues[2] =
{
    { "version", DontDelete|ReadOnly, (intptr_t)jsDatabaseVersion, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDatabaseTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSDatabaseTableValues, 0 };
#else
    { 2, 1, JSDatabaseTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSDatabasePrototypeTableValues[4] =
{
    { "changeVersion", DontDelete|Function, (intptr_t)jsDatabasePrototypeFunctionChangeVersion, (intptr_t)5 },
    { "transaction", DontDelete|Function, (intptr_t)jsDatabasePrototypeFunctionTransaction, (intptr_t)3 },
    { "readTransaction", DontDelete|Function, (intptr_t)jsDatabasePrototypeFunctionReadTransaction, (intptr_t)3 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSDatabasePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSDatabasePrototypeTableValues, 0 };
#else
    { 8, 7, JSDatabasePrototypeTableValues, 0 };
#endif

const ClassInfo JSDatabasePrototype::s_info = { "DatabasePrototype", 0, &JSDatabasePrototypeTable, 0 };

JSObject* JSDatabasePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDatabase>(exec, globalObject);
}

bool JSDatabasePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSDatabasePrototypeTable, this, propertyName, slot);
}

bool JSDatabasePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDatabasePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSDatabase::s_info = { "Database", 0, &JSDatabaseTable, 0 };

JSDatabase::JSDatabase(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Database> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSDatabase::~JSDatabase()
{
    forgetDOMObject(this, impl());
}

JSObject* JSDatabase::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSDatabasePrototype(JSDatabasePrototype::createStructure(globalObject->objectPrototype()));
}

bool JSDatabase::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDatabase, Base>(exec, &JSDatabaseTable, this, propertyName, slot);
}

bool JSDatabase::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDatabase, Base>(exec, &JSDatabaseTable, this, propertyName, descriptor);
}

JSValue jsDatabaseVersion(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSDatabase* castedThis = static_cast<JSDatabase*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Database* imp = static_cast<Database*>(castedThis->impl());
    JSValue result = jsString(exec, imp->version());
    return result;
}

JSValue JSC_HOST_CALL jsDatabasePrototypeFunctionChangeVersion(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDatabase::s_info))
        return throwError(exec, TypeError);
    JSDatabase* castedThisObj = static_cast<JSDatabase*>(asObject(thisValue));
    return castedThisObj->changeVersion(exec, args);
}

JSValue JSC_HOST_CALL jsDatabasePrototypeFunctionTransaction(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDatabase::s_info))
        return throwError(exec, TypeError);
    JSDatabase* castedThisObj = static_cast<JSDatabase*>(asObject(thisValue));
    return castedThisObj->transaction(exec, args);
}

JSValue JSC_HOST_CALL jsDatabasePrototypeFunctionReadTransaction(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSDatabase::s_info))
        return throwError(exec, TypeError);
    JSDatabase* castedThisObj = static_cast<JSDatabase*>(asObject(thisValue));
    return castedThisObj->readTransaction(exec, args);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Database* object)
{
    return getDOMObjectWrapper<JSDatabase>(exec, globalObject, object);
}
Database* toDatabase(JSC::JSValue value)
{
    return value.inherits(&JSDatabase::s_info) ? static_cast<JSDatabase*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(DATABASE)
