/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSElement.h"

#include "Attr.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "ClientRect.h"
#include "ClientRectList.h"
#include "Element.h"
#include "EventListener.h"
#include "JSAttr.h"
#include "JSCSSStyleDeclaration.h"
#include "JSClientRect.h"
#include "JSClientRectList.h"
#include "JSElement.h"
#include "JSEventListener.h"
#include "JSNodeList.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSElement);

/* Hash table */

static const HashTableValue JSElementTableValues[61] =
{
    { "tagName", DontDelete|ReadOnly, (intptr_t)jsElementTagName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsElementStyle, (intptr_t)0 },
    { "offsetLeft", DontDelete|ReadOnly, (intptr_t)jsElementOffsetLeft, (intptr_t)0 },
    { "offsetTop", DontDelete|ReadOnly, (intptr_t)jsElementOffsetTop, (intptr_t)0 },
    { "offsetWidth", DontDelete|ReadOnly, (intptr_t)jsElementOffsetWidth, (intptr_t)0 },
    { "offsetHeight", DontDelete|ReadOnly, (intptr_t)jsElementOffsetHeight, (intptr_t)0 },
    { "offsetParent", DontDelete|ReadOnly, (intptr_t)jsElementOffsetParent, (intptr_t)0 },
    { "clientLeft", DontDelete|ReadOnly, (intptr_t)jsElementClientLeft, (intptr_t)0 },
    { "clientTop", DontDelete|ReadOnly, (intptr_t)jsElementClientTop, (intptr_t)0 },
    { "clientWidth", DontDelete|ReadOnly, (intptr_t)jsElementClientWidth, (intptr_t)0 },
    { "clientHeight", DontDelete|ReadOnly, (intptr_t)jsElementClientHeight, (intptr_t)0 },
    { "scrollLeft", DontDelete, (intptr_t)jsElementScrollLeft, (intptr_t)setJSElementScrollLeft },
    { "scrollTop", DontDelete, (intptr_t)jsElementScrollTop, (intptr_t)setJSElementScrollTop },
    { "scrollWidth", DontDelete|ReadOnly, (intptr_t)jsElementScrollWidth, (intptr_t)0 },
    { "scrollHeight", DontDelete|ReadOnly, (intptr_t)jsElementScrollHeight, (intptr_t)0 },
    { "firstElementChild", DontDelete|ReadOnly, (intptr_t)jsElementFirstElementChild, (intptr_t)0 },
    { "lastElementChild", DontDelete|ReadOnly, (intptr_t)jsElementLastElementChild, (intptr_t)0 },
    { "previousElementSibling", DontDelete|ReadOnly, (intptr_t)jsElementPreviousElementSibling, (intptr_t)0 },
    { "nextElementSibling", DontDelete|ReadOnly, (intptr_t)jsElementNextElementSibling, (intptr_t)0 },
    { "childElementCount", DontDelete|ReadOnly, (intptr_t)jsElementChildElementCount, (intptr_t)0 },
    { "onabort", DontDelete|DontEnum, (intptr_t)jsElementOnabort, (intptr_t)setJSElementOnabort },
    { "onblur", DontDelete|DontEnum, (intptr_t)jsElementOnblur, (intptr_t)setJSElementOnblur },
    { "onchange", DontDelete|DontEnum, (intptr_t)jsElementOnchange, (intptr_t)setJSElementOnchange },
    { "onclick", DontDelete|DontEnum, (intptr_t)jsElementOnclick, (intptr_t)setJSElementOnclick },
    { "oncontextmenu", DontDelete|DontEnum, (intptr_t)jsElementOncontextmenu, (intptr_t)setJSElementOncontextmenu },
    { "ondblclick", DontDelete|DontEnum, (intptr_t)jsElementOndblclick, (intptr_t)setJSElementOndblclick },
    { "ondrag", DontDelete|DontEnum, (intptr_t)jsElementOndrag, (intptr_t)setJSElementOndrag },
    { "ondragend", DontDelete|DontEnum, (intptr_t)jsElementOndragend, (intptr_t)setJSElementOndragend },
    { "ondragenter", DontDelete|DontEnum, (intptr_t)jsElementOndragenter, (intptr_t)setJSElementOndragenter },
    { "ondragleave", DontDelete|DontEnum, (intptr_t)jsElementOndragleave, (intptr_t)setJSElementOndragleave },
    { "ondragover", DontDelete|DontEnum, (intptr_t)jsElementOndragover, (intptr_t)setJSElementOndragover },
    { "ondragstart", DontDelete|DontEnum, (intptr_t)jsElementOndragstart, (intptr_t)setJSElementOndragstart },
    { "ondrop", DontDelete|DontEnum, (intptr_t)jsElementOndrop, (intptr_t)setJSElementOndrop },
    { "onerror", DontDelete|DontEnum, (intptr_t)jsElementOnerror, (intptr_t)setJSElementOnerror },
    { "onfocus", DontDelete|DontEnum, (intptr_t)jsElementOnfocus, (intptr_t)setJSElementOnfocus },
    { "oninput", DontDelete|DontEnum, (intptr_t)jsElementOninput, (intptr_t)setJSElementOninput },
    { "oninvalid", DontDelete|DontEnum, (intptr_t)jsElementOninvalid, (intptr_t)setJSElementOninvalid },
    { "onkeydown", DontDelete|DontEnum, (intptr_t)jsElementOnkeydown, (intptr_t)setJSElementOnkeydown },
    { "onkeypress", DontDelete|DontEnum, (intptr_t)jsElementOnkeypress, (intptr_t)setJSElementOnkeypress },
    { "onkeyup", DontDelete|DontEnum, (intptr_t)jsElementOnkeyup, (intptr_t)setJSElementOnkeyup },
    { "onload", DontDelete|DontEnum, (intptr_t)jsElementOnload, (intptr_t)setJSElementOnload },
    { "onmousedown", DontDelete|DontEnum, (intptr_t)jsElementOnmousedown, (intptr_t)setJSElementOnmousedown },
    { "onmousemove", DontDelete|DontEnum, (intptr_t)jsElementOnmousemove, (intptr_t)setJSElementOnmousemove },
    { "onmouseout", DontDelete|DontEnum, (intptr_t)jsElementOnmouseout, (intptr_t)setJSElementOnmouseout },
    { "onmouseover", DontDelete|DontEnum, (intptr_t)jsElementOnmouseover, (intptr_t)setJSElementOnmouseover },
    { "onmouseup", DontDelete|DontEnum, (intptr_t)jsElementOnmouseup, (intptr_t)setJSElementOnmouseup },
    { "onmousewheel", DontDelete|DontEnum, (intptr_t)jsElementOnmousewheel, (intptr_t)setJSElementOnmousewheel },
    { "onscroll", DontDelete|DontEnum, (intptr_t)jsElementOnscroll, (intptr_t)setJSElementOnscroll },
    { "onselect", DontDelete|DontEnum, (intptr_t)jsElementOnselect, (intptr_t)setJSElementOnselect },
    { "onsubmit", DontDelete|DontEnum, (intptr_t)jsElementOnsubmit, (intptr_t)setJSElementOnsubmit },
    { "onbeforecut", DontDelete|DontEnum, (intptr_t)jsElementOnbeforecut, (intptr_t)setJSElementOnbeforecut },
    { "oncut", DontDelete|DontEnum, (intptr_t)jsElementOncut, (intptr_t)setJSElementOncut },
    { "onbeforecopy", DontDelete|DontEnum, (intptr_t)jsElementOnbeforecopy, (intptr_t)setJSElementOnbeforecopy },
    { "oncopy", DontDelete|DontEnum, (intptr_t)jsElementOncopy, (intptr_t)setJSElementOncopy },
    { "onbeforepaste", DontDelete|DontEnum, (intptr_t)jsElementOnbeforepaste, (intptr_t)setJSElementOnbeforepaste },
    { "onpaste", DontDelete|DontEnum, (intptr_t)jsElementOnpaste, (intptr_t)setJSElementOnpaste },
    { "onreset", DontDelete|DontEnum, (intptr_t)jsElementOnreset, (intptr_t)setJSElementOnreset },
    { "onsearch", DontDelete|DontEnum, (intptr_t)jsElementOnsearch, (intptr_t)setJSElementOnsearch },
    { "onselectstart", DontDelete|DontEnum, (intptr_t)jsElementOnselectstart, (intptr_t)setJSElementOnselectstart },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 8191, JSElementTableValues, 0 };
#else
    { 141, 127, JSElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSElementConstructorTableValues, 0 };
#else
    { 1, 0, JSElementConstructorTableValues, 0 };
#endif

class JSElementConstructor : public DOMConstructorObject {
public:
    JSElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSElementConstructor::s_info = { "ElementConstructor", 0, &JSElementConstructorTable, 0 };

bool JSElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSElementConstructor, DOMObject>(exec, &JSElementConstructorTable, this, propertyName, slot);
}

bool JSElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSElementConstructor, DOMObject>(exec, &JSElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSElementPrototypeTableValues[29] =
{
    { "getAttribute", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionGetAttribute, (intptr_t)1 },
    { "setAttribute", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionSetAttribute, (intptr_t)2 },
    { "removeAttribute", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionRemoveAttribute, (intptr_t)1 },
    { "getAttributeNode", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionGetAttributeNode, (intptr_t)1 },
    { "setAttributeNode", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionSetAttributeNode, (intptr_t)1 },
    { "removeAttributeNode", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionRemoveAttributeNode, (intptr_t)1 },
    { "getElementsByTagName", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionGetElementsByTagName, (intptr_t)1 },
    { "getAttributeNS", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionGetAttributeNS, (intptr_t)2 },
    { "setAttributeNS", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionSetAttributeNS, (intptr_t)3 },
    { "removeAttributeNS", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionRemoveAttributeNS, (intptr_t)2 },
    { "getElementsByTagNameNS", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionGetElementsByTagNameNS, (intptr_t)2 },
    { "getAttributeNodeNS", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionGetAttributeNodeNS, (intptr_t)2 },
    { "setAttributeNodeNS", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionSetAttributeNodeNS, (intptr_t)1 },
    { "hasAttribute", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionHasAttribute, (intptr_t)1 },
    { "hasAttributeNS", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionHasAttributeNS, (intptr_t)2 },
    { "focus", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionFocus, (intptr_t)0 },
    { "blur", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionBlur, (intptr_t)0 },
    { "scrollIntoView", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionScrollIntoView, (intptr_t)1 },
    { "contains", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionContains, (intptr_t)1 },
    { "scrollIntoViewIfNeeded", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionScrollIntoViewIfNeeded, (intptr_t)1 },
    { "scrollByLines", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionScrollByLines, (intptr_t)1 },
    { "scrollByPages", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionScrollByPages, (intptr_t)1 },
    { "getElementsByClassName", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionGetElementsByClassName, (intptr_t)1 },
    { "querySelector", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionQuerySelector, (intptr_t)1 },
    { "querySelectorAll", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionQuerySelectorAll, (intptr_t)1 },
    { "webkitMatchesSelector", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionWebkitMatchesSelector, (intptr_t)1 },
    { "getClientRects", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionGetClientRects, (intptr_t)0 },
    { "getBoundingClientRect", DontDelete|Function, (intptr_t)jsElementPrototypeFunctionGetBoundingClientRect, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1023, JSElementPrototypeTableValues, 0 };
#else
    { 69, 63, JSElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSElementPrototype::s_info = { "ElementPrototype", 0, &JSElementPrototypeTable, 0 };

JSObject* JSElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSElement>(exec, globalObject);
}

bool JSElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSElementPrototypeTable, this, propertyName, slot);
}

bool JSElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSElement::s_info = { "Element", &JSNode::s_info, &JSElementTable, 0 };

JSElement::JSElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Element> impl)
    : JSNode(structure, globalObject, impl)
{
}

JSObject* JSElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSElementPrototype(JSElementPrototype::createStructure(JSNodePrototype::self(exec, globalObject)));
}

JSValue jsElementTagName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->tagName());
    return result;
}

JSValue jsElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}

JSValue jsElementOffsetLeft(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->offsetLeft());
    return result;
}

JSValue jsElementOffsetTop(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->offsetTop());
    return result;
}

JSValue jsElementOffsetWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->offsetWidth());
    return result;
}

JSValue jsElementOffsetHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->offsetHeight());
    return result;
}

JSValue jsElementOffsetParent(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->offsetParent()));
    return result;
}

JSValue jsElementClientLeft(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->clientLeft());
    return result;
}

JSValue jsElementClientTop(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->clientTop());
    return result;
}

JSValue jsElementClientWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->clientWidth());
    return result;
}

JSValue jsElementClientHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->clientHeight());
    return result;
}

JSValue jsElementScrollLeft(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->scrollLeft());
    return result;
}

JSValue jsElementScrollTop(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->scrollTop());
    return result;
}

JSValue jsElementScrollWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->scrollWidth());
    return result;
}

JSValue jsElementScrollHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->scrollHeight());
    return result;
}

JSValue jsElementFirstElementChild(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->firstElementChild()));
    return result;
}

JSValue jsElementLastElementChild(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->lastElementChild()));
    return result;
}

JSValue jsElementPreviousElementSibling(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->previousElementSibling()));
    return result;
}

JSValue jsElementNextElementSibling(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nextElementSibling()));
    return result;
}

JSValue jsElementChildElementCount(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->childElementCount());
    return result;
}

JSValue jsElementOnabort(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnblur(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onblur()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnchange(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnclick(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOncontextmenu(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->oncontextmenu()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOndblclick(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->ondblclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOndrag(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->ondrag()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOndragend(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->ondragend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOndragenter(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->ondragenter()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOndragleave(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->ondragleave()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOndragover(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->ondragover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOndragstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->ondragstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOndrop(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->ondrop()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnerror(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnfocus(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onfocus()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOninput(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->oninput()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOninvalid(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->oninvalid()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnkeydown(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onkeydown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnkeypress(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onkeypress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnkeyup(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onkeyup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnmousedown(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onmousedown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnmousemove(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onmousemove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnmouseout(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseout()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnmouseover(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnmouseup(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnmousewheel(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onmousewheel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnscroll(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onscroll()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnselect(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onselect()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnsubmit(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onsubmit()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnbeforecut(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOncut(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->oncut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnbeforecopy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOncopy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->oncopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnbeforepaste(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforepaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnpaste(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onpaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnreset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onreset()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnsearch(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onsearch()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementOnselectstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* castedThis = static_cast<JSElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(castedThis->impl());
    if (EventListener* listener = imp->onselectstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSElement* domObject = static_cast<JSElement*>(asObject(slot.slotBase()));
    return JSElement::getConstructor(exec, domObject->globalObject());
}
void JSElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSElement, Base>(exec, propertyName, value, &JSElementTable, this, slot);
}

void setJSElementScrollLeft(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSElement* castedThisObj = static_cast<JSElement*>(thisObject);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    imp->setScrollLeft(value.toInt32(exec));
}

void setJSElementScrollTop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSElement* castedThisObj = static_cast<JSElement*>(thisObject);
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    imp->setScrollTop(value.toInt32(exec));
}

void setJSElementOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnblur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnblur(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnchange(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnclick(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOncontextmenu(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOncontextmenu(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOndblclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOndblclick(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOndrag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOndrag(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOndragend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOndragend(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOndragenter(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOndragenter(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOndragleave(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOndragleave(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOndragover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOndragover(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOndragstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOndragstart(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOndrop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOndrop(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnfocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnfocus(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOninput(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOninput(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOninvalid(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOninvalid(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnkeydown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnkeydown(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnkeypress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnkeypress(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnkeyup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnkeyup(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnload(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnmousedown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnmousedown(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnmousemove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnmousemove(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnmouseout(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnmouseout(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnmouseover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnmouseover(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnmouseup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnmouseup(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnmousewheel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnmousewheel(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnscroll(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnscroll(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnselect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnselect(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnsubmit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnsubmit(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnbeforecut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnbeforecut(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOncut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOncut(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnbeforecopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnbeforecopy(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOncopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOncopy(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnbeforepaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnbeforepaste(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnpaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnpaste(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnreset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnreset(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnsearch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnsearch(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSElementOnselectstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Element* imp = static_cast<Element*>(static_cast<JSElement*>(thisObject)->impl());
    imp->setOnselectstart(createJSAttributeEventListener(exec, value, thisObject));
}

JSValue JSElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = jsStringOrNull(exec, imp->getAttribute(name));
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    return castedThisObj->setAttribute(exec, args);
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& name = args.at(0).toString(exec);

    imp->removeAttribute(name, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNode(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getAttributeNode(name)));
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNode(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    return castedThisObj->setAttributeNode(exec, args);
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNode(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Attr* oldAttr = toAttr(args.at(0));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->removeAttributeNode(oldAttr, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagName(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getElementsByTagName(name)));
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNS(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args.at(0));
    const UString& localName = args.at(1).toString(exec);


    JSC::JSValue result = jsString(exec, imp->getAttributeNS(namespaceURI, localName));
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNS(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    return castedThisObj->setAttributeNS(exec, args);
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionRemoveAttributeNS(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args.at(0));
    const UString& localName = args.at(1).toString(exec);

    imp->removeAttributeNS(namespaceURI, localName, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByTagNameNS(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args.at(0));
    const UString& localName = args.at(1).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getElementsByTagNameNS(namespaceURI, localName)));
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionGetAttributeNodeNS(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args.at(0));
    const UString& localName = args.at(1).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getAttributeNodeNS(namespaceURI, localName)));
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionSetAttributeNodeNS(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    return castedThisObj->setAttributeNodeNS(exec, args);
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->hasAttribute(name));
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionHasAttributeNS(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    const UString& namespaceURI = valueToStringWithNullCheck(exec, args.at(0));
    const UString& localName = args.at(1).toString(exec);


    JSC::JSValue result = jsBoolean(imp->hasAttributeNS(namespaceURI, localName));
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionFocus(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());

    imp->focus();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionBlur(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());

    imp->blur();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoView(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());

    int argsCount = args.size();
    if (argsCount < 1) {
        imp->scrollIntoView();
        return jsUndefined();
    }

    bool alignWithTop = args.at(0).toBoolean(exec);

    imp->scrollIntoView(alignWithTop);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionContains(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    Element* element = toElement(args.at(0));


    JSC::JSValue result = jsBoolean(imp->contains(element));
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollIntoViewIfNeeded(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());

    int argsCount = args.size();
    if (argsCount < 1) {
        imp->scrollIntoViewIfNeeded();
        return jsUndefined();
    }

    bool centerIfNeeded = args.at(0).toBoolean(exec);

    imp->scrollIntoViewIfNeeded(centerIfNeeded);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollByLines(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    int lines = args.at(0).toInt32(exec);

    imp->scrollByLines(lines);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionScrollByPages(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    int pages = args.at(0).toInt32(exec);

    imp->scrollByPages(pages);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionGetElementsByClassName(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getElementsByClassName(name)));
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelector(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& selectors = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->querySelector(selectors, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionQuerySelectorAll(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& selectors = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->querySelectorAll(selectors, ec)));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionWebkitMatchesSelector(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& selectors = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->webkitMatchesSelector(selectors, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionGetClientRects(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getClientRects()));
    return result;
}

JSValue JSC_HOST_CALL jsElementPrototypeFunctionGetBoundingClientRect(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElement::s_info))
        return throwError(exec, TypeError);
    JSElement* castedThisObj = static_cast<JSElement*>(asObject(thisValue));
    Element* imp = static_cast<Element*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getBoundingClientRect()));
    return result;
}

Element* toElement(JSC::JSValue value)
{
    return value.inherits(&JSElement::s_info) ? static_cast<JSElement*>(asObject(value))->impl() : 0;
}

}
