/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSElementTimeControl.h"

#include "ElementTimeControl.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSElementTimeControl);

/* Hash table for prototype */

static const HashTableValue JSElementTimeControlPrototypeTableValues[5] =
{
    { "beginElement", DontDelete|Function, (intptr_t)jsElementTimeControlPrototypeFunctionBeginElement, (intptr_t)0 },
    { "beginElementAt", DontDelete|Function, (intptr_t)jsElementTimeControlPrototypeFunctionBeginElementAt, (intptr_t)1 },
    { "endElement", DontDelete|Function, (intptr_t)jsElementTimeControlPrototypeFunctionEndElement, (intptr_t)0 },
    { "endElementAt", DontDelete|Function, (intptr_t)jsElementTimeControlPrototypeFunctionEndElementAt, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSElementTimeControlPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSElementTimeControlPrototypeTableValues, 0 };
#else
    { 9, 7, JSElementTimeControlPrototypeTableValues, 0 };
#endif

const ClassInfo JSElementTimeControlPrototype::s_info = { "ElementTimeControlPrototype", 0, &JSElementTimeControlPrototypeTable, 0 };

JSObject* JSElementTimeControlPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSElementTimeControl>(exec, globalObject);
}

bool JSElementTimeControlPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSElementTimeControlPrototypeTable, this, propertyName, slot);
}

bool JSElementTimeControlPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSElementTimeControlPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSElementTimeControl::s_info = { "ElementTimeControl", 0, 0, 0 };

JSElementTimeControl::JSElementTimeControl(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<ElementTimeControl> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSElementTimeControl::~JSElementTimeControl()
{
    forgetDOMObject(this, impl());
}

JSObject* JSElementTimeControl::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSElementTimeControlPrototype(JSElementTimeControlPrototype::createStructure(globalObject->objectPrototype()));
}

JSValue JSC_HOST_CALL jsElementTimeControlPrototypeFunctionBeginElement(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElementTimeControl::s_info))
        return throwError(exec, TypeError);
    JSElementTimeControl* castedThisObj = static_cast<JSElementTimeControl*>(asObject(thisValue));
    ElementTimeControl* imp = static_cast<ElementTimeControl*>(castedThisObj->impl());

    imp->beginElement();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsElementTimeControlPrototypeFunctionBeginElementAt(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElementTimeControl::s_info))
        return throwError(exec, TypeError);
    JSElementTimeControl* castedThisObj = static_cast<JSElementTimeControl*>(asObject(thisValue));
    ElementTimeControl* imp = static_cast<ElementTimeControl*>(castedThisObj->impl());
    float offset = args.at(0).toFloat(exec);

    imp->beginElementAt(offset);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsElementTimeControlPrototypeFunctionEndElement(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElementTimeControl::s_info))
        return throwError(exec, TypeError);
    JSElementTimeControl* castedThisObj = static_cast<JSElementTimeControl*>(asObject(thisValue));
    ElementTimeControl* imp = static_cast<ElementTimeControl*>(castedThisObj->impl());

    imp->endElement();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsElementTimeControlPrototypeFunctionEndElementAt(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSElementTimeControl::s_info))
        return throwError(exec, TypeError);
    JSElementTimeControl* castedThisObj = static_cast<JSElementTimeControl*>(asObject(thisValue));
    ElementTimeControl* imp = static_cast<ElementTimeControl*>(castedThisObj->impl());
    float offset = args.at(0).toFloat(exec);

    imp->endElementAt(offset);
    return jsUndefined();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, ElementTimeControl* object)
{
    return getDOMObjectWrapper<JSElementTimeControl>(exec, globalObject, object);
}
ElementTimeControl* toElementTimeControl(JSC::JSValue value)
{
    return value.inherits(&JSElementTimeControl::s_info) ? static_cast<JSElementTimeControl*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
