/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEntity.h"

#include "Entity.h"
#include "KURL.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSEntity);

/* Hash table */

static const HashTableValue JSEntityTableValues[5] =
{
    { "publicId", DontDelete|ReadOnly, (intptr_t)jsEntityPublicId, (intptr_t)0 },
    { "systemId", DontDelete|ReadOnly, (intptr_t)jsEntitySystemId, (intptr_t)0 },
    { "notationName", DontDelete|ReadOnly, (intptr_t)jsEntityNotationName, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsEntityConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSEntityTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSEntityTableValues, 0 };
#else
    { 10, 7, JSEntityTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSEntityConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSEntityConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSEntityConstructorTableValues, 0 };
#else
    { 1, 0, JSEntityConstructorTableValues, 0 };
#endif

class JSEntityConstructor : public DOMConstructorObject {
public:
    JSEntityConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSEntityConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSEntityPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSEntityConstructor::s_info = { "EntityConstructor", 0, &JSEntityConstructorTable, 0 };

bool JSEntityConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntityConstructor, DOMObject>(exec, &JSEntityConstructorTable, this, propertyName, slot);
}

bool JSEntityConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSEntityConstructor, DOMObject>(exec, &JSEntityConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSEntityPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSEntityPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSEntityPrototypeTableValues, 0 };
#else
    { 1, 0, JSEntityPrototypeTableValues, 0 };
#endif

const ClassInfo JSEntityPrototype::s_info = { "EntityPrototype", 0, &JSEntityPrototypeTable, 0 };

JSObject* JSEntityPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEntity>(exec, globalObject);
}

const ClassInfo JSEntity::s_info = { "Entity", &JSNode::s_info, &JSEntityTable, 0 };

JSEntity::JSEntity(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Entity> impl)
    : JSNode(structure, globalObject, impl)
{
}

JSObject* JSEntity::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSEntityPrototype(JSEntityPrototype::createStructure(JSNodePrototype::self(exec, globalObject)));
}

bool JSEntity::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntity, Base>(exec, &JSEntityTable, this, propertyName, slot);
}

bool JSEntity::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSEntity, Base>(exec, &JSEntityTable, this, propertyName, descriptor);
}

JSValue jsEntityPublicId(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSEntity* castedThis = static_cast<JSEntity*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Entity* imp = static_cast<Entity*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->publicId());
    return result;
}

JSValue jsEntitySystemId(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSEntity* castedThis = static_cast<JSEntity*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Entity* imp = static_cast<Entity*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->systemId());
    return result;
}

JSValue jsEntityNotationName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSEntity* castedThis = static_cast<JSEntity*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Entity* imp = static_cast<Entity*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->notationName());
    return result;
}

JSValue jsEntityConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSEntity* domObject = static_cast<JSEntity*>(asObject(slot.slotBase()));
    return JSEntity::getConstructor(exec, domObject->globalObject());
}
JSValue JSEntity::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEntityConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
