/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGeolocation.h"

#include "Geolocation.h"
#include "Geoposition.h"
#include "JSGeoposition.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSGeolocation);

/* Hash table */

static const HashTableValue JSGeolocationTableValues[2] =
{
    { "lastPosition", DontDelete|ReadOnly, (intptr_t)jsGeolocationLastPosition, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSGeolocationTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSGeolocationTableValues, 0 };
#else
    { 2, 1, JSGeolocationTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSGeolocationPrototypeTableValues[4] =
{
    { "getCurrentPosition", DontDelete|Function, (intptr_t)jsGeolocationPrototypeFunctionGetCurrentPosition, (intptr_t)3 },
    { "watchPosition", DontDelete|Function, (intptr_t)jsGeolocationPrototypeFunctionWatchPosition, (intptr_t)3 },
    { "clearWatch", DontDelete|Function, (intptr_t)jsGeolocationPrototypeFunctionClearWatch, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSGeolocationPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSGeolocationPrototypeTableValues, 0 };
#else
    { 9, 7, JSGeolocationPrototypeTableValues, 0 };
#endif

const ClassInfo JSGeolocationPrototype::s_info = { "GeolocationPrototype", 0, &JSGeolocationPrototypeTable, 0 };

JSObject* JSGeolocationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSGeolocation>(exec, globalObject);
}

bool JSGeolocationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSGeolocationPrototypeTable, this, propertyName, slot);
}

bool JSGeolocationPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSGeolocationPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSGeolocation::s_info = { "Geolocation", 0, &JSGeolocationTable, 0 };

JSGeolocation::JSGeolocation(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Geolocation> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSGeolocation::~JSGeolocation()
{
    forgetDOMObject(this, impl());
}

JSObject* JSGeolocation::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSGeolocationPrototype(JSGeolocationPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSGeolocation::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSGeolocation, Base>(exec, &JSGeolocationTable, this, propertyName, slot);
}

bool JSGeolocation::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSGeolocation, Base>(exec, &JSGeolocationTable, this, propertyName, descriptor);
}

JSValue jsGeolocationLastPosition(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSGeolocation* castedThis = static_cast<JSGeolocation*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Geolocation* imp = static_cast<Geolocation*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->lastPosition()));
    return result;
}

JSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionGetCurrentPosition(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSGeolocation::s_info))
        return throwError(exec, TypeError);
    JSGeolocation* castedThisObj = static_cast<JSGeolocation*>(asObject(thisValue));
    return castedThisObj->getCurrentPosition(exec, args);
}

JSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionWatchPosition(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSGeolocation::s_info))
        return throwError(exec, TypeError);
    JSGeolocation* castedThisObj = static_cast<JSGeolocation*>(asObject(thisValue));
    return castedThisObj->watchPosition(exec, args);
}

JSValue JSC_HOST_CALL jsGeolocationPrototypeFunctionClearWatch(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSGeolocation::s_info))
        return throwError(exec, TypeError);
    JSGeolocation* castedThisObj = static_cast<JSGeolocation*>(asObject(thisValue));
    Geolocation* imp = static_cast<Geolocation*>(castedThisObj->impl());
    int watchId = args.at(0).toInt32(exec);

    imp->clearWatch(watchId);
    return jsUndefined();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Geolocation* object)
{
    return getDOMObjectWrapper<JSGeolocation>(exec, globalObject, object);
}
Geolocation* toGeolocation(JSC::JSValue value)
{
    return value.inherits(&JSGeolocation::s_info) ? static_cast<JSGeolocation*>(asObject(value))->impl() : 0;
}

}
