/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATAGRID)

#include "JSHTMLDataGridCellElement.h"

#include "HTMLDataGridCellElement.h"
#include "KURL.h"
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDataGridCellElement);

/* Hash table */

static const HashTableValue JSHTMLDataGridCellElementTableValues[7] =
{
    { "label", DontDelete, (intptr_t)jsHTMLDataGridCellElementLabel, (intptr_t)setJSHTMLDataGridCellElementLabel },
    { "focused", DontDelete, (intptr_t)jsHTMLDataGridCellElementFocused, (intptr_t)setJSHTMLDataGridCellElementFocused },
    { "checked", DontDelete, (intptr_t)jsHTMLDataGridCellElementChecked, (intptr_t)setJSHTMLDataGridCellElementChecked },
    { "indeterminate", DontDelete, (intptr_t)jsHTMLDataGridCellElementIndeterminate, (intptr_t)setJSHTMLDataGridCellElementIndeterminate },
    { "progress", DontDelete, (intptr_t)jsHTMLDataGridCellElementProgress, (intptr_t)setJSHTMLDataGridCellElementProgress },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLDataGridCellElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridCellElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSHTMLDataGridCellElementTableValues, 0 };
#else
    { 17, 15, JSHTMLDataGridCellElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLDataGridCellElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridCellElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDataGridCellElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLDataGridCellElementConstructorTableValues, 0 };
#endif

class JSHTMLDataGridCellElementConstructor : public DOMConstructorObject {
public:
    JSHTMLDataGridCellElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLDataGridCellElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDataGridCellElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLDataGridCellElementConstructor::s_info = { "HTMLDataGridCellElementConstructor", 0, &JSHTMLDataGridCellElementConstructorTable, 0 };

bool JSHTMLDataGridCellElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDataGridCellElementConstructor, DOMObject>(exec, &JSHTMLDataGridCellElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLDataGridCellElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDataGridCellElementConstructor, DOMObject>(exec, &JSHTMLDataGridCellElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDataGridCellElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridCellElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDataGridCellElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLDataGridCellElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLDataGridCellElementPrototype::s_info = { "HTMLDataGridCellElementPrototype", 0, &JSHTMLDataGridCellElementPrototypeTable, 0 };

JSObject* JSHTMLDataGridCellElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDataGridCellElement>(exec, globalObject);
}

const ClassInfo JSHTMLDataGridCellElement::s_info = { "HTMLDataGridCellElement", &JSHTMLElement::s_info, &JSHTMLDataGridCellElementTable, 0 };

JSHTMLDataGridCellElement::JSHTMLDataGridCellElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDataGridCellElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLDataGridCellElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLDataGridCellElementPrototype(JSHTMLDataGridCellElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLDataGridCellElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDataGridCellElement, Base>(exec, &JSHTMLDataGridCellElementTable, this, propertyName, slot);
}

bool JSHTMLDataGridCellElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDataGridCellElement, Base>(exec, &JSHTMLDataGridCellElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLDataGridCellElementLabel(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->label());
    return result;
}

JSValue jsHTMLDataGridCellElementFocused(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->focused());
    return result;
}

JSValue jsHTMLDataGridCellElementChecked(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->checked());
    return result;
}

JSValue jsHTMLDataGridCellElementIndeterminate(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->indeterminate());
    return result;
}

JSValue jsHTMLDataGridCellElementProgress(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataGridCellElement* castedThis = static_cast<JSHTMLDataGridCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->progress());
    return result;
}

JSValue jsHTMLDataGridCellElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataGridCellElement* domObject = static_cast<JSHTMLDataGridCellElement*>(asObject(slot.slotBase()));
    return JSHTMLDataGridCellElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLDataGridCellElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLDataGridCellElement, Base>(exec, propertyName, value, &JSHTMLDataGridCellElementTable, this, slot);
}

void setJSHTMLDataGridCellElementLabel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridCellElement* castedThisObj = static_cast<JSHTMLDataGridCellElement*>(thisObject);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThisObj->impl());
    imp->setLabel(value.toString(exec));
}

void setJSHTMLDataGridCellElementFocused(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridCellElement* castedThisObj = static_cast<JSHTMLDataGridCellElement*>(thisObject);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThisObj->impl());
    imp->setFocused(value.toBoolean(exec));
}

void setJSHTMLDataGridCellElementChecked(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridCellElement* castedThisObj = static_cast<JSHTMLDataGridCellElement*>(thisObject);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThisObj->impl());
    imp->setChecked(value.toBoolean(exec));
}

void setJSHTMLDataGridCellElementIndeterminate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridCellElement* castedThisObj = static_cast<JSHTMLDataGridCellElement*>(thisObject);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThisObj->impl());
    imp->setIndeterminate(value.toBoolean(exec));
}

void setJSHTMLDataGridCellElementProgress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridCellElement* castedThisObj = static_cast<JSHTMLDataGridCellElement*>(thisObject);
    HTMLDataGridCellElement* imp = static_cast<HTMLDataGridCellElement*>(castedThisObj->impl());
    imp->setProgress(value.toFloat(exec));
}

JSValue JSHTMLDataGridCellElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDataGridCellElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(DATAGRID)
