/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATAGRID)

#include "JSHTMLDataGridRowElement.h"

#include "HTMLDataGridRowElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDataGridRowElement);

/* Hash table */

static const HashTableValue JSHTMLDataGridRowElementTableValues[5] =
{
    { "selected", DontDelete, (intptr_t)jsHTMLDataGridRowElementSelected, (intptr_t)setJSHTMLDataGridRowElementSelected },
    { "focused", DontDelete, (intptr_t)jsHTMLDataGridRowElementFocused, (intptr_t)setJSHTMLDataGridRowElementFocused },
    { "expanded", DontDelete, (intptr_t)jsHTMLDataGridRowElementExpanded, (intptr_t)setJSHTMLDataGridRowElementExpanded },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLDataGridRowElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridRowElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSHTMLDataGridRowElementTableValues, 0 };
#else
    { 10, 7, JSHTMLDataGridRowElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLDataGridRowElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridRowElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDataGridRowElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLDataGridRowElementConstructorTableValues, 0 };
#endif

class JSHTMLDataGridRowElementConstructor : public DOMConstructorObject {
public:
    JSHTMLDataGridRowElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLDataGridRowElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDataGridRowElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLDataGridRowElementConstructor::s_info = { "HTMLDataGridRowElementConstructor", 0, &JSHTMLDataGridRowElementConstructorTable, 0 };

bool JSHTMLDataGridRowElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDataGridRowElementConstructor, DOMObject>(exec, &JSHTMLDataGridRowElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLDataGridRowElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDataGridRowElementConstructor, DOMObject>(exec, &JSHTMLDataGridRowElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDataGridRowElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDataGridRowElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDataGridRowElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLDataGridRowElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLDataGridRowElementPrototype::s_info = { "HTMLDataGridRowElementPrototype", 0, &JSHTMLDataGridRowElementPrototypeTable, 0 };

JSObject* JSHTMLDataGridRowElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDataGridRowElement>(exec, globalObject);
}

const ClassInfo JSHTMLDataGridRowElement::s_info = { "HTMLDataGridRowElement", &JSHTMLElement::s_info, &JSHTMLDataGridRowElementTable, 0 };

JSHTMLDataGridRowElement::JSHTMLDataGridRowElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDataGridRowElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLDataGridRowElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLDataGridRowElementPrototype(JSHTMLDataGridRowElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLDataGridRowElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDataGridRowElement, Base>(exec, &JSHTMLDataGridRowElementTable, this, propertyName, slot);
}

bool JSHTMLDataGridRowElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDataGridRowElement, Base>(exec, &JSHTMLDataGridRowElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLDataGridRowElementSelected(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataGridRowElement* castedThis = static_cast<JSHTMLDataGridRowElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->selected());
    return result;
}

JSValue jsHTMLDataGridRowElementFocused(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataGridRowElement* castedThis = static_cast<JSHTMLDataGridRowElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->focused());
    return result;
}

JSValue jsHTMLDataGridRowElementExpanded(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataGridRowElement* castedThis = static_cast<JSHTMLDataGridRowElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->expanded());
    return result;
}

JSValue jsHTMLDataGridRowElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataGridRowElement* domObject = static_cast<JSHTMLDataGridRowElement*>(asObject(slot.slotBase()));
    return JSHTMLDataGridRowElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLDataGridRowElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLDataGridRowElement, Base>(exec, propertyName, value, &JSHTMLDataGridRowElementTable, this, slot);
}

void setJSHTMLDataGridRowElementSelected(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridRowElement* castedThisObj = static_cast<JSHTMLDataGridRowElement*>(thisObject);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThisObj->impl());
    imp->setSelected(value.toBoolean(exec));
}

void setJSHTMLDataGridRowElementFocused(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridRowElement* castedThisObj = static_cast<JSHTMLDataGridRowElement*>(thisObject);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThisObj->impl());
    imp->setFocused(value.toBoolean(exec));
}

void setJSHTMLDataGridRowElementExpanded(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLDataGridRowElement* castedThisObj = static_cast<JSHTMLDataGridRowElement*>(thisObject);
    HTMLDataGridRowElement* imp = static_cast<HTMLDataGridRowElement*>(castedThisObj->impl());
    imp->setExpanded(value.toBoolean(exec));
}

JSValue JSHTMLDataGridRowElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDataGridRowElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(DATAGRID)
