/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(DATALIST)

#include "JSHTMLDataListElement.h"

#include "HTMLCollection.h"
#include "HTMLDataListElement.h"
#include "JSHTMLCollection.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDataListElement);

/* Hash table */

static const HashTableValue JSHTMLDataListElementTableValues[3] =
{
    { "options", DontDelete|ReadOnly, (intptr_t)jsHTMLDataListElementOptions, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLDataListElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDataListElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSHTMLDataListElementTableValues, 0 };
#else
    { 4, 3, JSHTMLDataListElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLDataListElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDataListElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDataListElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLDataListElementConstructorTableValues, 0 };
#endif

class JSHTMLDataListElementConstructor : public DOMConstructorObject {
public:
    JSHTMLDataListElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLDataListElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDataListElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLDataListElementConstructor::s_info = { "HTMLDataListElementConstructor", 0, &JSHTMLDataListElementConstructorTable, 0 };

bool JSHTMLDataListElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDataListElementConstructor, DOMObject>(exec, &JSHTMLDataListElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLDataListElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDataListElementConstructor, DOMObject>(exec, &JSHTMLDataListElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDataListElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLDataListElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDataListElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLDataListElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLDataListElementPrototype::s_info = { "HTMLDataListElementPrototype", 0, &JSHTMLDataListElementPrototypeTable, 0 };

JSObject* JSHTMLDataListElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDataListElement>(exec, globalObject);
}

const ClassInfo JSHTMLDataListElement::s_info = { "HTMLDataListElement", &JSHTMLElement::s_info, &JSHTMLDataListElementTable, 0 };

JSHTMLDataListElement::JSHTMLDataListElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDataListElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLDataListElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLDataListElementPrototype(JSHTMLDataListElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLDataListElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDataListElement, Base>(exec, &JSHTMLDataListElementTable, this, propertyName, slot);
}

bool JSHTMLDataListElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDataListElement, Base>(exec, &JSHTMLDataListElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLDataListElementOptions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataListElement* castedThis = static_cast<JSHTMLDataListElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLDataListElement* imp = static_cast<HTMLDataListElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->options()));
    return result;
}

JSValue jsHTMLDataListElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLDataListElement* domObject = static_cast<JSHTMLDataListElement*>(asObject(slot.slotBase()));
    return JSHTMLDataListElement::getConstructor(exec, domObject->globalObject());
}
JSValue JSHTMLDataListElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDataListElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(DATALIST)
