/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLFrameElement.h"

#include "DOMWindow.h"
#include "Document.h"
#include "HTMLFrameElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "JSDocument.h"
#include "JSSVGDocument.h"
#include "KURL.h"
#include "SVGDocument.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLFrameElement);

/* Hash table */

static const HashTableValue JSHTMLFrameElementTableValues[15] =
{
    { "frameBorder", DontDelete, (intptr_t)jsHTMLFrameElementFrameBorder, (intptr_t)setJSHTMLFrameElementFrameBorder },
    { "longDesc", DontDelete, (intptr_t)jsHTMLFrameElementLongDesc, (intptr_t)setJSHTMLFrameElementLongDesc },
    { "marginHeight", DontDelete, (intptr_t)jsHTMLFrameElementMarginHeight, (intptr_t)setJSHTMLFrameElementMarginHeight },
    { "marginWidth", DontDelete, (intptr_t)jsHTMLFrameElementMarginWidth, (intptr_t)setJSHTMLFrameElementMarginWidth },
    { "name", DontDelete, (intptr_t)jsHTMLFrameElementName, (intptr_t)setJSHTMLFrameElementName },
    { "noResize", DontDelete, (intptr_t)jsHTMLFrameElementNoResize, (intptr_t)setJSHTMLFrameElementNoResize },
    { "scrolling", DontDelete, (intptr_t)jsHTMLFrameElementScrolling, (intptr_t)setJSHTMLFrameElementScrolling },
    { "src", DontDelete, (intptr_t)jsHTMLFrameElementSrc, (intptr_t)setJSHTMLFrameElementSrc },
    { "contentDocument", DontDelete|ReadOnly, (intptr_t)jsHTMLFrameElementContentDocument, (intptr_t)0 },
    { "contentWindow", DontDelete|ReadOnly, (intptr_t)jsHTMLFrameElementContentWindow, (intptr_t)0 },
    { "location", DontDelete, (intptr_t)jsHTMLFrameElementLocation, (intptr_t)setJSHTMLFrameElementLocation },
    { "width", DontDelete|ReadOnly, (intptr_t)jsHTMLFrameElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsHTMLFrameElementHeight, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLFrameElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLFrameElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 16383, JSHTMLFrameElementTableValues, 0 };
#else
    { 36, 31, JSHTMLFrameElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLFrameElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLFrameElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLFrameElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLFrameElementConstructorTableValues, 0 };
#endif

class JSHTMLFrameElementConstructor : public DOMConstructorObject {
public:
    JSHTMLFrameElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLFrameElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLFrameElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLFrameElementConstructor::s_info = { "HTMLFrameElementConstructor", 0, &JSHTMLFrameElementConstructorTable, 0 };

bool JSHTMLFrameElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFrameElementConstructor, DOMObject>(exec, &JSHTMLFrameElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLFrameElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLFrameElementConstructor, DOMObject>(exec, &JSHTMLFrameElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLFrameElementPrototypeTableValues[2] =
{
    { "getSVGDocument", DontDelete|Function, (intptr_t)jsHTMLFrameElementPrototypeFunctionGetSVGDocument, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLFrameElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLFrameElementPrototypeTableValues, 0 };
#else
    { 2, 1, JSHTMLFrameElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLFrameElementPrototype::s_info = { "HTMLFrameElementPrototype", 0, &JSHTMLFrameElementPrototypeTable, 0 };

JSObject* JSHTMLFrameElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLFrameElement>(exec, globalObject);
}

bool JSHTMLFrameElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLFrameElementPrototypeTable, this, propertyName, slot);
}

bool JSHTMLFrameElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLFrameElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHTMLFrameElement::s_info = { "HTMLFrameElement", &JSHTMLElement::s_info, &JSHTMLFrameElementTable, 0 };

JSHTMLFrameElement::JSHTMLFrameElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLFrameElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLFrameElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLFrameElementPrototype(JSHTMLFrameElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLFrameElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLFrameElement, Base>(exec, &JSHTMLFrameElementTable, this, propertyName, slot);
}

bool JSHTMLFrameElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLFrameElement, Base>(exec, &JSHTMLFrameElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLFrameElementFrameBorder(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::frameborderAttr));
    return result;
}

JSValue jsHTMLFrameElementLongDesc(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::longdescAttr));
    return result;
}

JSValue jsHTMLFrameElementMarginHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::marginheightAttr));
    return result;
}

JSValue jsHTMLFrameElementMarginWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::marginwidthAttr));
    return result;
}

JSValue jsHTMLFrameElementName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::nameAttr));
    return result;
}

JSValue jsHTMLFrameElementNoResize(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->noResize());
    return result;
}

JSValue jsHTMLFrameElementScrolling(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::scrollingAttr));
    return result;
}

JSValue jsHTMLFrameElementSrc(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(HTMLNames::srcAttr));
    return result;
}

JSValue jsHTMLFrameElementContentDocument(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    return checkNodeSecurity(exec, imp->contentDocument()) ? toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->contentDocument())) : jsUndefined();
}

JSValue jsHTMLFrameElementContentWindow(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->contentWindow()));
    return result;
}

JSValue jsHTMLFrameElementLocation(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->location());
    return result;
}

JSValue jsHTMLFrameElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->width());
    return result;
}

JSValue jsHTMLFrameElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* castedThis = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->height());
    return result;
}

JSValue jsHTMLFrameElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLFrameElement* domObject = static_cast<JSHTMLFrameElement*>(asObject(slot.slotBase()));
    return JSHTMLFrameElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLFrameElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLFrameElement, Base>(exec, propertyName, value, &JSHTMLFrameElementTable, this, slot);
}

void setJSHTMLFrameElementFrameBorder(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLFrameElement* castedThisObj = static_cast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::frameborderAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLFrameElementLongDesc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLFrameElement* castedThisObj = static_cast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::longdescAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLFrameElementMarginHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLFrameElement* castedThisObj = static_cast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::marginheightAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLFrameElementMarginWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLFrameElement* castedThisObj = static_cast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::marginwidthAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLFrameElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLFrameElement* castedThisObj = static_cast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLFrameElementNoResize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLFrameElement* castedThisObj = static_cast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThisObj->impl());
    imp->setNoResize(value.toBoolean(exec));
}

void setJSHTMLFrameElementScrolling(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLFrameElement* castedThisObj = static_cast<JSHTMLFrameElement*>(thisObject);
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::scrollingAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLFrameElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSHTMLFrameElement*>(thisObject)->setSrc(exec, value);
}

void setJSHTMLFrameElementLocation(ExecState* exec, JSObject* thisObject, JSValue value)
{
    static_cast<JSHTMLFrameElement*>(thisObject)->setLocation(exec, value);
}

JSValue JSHTMLFrameElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLFrameElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsHTMLFrameElementPrototypeFunctionGetSVGDocument(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLFrameElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLFrameElement* castedThisObj = static_cast<JSHTMLFrameElement*>(asObject(thisValue));
    HTMLFrameElement* imp = static_cast<HTMLFrameElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    if (!checkNodeSecurity(exec, imp->getSVGDocument(ec)))
        return jsUndefined();


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getSVGDocument(ec)));
    setDOMException(exec, ec);
    return result;
}


}
