/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLHeadElement.h"

#include "HTMLHeadElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLHeadElement);

/* Hash table */

static const HashTableValue JSHTMLHeadElementTableValues[3] =
{
    { "profile", DontDelete, (intptr_t)jsHTMLHeadElementProfile, (intptr_t)setJSHTMLHeadElementProfile },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLHeadElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLHeadElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSHTMLHeadElementTableValues, 0 };
#else
    { 5, 3, JSHTMLHeadElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLHeadElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLHeadElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLHeadElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLHeadElementConstructorTableValues, 0 };
#endif

class JSHTMLHeadElementConstructor : public DOMConstructorObject {
public:
    JSHTMLHeadElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLHeadElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLHeadElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLHeadElementConstructor::s_info = { "HTMLHeadElementConstructor", 0, &JSHTMLHeadElementConstructorTable, 0 };

bool JSHTMLHeadElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHeadElementConstructor, DOMObject>(exec, &JSHTMLHeadElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLHeadElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLHeadElementConstructor, DOMObject>(exec, &JSHTMLHeadElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLHeadElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLHeadElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLHeadElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLHeadElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLHeadElementPrototype::s_info = { "HTMLHeadElementPrototype", 0, &JSHTMLHeadElementPrototypeTable, 0 };

JSObject* JSHTMLHeadElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLHeadElement>(exec, globalObject);
}

const ClassInfo JSHTMLHeadElement::s_info = { "HTMLHeadElement", &JSHTMLElement::s_info, &JSHTMLHeadElementTable, 0 };

JSHTMLHeadElement::JSHTMLHeadElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLHeadElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLHeadElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLHeadElementPrototype(JSHTMLHeadElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLHeadElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHeadElement, Base>(exec, &JSHTMLHeadElementTable, this, propertyName, slot);
}

bool JSHTMLHeadElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLHeadElement, Base>(exec, &JSHTMLHeadElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLHeadElementProfile(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLHeadElement* castedThis = static_cast<JSHTMLHeadElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLHeadElement* imp = static_cast<HTMLHeadElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->profile());
    return result;
}

JSValue jsHTMLHeadElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLHeadElement* domObject = static_cast<JSHTMLHeadElement*>(asObject(slot.slotBase()));
    return JSHTMLHeadElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLHeadElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLHeadElement, Base>(exec, propertyName, value, &JSHTMLHeadElementTable, this, slot);
}

void setJSHTMLHeadElementProfile(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLHeadElement* castedThisObj = static_cast<JSHTMLHeadElement*>(thisObject);
    HTMLHeadElement* imp = static_cast<HTMLHeadElement*>(castedThisObj->impl());
    imp->setProfile(valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLHeadElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLHeadElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
