/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLImageElement.h"

#include "HTMLImageElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLImageElement);

/* Hash table */

static const HashTableValue JSHTMLImageElementTableValues[20] =
{
    { "name", DontDelete, (intptr_t)jsHTMLImageElementName, (intptr_t)setJSHTMLImageElementName },
    { "align", DontDelete, (intptr_t)jsHTMLImageElementAlign, (intptr_t)setJSHTMLImageElementAlign },
    { "alt", DontDelete, (intptr_t)jsHTMLImageElementAlt, (intptr_t)setJSHTMLImageElementAlt },
    { "border", DontDelete, (intptr_t)jsHTMLImageElementBorder, (intptr_t)setJSHTMLImageElementBorder },
    { "height", DontDelete, (intptr_t)jsHTMLImageElementHeight, (intptr_t)setJSHTMLImageElementHeight },
    { "hspace", DontDelete, (intptr_t)jsHTMLImageElementHspace, (intptr_t)setJSHTMLImageElementHspace },
    { "isMap", DontDelete, (intptr_t)jsHTMLImageElementIsMap, (intptr_t)setJSHTMLImageElementIsMap },
    { "longDesc", DontDelete, (intptr_t)jsHTMLImageElementLongDesc, (intptr_t)setJSHTMLImageElementLongDesc },
    { "src", DontDelete, (intptr_t)jsHTMLImageElementSrc, (intptr_t)setJSHTMLImageElementSrc },
    { "useMap", DontDelete, (intptr_t)jsHTMLImageElementUseMap, (intptr_t)setJSHTMLImageElementUseMap },
    { "vspace", DontDelete, (intptr_t)jsHTMLImageElementVspace, (intptr_t)setJSHTMLImageElementVspace },
    { "width", DontDelete, (intptr_t)jsHTMLImageElementWidth, (intptr_t)setJSHTMLImageElementWidth },
    { "complete", DontDelete|ReadOnly, (intptr_t)jsHTMLImageElementComplete, (intptr_t)0 },
    { "lowsrc", DontDelete, (intptr_t)jsHTMLImageElementLowsrc, (intptr_t)setJSHTMLImageElementLowsrc },
    { "naturalHeight", DontDelete|ReadOnly, (intptr_t)jsHTMLImageElementNaturalHeight, (intptr_t)0 },
    { "naturalWidth", DontDelete|ReadOnly, (intptr_t)jsHTMLImageElementNaturalWidth, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsHTMLImageElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsHTMLImageElementY, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLImageElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLImageElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 16383, JSHTMLImageElementTableValues, 0 };
#else
    { 67, 63, JSHTMLImageElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLImageElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLImageElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLImageElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLImageElementConstructorTableValues, 0 };
#endif

class JSHTMLImageElementConstructor : public DOMConstructorObject {
public:
    JSHTMLImageElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLImageElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLImageElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLImageElementConstructor::s_info = { "HTMLImageElementConstructor", 0, &JSHTMLImageElementConstructorTable, 0 };

bool JSHTMLImageElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLImageElementConstructor, DOMObject>(exec, &JSHTMLImageElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLImageElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLImageElementConstructor, DOMObject>(exec, &JSHTMLImageElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLImageElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLImageElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLImageElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLImageElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLImageElementPrototype::s_info = { "HTMLImageElementPrototype", 0, &JSHTMLImageElementPrototypeTable, 0 };

JSObject* JSHTMLImageElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLImageElement>(exec, globalObject);
}

const ClassInfo JSHTMLImageElement::s_info = { "HTMLImageElement", &JSHTMLElement::s_info, &JSHTMLImageElementTable, 0 };

JSHTMLImageElement::JSHTMLImageElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLImageElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLImageElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLImageElementPrototype(JSHTMLImageElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLImageElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLImageElement, Base>(exec, &JSHTMLImageElementTable, this, propertyName, slot);
}

bool JSHTMLImageElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLImageElement, Base>(exec, &JSHTMLImageElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLImageElementName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::nameAttr));
    return result;
}

JSValue jsHTMLImageElementAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::alignAttr));
    return result;
}

JSValue jsHTMLImageElementAlt(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::altAttr));
    return result;
}

JSValue jsHTMLImageElementBorder(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::borderAttr));
    return result;
}

JSValue jsHTMLImageElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->height());
    return result;
}

JSValue jsHTMLImageElementHspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->hspace());
    return result;
}

JSValue jsHTMLImageElementIsMap(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->isMap());
    return result;
}

JSValue jsHTMLImageElementLongDesc(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(HTMLNames::longdescAttr));
    return result;
}

JSValue jsHTMLImageElementSrc(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(HTMLNames::srcAttr));
    return result;
}

JSValue jsHTMLImageElementUseMap(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::usemapAttr));
    return result;
}

JSValue jsHTMLImageElementVspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->vspace());
    return result;
}

JSValue jsHTMLImageElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->width());
    return result;
}

JSValue jsHTMLImageElementComplete(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->complete());
    return result;
}

JSValue jsHTMLImageElementLowsrc(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(HTMLNames::lowsrcAttr));
    return result;
}

JSValue jsHTMLImageElementNaturalHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->naturalHeight());
    return result;
}

JSValue jsHTMLImageElementNaturalWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->naturalWidth());
    return result;
}

JSValue jsHTMLImageElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->x());
    return result;
}

JSValue jsHTMLImageElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* castedThis = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->y());
    return result;
}

JSValue jsHTMLImageElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLImageElement* domObject = static_cast<JSHTMLImageElement*>(asObject(slot.slotBase()));
    return JSHTMLImageElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLImageElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLImageElement, Base>(exec, propertyName, value, &JSHTMLImageElementTable, this, slot);
}

void setJSHTMLImageElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLImageElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::alignAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLImageElementAlt(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::altAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLImageElementBorder(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::borderAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLImageElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setHeight(value.toInt32(exec));
}

void setJSHTMLImageElementHspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setHspace(value.toInt32(exec));
}

void setJSHTMLImageElementIsMap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setIsMap(value.toBoolean(exec));
}

void setJSHTMLImageElementLongDesc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::longdescAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLImageElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::srcAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLImageElementUseMap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::usemapAttr, valueToStringWithNullCheck(exec, value));
}

void setJSHTMLImageElementVspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setVspace(value.toInt32(exec));
}

void setJSHTMLImageElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setWidth(value.toInt32(exec));
}

void setJSHTMLImageElementLowsrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLImageElement* castedThisObj = static_cast<JSHTMLImageElement*>(thisObject);
    HTMLImageElement* imp = static_cast<HTMLImageElement*>(castedThisObj->impl());
    imp->setAttribute(HTMLNames::lowsrcAttr, valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLImageElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLImageElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
