/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLIsIndexElement.h"

#include "HTMLFormElement.h"
#include "HTMLIsIndexElement.h"
#include "JSHTMLFormElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLIsIndexElement);

/* Hash table */

static const HashTableValue JSHTMLIsIndexElementTableValues[4] =
{
    { "form", DontDelete|ReadOnly, (intptr_t)jsHTMLIsIndexElementForm, (intptr_t)0 },
    { "prompt", DontDelete, (intptr_t)jsHTMLIsIndexElementPrompt, (intptr_t)setJSHTMLIsIndexElementPrompt },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLIsIndexElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLIsIndexElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSHTMLIsIndexElementTableValues, 0 };
#else
    { 8, 7, JSHTMLIsIndexElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLIsIndexElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLIsIndexElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLIsIndexElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLIsIndexElementConstructorTableValues, 0 };
#endif

class JSHTMLIsIndexElementConstructor : public DOMConstructorObject {
public:
    JSHTMLIsIndexElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLIsIndexElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLIsIndexElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLIsIndexElementConstructor::s_info = { "HTMLIsIndexElementConstructor", 0, &JSHTMLIsIndexElementConstructorTable, 0 };

bool JSHTMLIsIndexElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLIsIndexElementConstructor, DOMObject>(exec, &JSHTMLIsIndexElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLIsIndexElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLIsIndexElementConstructor, DOMObject>(exec, &JSHTMLIsIndexElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLIsIndexElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLIsIndexElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLIsIndexElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLIsIndexElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLIsIndexElementPrototype::s_info = { "HTMLIsIndexElementPrototype", 0, &JSHTMLIsIndexElementPrototypeTable, 0 };

JSObject* JSHTMLIsIndexElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLIsIndexElement>(exec, globalObject);
}

const ClassInfo JSHTMLIsIndexElement::s_info = { "HTMLIsIndexElement", &JSHTMLInputElement::s_info, &JSHTMLIsIndexElementTable, 0 };

JSHTMLIsIndexElement::JSHTMLIsIndexElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLIsIndexElement> impl)
    : JSHTMLInputElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLIsIndexElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLIsIndexElementPrototype(JSHTMLIsIndexElementPrototype::createStructure(JSHTMLInputElementPrototype::self(exec, globalObject)));
}

bool JSHTMLIsIndexElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLIsIndexElement, Base>(exec, &JSHTMLIsIndexElementTable, this, propertyName, slot);
}

bool JSHTMLIsIndexElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLIsIndexElement, Base>(exec, &JSHTMLIsIndexElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLIsIndexElementForm(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLIsIndexElement* castedThis = static_cast<JSHTMLIsIndexElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLIsIndexElement* imp = static_cast<HTMLIsIndexElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->form()));
    return result;
}

JSValue jsHTMLIsIndexElementPrompt(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLIsIndexElement* castedThis = static_cast<JSHTMLIsIndexElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLIsIndexElement* imp = static_cast<HTMLIsIndexElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->prompt());
    return result;
}

JSValue jsHTMLIsIndexElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLIsIndexElement* domObject = static_cast<JSHTMLIsIndexElement*>(asObject(slot.slotBase()));
    return JSHTMLIsIndexElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLIsIndexElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLIsIndexElement, Base>(exec, propertyName, value, &JSHTMLIsIndexElementTable, this, slot);
}

void setJSHTMLIsIndexElementPrompt(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLIsIndexElement* castedThisObj = static_cast<JSHTMLIsIndexElement*>(thisObject);
    HTMLIsIndexElement* imp = static_cast<HTMLIsIndexElement*>(castedThisObj->impl());
    imp->setPrompt(valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLIsIndexElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLIsIndexElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
