/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLMarqueeElement.h"

#include "HTMLMarqueeElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLMarqueeElement);

/* Hash table */

static const HashTableValue JSHTMLMarqueeElementTableValues[2] =
{
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLMarqueeElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLMarqueeElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLMarqueeElementTableValues, 0 };
#else
    { 2, 1, JSHTMLMarqueeElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLMarqueeElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLMarqueeElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLMarqueeElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLMarqueeElementConstructorTableValues, 0 };
#endif

class JSHTMLMarqueeElementConstructor : public DOMConstructorObject {
public:
    JSHTMLMarqueeElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLMarqueeElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLMarqueeElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLMarqueeElementConstructor::s_info = { "HTMLMarqueeElementConstructor", 0, &JSHTMLMarqueeElementConstructorTable, 0 };

bool JSHTMLMarqueeElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMarqueeElementConstructor, DOMObject>(exec, &JSHTMLMarqueeElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLMarqueeElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLMarqueeElementConstructor, DOMObject>(exec, &JSHTMLMarqueeElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLMarqueeElementPrototypeTableValues[3] =
{
    { "start", DontDelete|Function, (intptr_t)jsHTMLMarqueeElementPrototypeFunctionStart, (intptr_t)0 },
    { "stop", DontDelete|Function, (intptr_t)jsHTMLMarqueeElementPrototypeFunctionStop, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLMarqueeElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSHTMLMarqueeElementPrototypeTableValues, 0 };
#else
    { 5, 3, JSHTMLMarqueeElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLMarqueeElementPrototype::s_info = { "HTMLMarqueeElementPrototype", 0, &JSHTMLMarqueeElementPrototypeTable, 0 };

JSObject* JSHTMLMarqueeElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLMarqueeElement>(exec, globalObject);
}

bool JSHTMLMarqueeElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLMarqueeElementPrototypeTable, this, propertyName, slot);
}

bool JSHTMLMarqueeElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLMarqueeElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHTMLMarqueeElement::s_info = { "HTMLMarqueeElement", &JSHTMLElement::s_info, &JSHTMLMarqueeElementTable, 0 };

JSHTMLMarqueeElement::JSHTMLMarqueeElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLMarqueeElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLMarqueeElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLMarqueeElementPrototype(JSHTMLMarqueeElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLMarqueeElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMarqueeElement, Base>(exec, &JSHTMLMarqueeElementTable, this, propertyName, slot);
}

bool JSHTMLMarqueeElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLMarqueeElement, Base>(exec, &JSHTMLMarqueeElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLMarqueeElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLMarqueeElement* domObject = static_cast<JSHTMLMarqueeElement*>(asObject(slot.slotBase()));
    return JSHTMLMarqueeElement::getConstructor(exec, domObject->globalObject());
}
JSValue JSHTMLMarqueeElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMarqueeElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStart(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLMarqueeElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLMarqueeElement* castedThisObj = static_cast<JSHTMLMarqueeElement*>(asObject(thisValue));
    HTMLMarqueeElement* imp = static_cast<HTMLMarqueeElement*>(castedThisObj->impl());

    imp->start();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStop(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHTMLMarqueeElement::s_info))
        return throwError(exec, TypeError);
    JSHTMLMarqueeElement* castedThisObj = static_cast<JSHTMLMarqueeElement*>(asObject(thisValue));
    HTMLMarqueeElement* imp = static_cast<HTMLMarqueeElement*>(castedThisObj->impl());

    imp->stop();
    return jsUndefined();
}


}
