/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLTableCellElement.h"

#include "HTMLTableCellElement.h"
#include "KURL.h"
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLTableCellElement);

/* Hash table */

static const HashTableValue JSHTMLTableCellElementTableValues[17] =
{
    { "cellIndex", DontDelete|ReadOnly, (intptr_t)jsHTMLTableCellElementCellIndex, (intptr_t)0 },
    { "abbr", DontDelete, (intptr_t)jsHTMLTableCellElementAbbr, (intptr_t)setJSHTMLTableCellElementAbbr },
    { "align", DontDelete, (intptr_t)jsHTMLTableCellElementAlign, (intptr_t)setJSHTMLTableCellElementAlign },
    { "axis", DontDelete, (intptr_t)jsHTMLTableCellElementAxis, (intptr_t)setJSHTMLTableCellElementAxis },
    { "bgColor", DontDelete, (intptr_t)jsHTMLTableCellElementBgColor, (intptr_t)setJSHTMLTableCellElementBgColor },
    { "ch", DontDelete, (intptr_t)jsHTMLTableCellElementCh, (intptr_t)setJSHTMLTableCellElementCh },
    { "chOff", DontDelete, (intptr_t)jsHTMLTableCellElementChOff, (intptr_t)setJSHTMLTableCellElementChOff },
    { "colSpan", DontDelete, (intptr_t)jsHTMLTableCellElementColSpan, (intptr_t)setJSHTMLTableCellElementColSpan },
    { "headers", DontDelete, (intptr_t)jsHTMLTableCellElementHeaders, (intptr_t)setJSHTMLTableCellElementHeaders },
    { "height", DontDelete, (intptr_t)jsHTMLTableCellElementHeight, (intptr_t)setJSHTMLTableCellElementHeight },
    { "noWrap", DontDelete, (intptr_t)jsHTMLTableCellElementNoWrap, (intptr_t)setJSHTMLTableCellElementNoWrap },
    { "rowSpan", DontDelete, (intptr_t)jsHTMLTableCellElementRowSpan, (intptr_t)setJSHTMLTableCellElementRowSpan },
    { "scope", DontDelete, (intptr_t)jsHTMLTableCellElementScope, (intptr_t)setJSHTMLTableCellElementScope },
    { "vAlign", DontDelete, (intptr_t)jsHTMLTableCellElementVAlign, (intptr_t)setJSHTMLTableCellElementVAlign },
    { "width", DontDelete, (intptr_t)jsHTMLTableCellElementWidth, (intptr_t)setJSHTMLTableCellElementWidth },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLTableCellElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLTableCellElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 511, JSHTMLTableCellElementTableValues, 0 };
#else
    { 36, 31, JSHTMLTableCellElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLTableCellElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLTableCellElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLTableCellElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLTableCellElementConstructorTableValues, 0 };
#endif

class JSHTMLTableCellElementConstructor : public DOMConstructorObject {
public:
    JSHTMLTableCellElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSHTMLTableCellElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSHTMLTableCellElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLTableCellElementConstructor::s_info = { "HTMLTableCellElementConstructor", 0, &JSHTMLTableCellElementConstructorTable, 0 };

bool JSHTMLTableCellElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableCellElementConstructor, DOMObject>(exec, &JSHTMLTableCellElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLTableCellElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTableCellElementConstructor, DOMObject>(exec, &JSHTMLTableCellElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTableCellElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHTMLTableCellElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLTableCellElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLTableCellElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLTableCellElementPrototype::s_info = { "HTMLTableCellElementPrototype", 0, &JSHTMLTableCellElementPrototypeTable, 0 };

JSObject* JSHTMLTableCellElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTableCellElement>(exec, globalObject);
}

const ClassInfo JSHTMLTableCellElement::s_info = { "HTMLTableCellElement", &JSHTMLElement::s_info, &JSHTMLTableCellElementTable, 0 };

JSHTMLTableCellElement::JSHTMLTableCellElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTableCellElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

JSObject* JSHTMLTableCellElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLTableCellElementPrototype(JSHTMLTableCellElementPrototype::createStructure(JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLTableCellElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableCellElement, Base>(exec, &JSHTMLTableCellElementTable, this, propertyName, slot);
}

bool JSHTMLTableCellElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTableCellElement, Base>(exec, &JSHTMLTableCellElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLTableCellElementCellIndex(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->cellIndex());
    return result;
}

JSValue jsHTMLTableCellElementAbbr(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->abbr());
    return result;
}

JSValue jsHTMLTableCellElementAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->align());
    return result;
}

JSValue jsHTMLTableCellElementAxis(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->axis());
    return result;
}

JSValue jsHTMLTableCellElementBgColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->bgColor());
    return result;
}

JSValue jsHTMLTableCellElementCh(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->ch());
    return result;
}

JSValue jsHTMLTableCellElementChOff(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->chOff());
    return result;
}

JSValue jsHTMLTableCellElementColSpan(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->colSpan());
    return result;
}

JSValue jsHTMLTableCellElementHeaders(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->headers());
    return result;
}

JSValue jsHTMLTableCellElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->height());
    return result;
}

JSValue jsHTMLTableCellElementNoWrap(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->noWrap());
    return result;
}

JSValue jsHTMLTableCellElementRowSpan(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->rowSpan());
    return result;
}

JSValue jsHTMLTableCellElementScope(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->scope());
    return result;
}

JSValue jsHTMLTableCellElementVAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->vAlign());
    return result;
}

JSValue jsHTMLTableCellElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* castedThis = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->width());
    return result;
}

JSValue jsHTMLTableCellElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHTMLTableCellElement* domObject = static_cast<JSHTMLTableCellElement*>(asObject(slot.slotBase()));
    return JSHTMLTableCellElement::getConstructor(exec, domObject->globalObject());
}
void JSHTMLTableCellElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLTableCellElement, Base>(exec, propertyName, value, &JSHTMLTableCellElementTable, this, slot);
}

void setJSHTMLTableCellElementAbbr(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setAbbr(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setAlign(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementAxis(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setAxis(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementBgColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setBgColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementCh(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setCh(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementChOff(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setChOff(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementColSpan(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setColSpan(value.toInt32(exec));
}

void setJSHTMLTableCellElementHeaders(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setHeaders(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setHeight(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementNoWrap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setNoWrap(value.toBoolean(exec));
}

void setJSHTMLTableCellElementRowSpan(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setRowSpan(value.toInt32(exec));
}

void setJSHTMLTableCellElementScope(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setScope(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementVAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setVAlign(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLTableCellElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTableCellElement* castedThisObj = static_cast<JSHTMLTableCellElement*>(thisObject);
    HTMLTableCellElement* imp = static_cast<HTMLTableCellElement*>(castedThisObj->impl());
    imp->setWidth(valueToStringWithNullCheck(exec, value));
}

JSValue JSHTMLTableCellElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTableCellElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
