/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHistory.h"

#include "History.h"
#include "JSHistoryCustom.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHistory);

/* Hash table */

static const HashTableValue JSHistoryTableValues[2] =
{
    { "length", DontDelete|ReadOnly, (intptr_t)jsHistoryLength, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHistoryTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHistoryTableValues, 0 };
#else
    { 2, 1, JSHistoryTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSHistoryPrototypeTableValues[6] =
{
    { "back", DontDelete|Function, (intptr_t)jsHistoryPrototypeFunctionBack, (intptr_t)0 },
    { "forward", DontDelete|Function, (intptr_t)jsHistoryPrototypeFunctionForward, (intptr_t)0 },
    { "go", DontDelete|Function, (intptr_t)jsHistoryPrototypeFunctionGo, (intptr_t)1 },
    { "pushState", DontDelete|Function, (intptr_t)jsHistoryPrototypeFunctionPushState, (intptr_t)3 },
    { "replaceState", DontDelete|Function, (intptr_t)jsHistoryPrototypeFunctionReplaceState, (intptr_t)3 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSHistoryPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSHistoryPrototypeTableValues, 0 };
#else
    { 17, 15, JSHistoryPrototypeTableValues, 0 };
#endif

const ClassInfo JSHistoryPrototype::s_info = { "HistoryPrototype", 0, &JSHistoryPrototypeTable, 0 };

JSObject* JSHistoryPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHistory>(exec, globalObject);
}

bool JSHistoryPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHistoryPrototypeTable, this, propertyName, slot);
}

bool JSHistoryPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHistoryPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHistory::s_info = { "History", 0, &JSHistoryTable, 0 };

JSHistory::JSHistory(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<History> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSHistory::~JSHistory()
{
    forgetDOMObject(this, impl());
}

JSObject* JSHistory::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHistoryPrototype(JSHistoryPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSHistory::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (getOwnPropertySlotDelegate(exec, propertyName, slot))
        return true;
    return getStaticValueSlot<JSHistory, Base>(exec, &JSHistoryTable, this, propertyName, slot);
}

bool JSHistory::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    if (getOwnPropertyDescriptorDelegate(exec, propertyName, descriptor))
        return true;
    return getStaticValueDescriptor<JSHistory, Base>(exec, &JSHistoryTable, this, propertyName, descriptor);
}

JSValue jsHistoryLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSHistory* castedThis = static_cast<JSHistory*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    History* imp = static_cast<History*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->length());
    return result;
}

void JSHistory::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    if (putDelegate(exec, propertyName, value, slot))
        return;
    Base::put(exec, propertyName, value, slot);
}

JSValue JSC_HOST_CALL jsHistoryPrototypeFunctionBack(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHistory::s_info))
        return throwError(exec, TypeError);
    JSHistory* castedThisObj = static_cast<JSHistory*>(asObject(thisValue));
    History* imp = static_cast<History*>(castedThisObj->impl());

    imp->back();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsHistoryPrototypeFunctionForward(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHistory::s_info))
        return throwError(exec, TypeError);
    JSHistory* castedThisObj = static_cast<JSHistory*>(asObject(thisValue));
    History* imp = static_cast<History*>(castedThisObj->impl());

    imp->forward();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsHistoryPrototypeFunctionGo(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHistory::s_info))
        return throwError(exec, TypeError);
    JSHistory* castedThisObj = static_cast<JSHistory*>(asObject(thisValue));
    History* imp = static_cast<History*>(castedThisObj->impl());
    int distance = args.at(0).toInt32(exec);

    imp->go(distance);
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsHistoryPrototypeFunctionPushState(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHistory::s_info))
        return throwError(exec, TypeError);
    JSHistory* castedThisObj = static_cast<JSHistory*>(asObject(thisValue));
    return castedThisObj->pushState(exec, args);
}

JSValue JSC_HOST_CALL jsHistoryPrototypeFunctionReplaceState(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSHistory::s_info))
        return throwError(exec, TypeError);
    JSHistory* castedThisObj = static_cast<JSHistory*>(asObject(thisValue));
    return castedThisObj->replaceState(exec, args);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, History* object)
{
    return getDOMObjectWrapper<JSHistory>(exec, globalObject, object);
}
History* toHistory(JSC::JSValue value)
{
    return value.inherits(&JSHistory::s_info) ? static_cast<JSHistory*>(asObject(value))->impl() : 0;
}

}
