/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(NOTIFICATIONS)

#include "JSNotification.h"

#include "Event.h"
#include "EventListener.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "Notification.h"
#include "RegisteredEventListener.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSNotification);

/* Hash table */

static const HashTableValue JSNotificationTableValues[4] =
{
    { "ondisplay", DontDelete, (intptr_t)jsNotificationOndisplay, (intptr_t)setJSNotificationOndisplay },
    { "onerror", DontDelete, (intptr_t)jsNotificationOnerror, (intptr_t)setJSNotificationOnerror },
    { "onclose", DontDelete, (intptr_t)jsNotificationOnclose, (intptr_t)setJSNotificationOnclose },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSNotificationTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSNotificationTableValues, 0 };
#else
    { 8, 7, JSNotificationTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSNotificationPrototypeTableValues[6] =
{
    { "show", DontDelete|Function, (intptr_t)jsNotificationPrototypeFunctionShow, (intptr_t)0 },
    { "cancel", DontDelete|Function, (intptr_t)jsNotificationPrototypeFunctionCancel, (intptr_t)0 },
    { "addEventListener", DontDelete|Function, (intptr_t)jsNotificationPrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsNotificationPrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsNotificationPrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSNotificationPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSNotificationPrototypeTableValues, 0 };
#else
    { 16, 15, JSNotificationPrototypeTableValues, 0 };
#endif

const ClassInfo JSNotificationPrototype::s_info = { "NotificationPrototype", 0, &JSNotificationPrototypeTable, 0 };

JSObject* JSNotificationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNotification>(exec, globalObject);
}

bool JSNotificationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSNotificationPrototypeTable, this, propertyName, slot);
}

bool JSNotificationPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSNotificationPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSNotification::s_info = { "Notification", 0, &JSNotificationTable, 0 };

JSNotification::JSNotification(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<Notification> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSNotification::~JSNotification()
{
    impl()->invalidateJSEventListeners(this);
    forgetDOMObject(this, impl());
}

void JSNotification::markChildren(MarkStack& markStack)
{
    Base::markChildren(markStack);
    impl()->markJSEventListeners(markStack);
}

JSObject* JSNotification::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSNotificationPrototype(JSNotificationPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSNotification::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNotification, Base>(exec, &JSNotificationTable, this, propertyName, slot);
}

bool JSNotification::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNotification, Base>(exec, &JSNotificationTable, this, propertyName, descriptor);
}

JSValue jsNotificationOndisplay(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    if (EventListener* listener = imp->ondisplay()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsNotificationOnerror(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsNotificationOnclose(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSNotification* castedThis = static_cast<JSNotification*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(castedThis->impl());
    if (EventListener* listener = imp->onclose()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

void JSNotification::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSNotification, Base>(exec, propertyName, value, &JSNotificationTable, this, slot);
}

void setJSNotificationOndisplay(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(static_cast<JSNotification*>(thisObject)->impl());
    imp->setOndisplay(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSNotificationOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(static_cast<JSNotification*>(thisObject)->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSNotificationOnclose(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    Notification* imp = static_cast<Notification*>(static_cast<JSNotification*>(thisObject)->impl());
    imp->setOnclose(createJSAttributeEventListener(exec, value, thisObject));
}

JSValue JSC_HOST_CALL jsNotificationPrototypeFunctionShow(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwError(exec, TypeError);
    JSNotification* castedThisObj = static_cast<JSNotification*>(asObject(thisValue));
    Notification* imp = static_cast<Notification*>(castedThisObj->impl());

    imp->show();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsNotificationPrototypeFunctionCancel(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwError(exec, TypeError);
    JSNotification* castedThisObj = static_cast<JSNotification*>(asObject(thisValue));
    Notification* imp = static_cast<Notification*>(castedThisObj->impl());

    imp->cancel();
    return jsUndefined();
}

JSValue JSC_HOST_CALL jsNotificationPrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwError(exec, TypeError);
    JSNotification* castedThisObj = static_cast<JSNotification*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsNotificationPrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwError(exec, TypeError);
    JSNotification* castedThisObj = static_cast<JSNotification*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsNotificationPrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSNotification::s_info))
        return throwError(exec, TypeError);
    JSNotification* castedThisObj = static_cast<JSNotification*>(asObject(thisValue));
    Notification* imp = static_cast<Notification*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(args.at(0));


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Notification* object)
{
    return getDOMObjectWrapper<JSNotification>(exec, globalObject, object);
}
Notification* toNotification(JSC::JSValue value)
{
    return value.inherits(&JSNotification::s_info) ? static_cast<JSNotification*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(NOTIFICATIONS)
