/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPageTransitionEvent.h"

#include "PageTransitionEvent.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSPageTransitionEvent);

/* Hash table */

static const HashTableValue JSPageTransitionEventTableValues[3] =
{
    { "persisted", DontDelete|ReadOnly, (intptr_t)jsPageTransitionEventPersisted, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsPageTransitionEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPageTransitionEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSPageTransitionEventTableValues, 0 };
#else
    { 4, 3, JSPageTransitionEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSPageTransitionEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPageTransitionEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSPageTransitionEventConstructorTableValues, 0 };
#else
    { 1, 0, JSPageTransitionEventConstructorTableValues, 0 };
#endif

class JSPageTransitionEventConstructor : public DOMConstructorObject {
public:
    JSPageTransitionEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSPageTransitionEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSPageTransitionEventPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSPageTransitionEventConstructor::s_info = { "PageTransitionEventConstructor", 0, &JSPageTransitionEventConstructorTable, 0 };

bool JSPageTransitionEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPageTransitionEventConstructor, DOMObject>(exec, &JSPageTransitionEventConstructorTable, this, propertyName, slot);
}

bool JSPageTransitionEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPageTransitionEventConstructor, DOMObject>(exec, &JSPageTransitionEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSPageTransitionEventPrototypeTableValues[2] =
{
    { "initPageTransitionEvent", DontDelete|Function, (intptr_t)jsPageTransitionEventPrototypeFunctionInitPageTransitionEvent, (intptr_t)4 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPageTransitionEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSPageTransitionEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSPageTransitionEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSPageTransitionEventPrototype::s_info = { "PageTransitionEventPrototype", 0, &JSPageTransitionEventPrototypeTable, 0 };

JSObject* JSPageTransitionEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPageTransitionEvent>(exec, globalObject);
}

bool JSPageTransitionEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSPageTransitionEventPrototypeTable, this, propertyName, slot);
}

bool JSPageTransitionEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSPageTransitionEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSPageTransitionEvent::s_info = { "PageTransitionEvent", &JSEvent::s_info, &JSPageTransitionEventTable, 0 };

JSPageTransitionEvent::JSPageTransitionEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<PageTransitionEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

JSObject* JSPageTransitionEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSPageTransitionEventPrototype(JSPageTransitionEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSPageTransitionEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPageTransitionEvent, Base>(exec, &JSPageTransitionEventTable, this, propertyName, slot);
}

bool JSPageTransitionEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPageTransitionEvent, Base>(exec, &JSPageTransitionEventTable, this, propertyName, descriptor);
}

JSValue jsPageTransitionEventPersisted(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSPageTransitionEvent* castedThis = static_cast<JSPageTransitionEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    PageTransitionEvent* imp = static_cast<PageTransitionEvent*>(castedThis->impl());
    JSValue result = jsBoolean(imp->persisted());
    return result;
}

JSValue jsPageTransitionEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSPageTransitionEvent* domObject = static_cast<JSPageTransitionEvent*>(asObject(slot.slotBase()));
    return JSPageTransitionEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSPageTransitionEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPageTransitionEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsPageTransitionEventPrototypeFunctionInitPageTransitionEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSPageTransitionEvent::s_info))
        return throwError(exec, TypeError);
    JSPageTransitionEvent* castedThisObj = static_cast<JSPageTransitionEvent*>(asObject(thisValue));
    PageTransitionEvent* imp = static_cast<PageTransitionEvent*>(castedThisObj->impl());
    const UString& typeArg = args.at(0).toString(exec);
    bool canBubbleArg = args.at(1).toBoolean(exec);
    bool cancelableArg = args.at(2).toBoolean(exec);
    bool persisted = args.at(3).toBoolean(exec);

    imp->initPageTransitionEvent(typeArg, canBubbleArg, cancelableArg, persisted);
    return jsUndefined();
}


}
