/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPluginArray.h"

#include "AtomicString.h"
#include "JSPlugin.h"
#include "Plugin.h"
#include "PluginArray.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSPluginArray);

/* Hash table */

static const HashTableValue JSPluginArrayTableValues[3] =
{
    { "length", DontDelete|ReadOnly, (intptr_t)jsPluginArrayLength, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsPluginArrayConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPluginArrayTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSPluginArrayTableValues, 0 };
#else
    { 5, 3, JSPluginArrayTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSPluginArrayConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPluginArrayConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSPluginArrayConstructorTableValues, 0 };
#else
    { 1, 0, JSPluginArrayConstructorTableValues, 0 };
#endif

class JSPluginArrayConstructor : public DOMConstructorObject {
public:
    JSPluginArrayConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSPluginArrayConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSPluginArrayPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSPluginArrayConstructor::s_info = { "PluginArrayConstructor", 0, &JSPluginArrayConstructorTable, 0 };

bool JSPluginArrayConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPluginArrayConstructor, DOMObject>(exec, &JSPluginArrayConstructorTable, this, propertyName, slot);
}

bool JSPluginArrayConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPluginArrayConstructor, DOMObject>(exec, &JSPluginArrayConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSPluginArrayPrototypeTableValues[4] =
{
    { "item", DontDelete|Function, (intptr_t)jsPluginArrayPrototypeFunctionItem, (intptr_t)1 },
    { "namedItem", DontDelete|Function, (intptr_t)jsPluginArrayPrototypeFunctionNamedItem, (intptr_t)1 },
    { "refresh", DontDelete|Function, (intptr_t)jsPluginArrayPrototypeFunctionRefresh, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPluginArrayPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSPluginArrayPrototypeTableValues, 0 };
#else
    { 8, 7, JSPluginArrayPrototypeTableValues, 0 };
#endif

const ClassInfo JSPluginArrayPrototype::s_info = { "PluginArrayPrototype", 0, &JSPluginArrayPrototypeTable, 0 };

JSObject* JSPluginArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPluginArray>(exec, globalObject);
}

bool JSPluginArrayPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSPluginArrayPrototypeTable, this, propertyName, slot);
}

bool JSPluginArrayPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSPluginArrayPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSPluginArray::s_info = { "PluginArray", 0, &JSPluginArrayTable, 0 };

JSPluginArray::JSPluginArray(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<PluginArray> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSPluginArray::~JSPluginArray()
{
    forgetDOMObject(this, impl());
}

JSObject* JSPluginArray::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSPluginArrayPrototype(JSPluginArrayPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSPluginArray::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSPluginArrayTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<PluginArray*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<PluginArray*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSPluginArray, Base>(exec, &JSPluginArrayTable, this, propertyName, slot);
}

bool JSPluginArray::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    const HashEntry* entry = JSPluginArrayTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<PluginArray*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<PluginArray*>(impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(this, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSPluginArray, Base>(exec, &JSPluginArrayTable, this, propertyName, descriptor);
}

bool JSPluginArray::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<PluginArray*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsPluginArrayLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSPluginArray* castedThis = static_cast<JSPluginArray*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    PluginArray* imp = static_cast<PluginArray*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->length());
    return result;
}

JSValue jsPluginArrayConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSPluginArray* domObject = static_cast<JSPluginArray*>(asObject(slot.slotBase()));
    return JSPluginArray::getConstructor(exec, domObject->globalObject());
}
void JSPluginArray::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<PluginArray*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSPluginArray::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPluginArrayConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsPluginArrayPrototypeFunctionItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSPluginArray::s_info))
        return throwError(exec, TypeError);
    JSPluginArray* castedThisObj = static_cast<JSPluginArray*>(asObject(thisValue));
    PluginArray* imp = static_cast<PluginArray*>(castedThisObj->impl());
    unsigned index = args.at(0).toInt32(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->item(index)));
    return result;
}

JSValue JSC_HOST_CALL jsPluginArrayPrototypeFunctionNamedItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSPluginArray::s_info))
        return throwError(exec, TypeError);
    JSPluginArray* castedThisObj = static_cast<JSPluginArray*>(asObject(thisValue));
    PluginArray* imp = static_cast<PluginArray*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->namedItem(name)));
    return result;
}

JSValue JSC_HOST_CALL jsPluginArrayPrototypeFunctionRefresh(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSPluginArray::s_info))
        return throwError(exec, TypeError);
    JSPluginArray* castedThisObj = static_cast<JSPluginArray*>(asObject(thisValue));
    PluginArray* imp = static_cast<PluginArray*>(castedThisObj->impl());
    bool reload = args.at(0).toBoolean(exec);

    imp->refresh(reload);
    return jsUndefined();
}


JSValue JSPluginArray::indexGetter(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSPluginArray* thisObj = static_cast<JSPluginArray*>(asObject(slot.slotBase()));
    return toJS(exec, thisObj->globalObject(), static_cast<PluginArray*>(thisObj->impl())->item(slot.index()));
}
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, PluginArray* object)
{
    return getDOMObjectWrapper<JSPluginArray>(exec, globalObject, object);
}
PluginArray* toPluginArray(JSC::JSValue value)
{
    return value.inherits(&JSPluginArray::s_info) ? static_cast<JSPluginArray*>(asObject(value))->impl() : 0;
}

}
