/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPopStateEvent.h"

#include "PopStateEvent.h"
#include "SerializedScriptValue.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSPopStateEvent);

/* Hash table */

static const HashTableValue JSPopStateEventTableValues[3] =
{
    { "state", DontDelete|ReadOnly, (intptr_t)jsPopStateEventState, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsPopStateEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPopStateEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSPopStateEventTableValues, 0 };
#else
    { 5, 3, JSPopStateEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSPopStateEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPopStateEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSPopStateEventConstructorTableValues, 0 };
#else
    { 1, 0, JSPopStateEventConstructorTableValues, 0 };
#endif

class JSPopStateEventConstructor : public DOMConstructorObject {
public:
    JSPopStateEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSPopStateEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSPopStateEventPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSPopStateEventConstructor::s_info = { "PopStateEventConstructor", 0, &JSPopStateEventConstructorTable, 0 };

bool JSPopStateEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPopStateEventConstructor, DOMObject>(exec, &JSPopStateEventConstructorTable, this, propertyName, slot);
}

bool JSPopStateEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPopStateEventConstructor, DOMObject>(exec, &JSPopStateEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSPopStateEventPrototypeTableValues[2] =
{
    { "initPopStateEvent", DontDelete|Function, (intptr_t)jsPopStateEventPrototypeFunctionInitPopStateEvent, (intptr_t)4 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSPopStateEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSPopStateEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSPopStateEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSPopStateEventPrototype::s_info = { "PopStateEventPrototype", 0, &JSPopStateEventPrototypeTable, 0 };

JSObject* JSPopStateEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPopStateEvent>(exec, globalObject);
}

bool JSPopStateEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSPopStateEventPrototypeTable, this, propertyName, slot);
}

bool JSPopStateEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSPopStateEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSPopStateEvent::s_info = { "PopStateEvent", &JSEvent::s_info, &JSPopStateEventTable, 0 };

JSPopStateEvent::JSPopStateEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<PopStateEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

JSObject* JSPopStateEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSPopStateEventPrototype(JSPopStateEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSPopStateEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPopStateEvent, Base>(exec, &JSPopStateEventTable, this, propertyName, slot);
}

bool JSPopStateEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPopStateEvent, Base>(exec, &JSPopStateEventTable, this, propertyName, descriptor);
}

JSValue jsPopStateEventState(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSPopStateEvent* castedThis = static_cast<JSPopStateEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    PopStateEvent* imp = static_cast<PopStateEvent*>(castedThis->impl());
    JSValue result = imp->state() ? imp->state()->deserialize(exec, castedThis->globalObject()) : jsNull();
    return result;
}

JSValue jsPopStateEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSPopStateEvent* domObject = static_cast<JSPopStateEvent*>(asObject(slot.slotBase()));
    return JSPopStateEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSPopStateEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPopStateEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsPopStateEventPrototypeFunctionInitPopStateEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSPopStateEvent::s_info))
        return throwError(exec, TypeError);
    JSPopStateEvent* castedThisObj = static_cast<JSPopStateEvent*>(asObject(thisValue));
    return castedThisObj->initPopStateEvent(exec, args);
}


}
