/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRGBColor.h"

#include "CSSPrimitiveValue.h"
#include "JSCSSPrimitiveValue.h"
#include "RGBColor.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSRGBColor);

/* Hash table */

static const HashTableValue JSRGBColorTableValues[5] =
{
    { "red", DontDelete|ReadOnly, (intptr_t)jsRGBColorRed, (intptr_t)0 },
    { "green", DontDelete|ReadOnly, (intptr_t)jsRGBColorGreen, (intptr_t)0 },
    { "blue", DontDelete|ReadOnly, (intptr_t)jsRGBColorBlue, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsRGBColorConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSRGBColorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSRGBColorTableValues, 0 };
#else
    { 8, 7, JSRGBColorTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSRGBColorConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSRGBColorConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSRGBColorConstructorTableValues, 0 };
#else
    { 1, 0, JSRGBColorConstructorTableValues, 0 };
#endif

class JSRGBColorConstructor : public DOMConstructorObject {
public:
    JSRGBColorConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSRGBColorConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSRGBColorPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSRGBColorConstructor::s_info = { "RGBColorConstructor", 0, &JSRGBColorConstructorTable, 0 };

bool JSRGBColorConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRGBColorConstructor, DOMObject>(exec, &JSRGBColorConstructorTable, this, propertyName, slot);
}

bool JSRGBColorConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSRGBColorConstructor, DOMObject>(exec, &JSRGBColorConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSRGBColorPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSRGBColorPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSRGBColorPrototypeTableValues, 0 };
#else
    { 1, 0, JSRGBColorPrototypeTableValues, 0 };
#endif

const ClassInfo JSRGBColorPrototype::s_info = { "RGBColorPrototype", 0, &JSRGBColorPrototypeTable, 0 };

JSObject* JSRGBColorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSRGBColor>(exec, globalObject);
}

const ClassInfo JSRGBColor::s_info = { "RGBColor", 0, &JSRGBColorTable, 0 };

JSRGBColor::JSRGBColor(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<RGBColor> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSRGBColor::~JSRGBColor()
{
    forgetDOMObject(this, impl());
}

JSObject* JSRGBColor::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSRGBColorPrototype(JSRGBColorPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSRGBColor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRGBColor, Base>(exec, &JSRGBColorTable, this, propertyName, slot);
}

bool JSRGBColor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSRGBColor, Base>(exec, &JSRGBColorTable, this, propertyName, descriptor);
}

JSValue jsRGBColorRed(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSRGBColor* castedThis = static_cast<JSRGBColor*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    RGBColor* imp = static_cast<RGBColor*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->red()));
    return result;
}

JSValue jsRGBColorGreen(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSRGBColor* castedThis = static_cast<JSRGBColor*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    RGBColor* imp = static_cast<RGBColor*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->green()));
    return result;
}

JSValue jsRGBColorBlue(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSRGBColor* castedThis = static_cast<JSRGBColor*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    RGBColor* imp = static_cast<RGBColor*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->blue()));
    return result;
}

JSValue jsRGBColorConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSRGBColor* domObject = static_cast<JSRGBColor*>(asObject(slot.slotBase()));
    return JSRGBColor::getConstructor(exec, domObject->globalObject());
}
JSValue JSRGBColor::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRGBColorConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, RGBColor* object)
{
    return getDOMObjectWrapper<JSRGBColor>(exec, globalObject, object);
}
RGBColor* toRGBColor(JSC::JSValue value)
{
    return value.inherits(&JSRGBColor::s_info) ? static_cast<JSRGBColor*>(asObject(value))->impl() : 0;
}

}
