/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedPathData.h"

#include "JSSVGPathSegList.h"
#include "SVGAnimatedPathData.h"
#include "SVGPathSegList.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedPathData);

/* Hash table */

static const HashTableValue JSSVGAnimatedPathDataTableValues[5] =
{
    { "pathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedPathDataPathSegList, (intptr_t)0 },
    { "normalizedPathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedPathDataNormalizedPathSegList, (intptr_t)0 },
    { "animatedPathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedPathDataAnimatedPathSegList, (intptr_t)0 },
    { "animatedNormalizedPathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedPathDataAnimatedNormalizedPathSegList, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedPathDataTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGAnimatedPathDataTableValues, 0 };
#else
    { 9, 7, JSSVGAnimatedPathDataTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedPathDataPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedPathDataPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGAnimatedPathDataPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGAnimatedPathDataPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGAnimatedPathDataPrototype::s_info = { "SVGAnimatedPathDataPrototype", 0, &JSSVGAnimatedPathDataPrototypeTable, 0 };

JSObject* JSSVGAnimatedPathDataPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedPathData>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedPathData::s_info = { "SVGAnimatedPathData", 0, &JSSVGAnimatedPathDataTable, 0 };

JSSVGAnimatedPathData::JSSVGAnimatedPathData(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedPathData> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGAnimatedPathData::~JSSVGAnimatedPathData()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGAnimatedPathData::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGAnimatedPathDataPrototype(JSSVGAnimatedPathDataPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGAnimatedPathData::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedPathData, Base>(exec, &JSSVGAnimatedPathDataTable, this, propertyName, slot);
}

bool JSSVGAnimatedPathData::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedPathData, Base>(exec, &JSSVGAnimatedPathDataTable, this, propertyName, descriptor);
}

JSValue jsSVGAnimatedPathDataPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedPathData* castedThis = static_cast<JSSVGAnimatedPathData*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedPathData* imp = static_cast<SVGAnimatedPathData*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->pathSegList()), JSSVGContextCache::svgContextForDOMObject(castedThis));
    return result;
}

JSValue jsSVGAnimatedPathDataNormalizedPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedPathData* castedThis = static_cast<JSSVGAnimatedPathData*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedPathData* imp = static_cast<SVGAnimatedPathData*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->normalizedPathSegList()), JSSVGContextCache::svgContextForDOMObject(castedThis));
    return result;
}

JSValue jsSVGAnimatedPathDataAnimatedPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedPathData* castedThis = static_cast<JSSVGAnimatedPathData*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedPathData* imp = static_cast<SVGAnimatedPathData*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->animatedPathSegList()), JSSVGContextCache::svgContextForDOMObject(castedThis));
    return result;
}

JSValue jsSVGAnimatedPathDataAnimatedNormalizedPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedPathData* castedThis = static_cast<JSSVGAnimatedPathData*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedPathData* imp = static_cast<SVGAnimatedPathData*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->animatedNormalizedPathSegList()), JSSVGContextCache::svgContextForDOMObject(castedThis));
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedPathData* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedPathData>(exec, globalObject, object, context);
}
SVGAnimatedPathData* toSVGAnimatedPathData(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedPathData::s_info) ? static_cast<JSSVGAnimatedPathData*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
