/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedPoints.h"

#include "JSSVGPointList.h"
#include "SVGAnimatedPoints.h"
#include "SVGPointList.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedPoints);

/* Hash table */

static const HashTableValue JSSVGAnimatedPointsTableValues[3] =
{
    { "points", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedPointsPoints, (intptr_t)0 },
    { "animatedPoints", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedPointsAnimatedPoints, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedPointsTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGAnimatedPointsTableValues, 0 };
#else
    { 4, 3, JSSVGAnimatedPointsTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedPointsPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedPointsPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGAnimatedPointsPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGAnimatedPointsPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGAnimatedPointsPrototype::s_info = { "SVGAnimatedPointsPrototype", 0, &JSSVGAnimatedPointsPrototypeTable, 0 };

JSObject* JSSVGAnimatedPointsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedPoints>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedPoints::s_info = { "SVGAnimatedPoints", 0, &JSSVGAnimatedPointsTable, 0 };

JSSVGAnimatedPoints::JSSVGAnimatedPoints(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedPoints> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGAnimatedPoints::~JSSVGAnimatedPoints()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGAnimatedPoints::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGAnimatedPointsPrototype(JSSVGAnimatedPointsPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGAnimatedPoints::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedPoints, Base>(exec, &JSSVGAnimatedPointsTable, this, propertyName, slot);
}

bool JSSVGAnimatedPoints::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedPoints, Base>(exec, &JSSVGAnimatedPointsTable, this, propertyName, descriptor);
}

JSValue jsSVGAnimatedPointsPoints(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedPoints* castedThis = static_cast<JSSVGAnimatedPoints*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedPoints* imp = static_cast<SVGAnimatedPoints*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->points()), JSSVGContextCache::svgContextForDOMObject(castedThis));
    return result;
}

JSValue jsSVGAnimatedPointsAnimatedPoints(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedPoints* castedThis = static_cast<JSSVGAnimatedPoints*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedPoints* imp = static_cast<SVGAnimatedPoints*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->animatedPoints()), JSSVGContextCache::svgContextForDOMObject(castedThis));
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedPoints* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedPoints>(exec, globalObject, object, context);
}
SVGAnimatedPoints* toSVGAnimatedPoints(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedPoints::s_info) ? static_cast<JSSVGAnimatedPoints*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
