/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedString.h"

#include "KURL.h"
#include "PlatformString.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGAnimatedString);

/* Hash table */

static const HashTableValue JSSVGAnimatedStringTableValues[4] =
{
    { "baseVal", DontDelete, (intptr_t)jsSVGAnimatedStringBaseVal, (intptr_t)setJSSVGAnimatedStringBaseVal },
    { "animVal", DontDelete|ReadOnly, (intptr_t)jsSVGAnimatedStringAnimVal, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGAnimatedStringConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedStringTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGAnimatedStringTableValues, 0 };
#else
    { 8, 7, JSSVGAnimatedStringTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedStringConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedStringConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGAnimatedStringConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGAnimatedStringConstructorTableValues, 0 };
#endif

class JSSVGAnimatedStringConstructor : public DOMConstructorObject {
public:
    JSSVGAnimatedStringConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGAnimatedStringConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGAnimatedStringPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGAnimatedStringConstructor::s_info = { "SVGAnimatedStringConstructor", 0, &JSSVGAnimatedStringConstructorTable, 0 };

bool JSSVGAnimatedStringConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedStringConstructor, DOMObject>(exec, &JSSVGAnimatedStringConstructorTable, this, propertyName, slot);
}

bool JSSVGAnimatedStringConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedStringConstructor, DOMObject>(exec, &JSSVGAnimatedStringConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedStringPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGAnimatedStringPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGAnimatedStringPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGAnimatedStringPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGAnimatedStringPrototype::s_info = { "SVGAnimatedStringPrototype", 0, &JSSVGAnimatedStringPrototypeTable, 0 };

JSObject* JSSVGAnimatedStringPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedString>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedString::s_info = { "SVGAnimatedString", 0, &JSSVGAnimatedStringTable, 0 };

JSSVGAnimatedString::JSSVGAnimatedString(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedString> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGAnimatedString::~JSSVGAnimatedString()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGAnimatedString::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGAnimatedStringPrototype(JSSVGAnimatedStringPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGAnimatedString::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedString, Base>(exec, &JSSVGAnimatedStringTable, this, propertyName, slot);
}

bool JSSVGAnimatedString::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedString, Base>(exec, &JSSVGAnimatedStringTable, this, propertyName, descriptor);
}

JSValue jsSVGAnimatedStringBaseVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedString* castedThis = static_cast<JSSVGAnimatedString*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(castedThis->impl());
    JSValue result = jsString(exec, imp->baseVal());
    return result;
}

JSValue jsSVGAnimatedStringAnimVal(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedString* castedThis = static_cast<JSSVGAnimatedString*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(castedThis->impl());
    JSValue result = jsString(exec, imp->animVal());
    return result;
}

JSValue jsSVGAnimatedStringConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGAnimatedString* domObject = static_cast<JSSVGAnimatedString*>(asObject(slot.slotBase()));
    return JSSVGAnimatedString::getConstructor(exec, domObject->globalObject());
}
void JSSVGAnimatedString::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGAnimatedString, Base>(exec, propertyName, value, &JSSVGAnimatedStringTable, this, slot);
}

void setJSSVGAnimatedStringBaseVal(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGAnimatedString* castedThisObj = static_cast<JSSVGAnimatedString*>(thisObject);
    SVGAnimatedString* imp = static_cast<SVGAnimatedString*>(castedThisObj->impl());
    imp->setBaseVal(value.toString(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

JSValue JSSVGAnimatedString::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedStringConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedString* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGAnimatedString>(exec, globalObject, object, context);
}
SVGAnimatedString* toSVGAnimatedString(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedString::s_info) ? static_cast<JSSVGAnimatedString*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
