/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGElement.h"

#include "HTMLNames.h"
#include "JSSVGElement.h"
#include "JSSVGSVGElement.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGSVGElement.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGElement);

/* Hash table */

static const HashTableValue JSSVGElementTableValues[6] =
{
    { "id", DontDelete, (intptr_t)jsSVGElementId, (intptr_t)setJSSVGElementId },
    { "xmlbase", DontDelete, (intptr_t)jsSVGElementXmlbase, (intptr_t)setJSSVGElementXmlbase },
    { "ownerSVGElement", DontDelete|ReadOnly, (intptr_t)jsSVGElementOwnerSVGElement, (intptr_t)0 },
    { "viewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGElementViewportElement, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGElementTableValues, 0 };
#else
    { 16, 15, JSSVGElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGElementConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGElementConstructorTableValues, 0 };
#endif

class JSSVGElementConstructor : public DOMConstructorObject {
public:
    JSSVGElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGElementConstructor::s_info = { "SVGElementConstructor", 0, &JSSVGElementConstructorTable, 0 };

bool JSSVGElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementConstructor, DOMObject>(exec, &JSSVGElementConstructorTable, this, propertyName, slot);
}

bool JSSVGElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGElementConstructor, DOMObject>(exec, &JSSVGElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGElementPrototype::s_info = { "SVGElementPrototype", 0, &JSSVGElementPrototypeTable, 0 };

JSObject* JSSVGElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGElement>(exec, globalObject);
}

const ClassInfo JSSVGElement::s_info = { "SVGElement", &JSElement::s_info, &JSSVGElementTable, 0 };

JSSVGElement::JSSVGElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGElement> impl)
    : JSElement(structure, globalObject, impl)
{
}

JSObject* JSSVGElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGElementPrototype(JSSVGElementPrototype::createStructure(JSElementPrototype::self(exec, globalObject)));
}

bool JSSVGElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElement, Base>(exec, &JSSVGElementTable, this, propertyName, slot);
}

bool JSSVGElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGElement, Base>(exec, &JSSVGElementTable, this, propertyName, descriptor);
}

JSValue jsSVGElementId(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElement* castedThis = static_cast<JSSVGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElement* imp = static_cast<SVGElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(HTMLNames::idAttr));
    return result;
}

JSValue jsSVGElementXmlbase(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElement* castedThis = static_cast<JSSVGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElement* imp = static_cast<SVGElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmlbase());
    return result;
}

JSValue jsSVGElementOwnerSVGElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElement* castedThis = static_cast<JSSVGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElement* imp = static_cast<SVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->ownerSVGElement()));
    return result;
}

JSValue jsSVGElementViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElement* castedThis = static_cast<JSSVGElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElement* imp = static_cast<SVGElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->viewportElement()));
    return result;
}

JSValue jsSVGElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElement* domObject = static_cast<JSSVGElement*>(asObject(slot.slotBase()));
    return JSSVGElement::getConstructor(exec, domObject->globalObject());
}
void JSSVGElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGElement, Base>(exec, propertyName, value, &JSSVGElementTable, this, slot);
}

void setJSSVGElementId(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGElement* castedThisObj = static_cast<JSSVGElement*>(thisObject);
    SVGElement* imp = static_cast<SVGElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setAttribute(HTMLNames::idAttr, valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void setJSSVGElementXmlbase(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGElement* castedThisObj = static_cast<JSSVGElement*>(thisObject);
    SVGElement* imp = static_cast<SVGElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    imp->setXmlbase(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

JSValue JSSVGElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

SVGElement* toSVGElement(JSC::JSValue value)
{
    return value.inherits(&JSSVGElement::s_info) ? static_cast<JSSVGElement*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
