/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGElementInstance.h"

#include "Event.h"
#include "EventListener.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSSVGElement.h"
#include "JSSVGElementInstance.h"
#include "JSSVGElementInstanceList.h"
#include "JSSVGUseElement.h"
#include "SVGElement.h"
#include "SVGElementInstance.h"
#include "SVGElementInstanceList.h"
#include "SVGUseElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGElementInstance);

/* Hash table */

static const HashTableValue JSSVGElementInstanceTableValues[50] =
{
    { "correspondingElement", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceCorrespondingElement, (intptr_t)0 },
    { "correspondingUseElement", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceCorrespondingUseElement, (intptr_t)0 },
    { "parentNode", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceParentNode, (intptr_t)0 },
    { "childNodes", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceChildNodes, (intptr_t)0 },
    { "firstChild", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceFirstChild, (intptr_t)0 },
    { "lastChild", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceLastChild, (intptr_t)0 },
    { "previousSibling", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstancePreviousSibling, (intptr_t)0 },
    { "nextSibling", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceNextSibling, (intptr_t)0 },
    { "onabort", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnabort, (intptr_t)setJSSVGElementInstanceOnabort },
    { "onblur", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnblur, (intptr_t)setJSSVGElementInstanceOnblur },
    { "onchange", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnchange, (intptr_t)setJSSVGElementInstanceOnchange },
    { "onclick", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnclick, (intptr_t)setJSSVGElementInstanceOnclick },
    { "oncontextmenu", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOncontextmenu, (intptr_t)setJSSVGElementInstanceOncontextmenu },
    { "ondblclick", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndblclick, (intptr_t)setJSSVGElementInstanceOndblclick },
    { "onerror", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnerror, (intptr_t)setJSSVGElementInstanceOnerror },
    { "onfocus", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnfocus, (intptr_t)setJSSVGElementInstanceOnfocus },
    { "oninput", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOninput, (intptr_t)setJSSVGElementInstanceOninput },
    { "onkeydown", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnkeydown, (intptr_t)setJSSVGElementInstanceOnkeydown },
    { "onkeypress", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnkeypress, (intptr_t)setJSSVGElementInstanceOnkeypress },
    { "onkeyup", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnkeyup, (intptr_t)setJSSVGElementInstanceOnkeyup },
    { "onload", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnload, (intptr_t)setJSSVGElementInstanceOnload },
    { "onmousedown", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmousedown, (intptr_t)setJSSVGElementInstanceOnmousedown },
    { "onmousemove", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmousemove, (intptr_t)setJSSVGElementInstanceOnmousemove },
    { "onmouseout", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmouseout, (intptr_t)setJSSVGElementInstanceOnmouseout },
    { "onmouseover", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmouseover, (intptr_t)setJSSVGElementInstanceOnmouseover },
    { "onmouseup", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmouseup, (intptr_t)setJSSVGElementInstanceOnmouseup },
    { "onmousewheel", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnmousewheel, (intptr_t)setJSSVGElementInstanceOnmousewheel },
    { "onbeforecut", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnbeforecut, (intptr_t)setJSSVGElementInstanceOnbeforecut },
    { "oncut", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOncut, (intptr_t)setJSSVGElementInstanceOncut },
    { "onbeforecopy", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnbeforecopy, (intptr_t)setJSSVGElementInstanceOnbeforecopy },
    { "oncopy", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOncopy, (intptr_t)setJSSVGElementInstanceOncopy },
    { "onbeforepaste", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnbeforepaste, (intptr_t)setJSSVGElementInstanceOnbeforepaste },
    { "onpaste", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnpaste, (intptr_t)setJSSVGElementInstanceOnpaste },
    { "ondragenter", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndragenter, (intptr_t)setJSSVGElementInstanceOndragenter },
    { "ondragover", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndragover, (intptr_t)setJSSVGElementInstanceOndragover },
    { "ondragleave", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndragleave, (intptr_t)setJSSVGElementInstanceOndragleave },
    { "ondrop", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndrop, (intptr_t)setJSSVGElementInstanceOndrop },
    { "ondragstart", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndragstart, (intptr_t)setJSSVGElementInstanceOndragstart },
    { "ondrag", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndrag, (intptr_t)setJSSVGElementInstanceOndrag },
    { "ondragend", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOndragend, (intptr_t)setJSSVGElementInstanceOndragend },
    { "onreset", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnreset, (intptr_t)setJSSVGElementInstanceOnreset },
    { "onresize", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnresize, (intptr_t)setJSSVGElementInstanceOnresize },
    { "onscroll", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnscroll, (intptr_t)setJSSVGElementInstanceOnscroll },
    { "onsearch", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnsearch, (intptr_t)setJSSVGElementInstanceOnsearch },
    { "onselect", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnselect, (intptr_t)setJSSVGElementInstanceOnselect },
    { "onselectstart", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnselectstart, (intptr_t)setJSSVGElementInstanceOnselectstart },
    { "onsubmit", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnsubmit, (intptr_t)setJSSVGElementInstanceOnsubmit },
    { "onunload", DontDelete|DontEnum, (intptr_t)jsSVGElementInstanceOnunload, (intptr_t)setJSSVGElementInstanceOnunload },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGElementInstanceConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGElementInstanceTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 4095, JSSVGElementInstanceTableValues, 0 };
#else
    { 137, 127, JSSVGElementInstanceTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGElementInstanceConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGElementInstanceConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGElementInstanceConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGElementInstanceConstructorTableValues, 0 };
#endif

class JSSVGElementInstanceConstructor : public DOMConstructorObject {
public:
    JSSVGElementInstanceConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGElementInstanceConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGElementInstancePrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGElementInstanceConstructor::s_info = { "SVGElementInstanceConstructor", 0, &JSSVGElementInstanceConstructorTable, 0 };

bool JSSVGElementInstanceConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementInstanceConstructor, DOMObject>(exec, &JSSVGElementInstanceConstructorTable, this, propertyName, slot);
}

bool JSSVGElementInstanceConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGElementInstanceConstructor, DOMObject>(exec, &JSSVGElementInstanceConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGElementInstancePrototypeTableValues[4] =
{
    { "addEventListener", DontDelete|Function, (intptr_t)jsSVGElementInstancePrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsSVGElementInstancePrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsSVGElementInstancePrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGElementInstancePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGElementInstancePrototypeTableValues, 0 };
#else
    { 8, 7, JSSVGElementInstancePrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGElementInstancePrototype::s_info = { "SVGElementInstancePrototype", 0, &JSSVGElementInstancePrototypeTable, 0 };

JSObject* JSSVGElementInstancePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGElementInstance>(exec, globalObject);
}

bool JSSVGElementInstancePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGElementInstancePrototypeTable, this, propertyName, slot);
}

bool JSSVGElementInstancePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGElementInstancePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGElementInstance::s_info = { "SVGElementInstance", 0, &JSSVGElementInstanceTable, 0 };

JSSVGElementInstance::JSSVGElementInstance(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGElementInstance> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGElementInstance::~JSSVGElementInstance()
{
    forgetDOMObject(this, impl());
}

JSObject* JSSVGElementInstance::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGElementInstancePrototype(JSSVGElementInstancePrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGElementInstance::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementInstance, Base>(exec, &JSSVGElementInstanceTable, this, propertyName, slot);
}

bool JSSVGElementInstance::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGElementInstance, Base>(exec, &JSSVGElementInstanceTable, this, propertyName, descriptor);
}

JSValue jsSVGElementInstanceCorrespondingElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->correspondingElement()));
    return result;
}

JSValue jsSVGElementInstanceCorrespondingUseElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->correspondingUseElement()));
    return result;
}

JSValue jsSVGElementInstanceParentNode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->parentNode()));
    return result;
}

JSValue jsSVGElementInstanceChildNodes(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->childNodes()));
    return result;
}

JSValue jsSVGElementInstanceFirstChild(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->firstChild()));
    return result;
}

JSValue jsSVGElementInstanceLastChild(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->lastChild()));
    return result;
}

JSValue jsSVGElementInstancePreviousSibling(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->previousSibling()));
    return result;
}

JSValue jsSVGElementInstanceNextSibling(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nextSibling()));
    return result;
}

JSValue jsSVGElementInstanceOnabort(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnblur(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onblur()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnchange(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnclick(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOncontextmenu(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oncontextmenu()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndblclick(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondblclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnerror(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnfocus(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onfocus()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOninput(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oninput()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnkeydown(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onkeydown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnkeypress(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onkeypress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnkeyup(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onkeyup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmousedown(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmousedown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmousemove(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmousemove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmouseout(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseout()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmouseover(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmouseup(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmouseup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnmousewheel(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onmousewheel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnbeforecut(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOncut(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oncut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnbeforecopy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforecopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOncopy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->oncopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnbeforepaste(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onbeforepaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnpaste(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onpaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndragenter(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragenter()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndragover(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndragleave(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragleave()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndrop(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondrop()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndragstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndrag(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondrag()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOndragend(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->ondragend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnreset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onreset()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnresize(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onresize()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnscroll(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onscroll()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnsearch(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onsearch()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnselect(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onselect()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnselectstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onselectstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnsubmit(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onsubmit()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceOnunload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* castedThis = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = imp->onunload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(imp->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

JSValue jsSVGElementInstanceConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGElementInstance* domObject = static_cast<JSSVGElementInstance*>(asObject(slot.slotBase()));
    return JSSVGElementInstance::getConstructor(exec, domObject->globalObject());
}
void JSSVGElementInstance::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGElementInstance, Base>(exec, propertyName, value, &JSSVGElementInstanceTable, this, slot);
}

void setJSSVGElementInstanceOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnblur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnblur(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnchange(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnclick(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOncontextmenu(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOncontextmenu(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOndblclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOndblclick(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnfocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnfocus(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOninput(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOninput(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnkeydown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnkeydown(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnkeypress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnkeypress(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnkeyup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnkeyup(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnload(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnmousedown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnmousedown(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnmousemove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnmousemove(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnmouseout(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnmouseout(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnmouseover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnmouseover(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnmouseup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnmouseup(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnmousewheel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnmousewheel(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnbeforecut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnbeforecut(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOncut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOncut(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnbeforecopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnbeforecopy(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOncopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOncopy(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnbeforepaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnbeforepaste(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnpaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnpaste(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOndragenter(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOndragenter(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOndragover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOndragover(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOndragleave(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOndragleave(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOndrop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOndrop(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOndragstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOndragstart(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOndrag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOndrag(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOndragend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOndragend(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnreset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnreset(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnresize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnresize(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnscroll(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnscroll(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnsearch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnsearch(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnselect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnselect(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnselectstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnselectstart(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnsubmit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnsubmit(createJSAttributeEventListener(exec, value, thisObject));
}

void setJSSVGElementInstanceOnunload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(static_cast<JSSVGElementInstance*>(thisObject)->impl());
    imp->setOnunload(createJSAttributeEventListener(exec, value, thisObject));
}

JSValue JSSVGElementInstance::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGElementInstanceConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGElementInstancePrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGElementInstance::s_info))
        return throwError(exec, TypeError);
    JSSVGElementInstance* castedThisObj = static_cast<JSSVGElementInstance*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsSVGElementInstancePrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGElementInstance::s_info))
        return throwError(exec, TypeError);
    JSSVGElementInstance* castedThisObj = static_cast<JSSVGElementInstance*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValue JSC_HOST_CALL jsSVGElementInstancePrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGElementInstance::s_info))
        return throwError(exec, TypeError);
    JSSVGElementInstance* castedThisObj = static_cast<JSSVGElementInstance*>(asObject(thisValue));
    SVGElementInstance* imp = static_cast<SVGElementInstance*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* event = toEvent(args.at(0));


    JSC::JSValue result = jsBoolean(imp->dispatchEvent(event, ec));
    setDOMException(exec, ec);
    return result;
}

SVGElementInstance* toSVGElementInstance(JSC::JSValue value)
{
    return value.inherits(&JSSVGElementInstance::s_info) ? static_cast<JSSVGElementInstance*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
