/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGExternalResourcesRequired.h"

#include "JSSVGAnimatedBoolean.h"
#include "SVGExternalResourcesRequired.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGExternalResourcesRequired);

/* Hash table */

static const HashTableValue JSSVGExternalResourcesRequiredTableValues[2] =
{
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGExternalResourcesRequiredExternalResourcesRequired, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGExternalResourcesRequiredTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGExternalResourcesRequiredTableValues, 0 };
#else
    { 2, 1, JSSVGExternalResourcesRequiredTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGExternalResourcesRequiredPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGExternalResourcesRequiredPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGExternalResourcesRequiredPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGExternalResourcesRequiredPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGExternalResourcesRequiredPrototype::s_info = { "SVGExternalResourcesRequiredPrototype", 0, &JSSVGExternalResourcesRequiredPrototypeTable, 0 };

JSObject* JSSVGExternalResourcesRequiredPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGExternalResourcesRequired>(exec, globalObject);
}

const ClassInfo JSSVGExternalResourcesRequired::s_info = { "SVGExternalResourcesRequired", 0, &JSSVGExternalResourcesRequiredTable, 0 };

JSSVGExternalResourcesRequired::JSSVGExternalResourcesRequired(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGExternalResourcesRequired> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGExternalResourcesRequired::~JSSVGExternalResourcesRequired()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGExternalResourcesRequired::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGExternalResourcesRequiredPrototype(JSSVGExternalResourcesRequiredPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGExternalResourcesRequired::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGExternalResourcesRequired, Base>(exec, &JSSVGExternalResourcesRequiredTable, this, propertyName, slot);
}

bool JSSVGExternalResourcesRequired::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGExternalResourcesRequired, Base>(exec, &JSSVGExternalResourcesRequiredTable, this, propertyName, descriptor);
}

JSValue jsSVGExternalResourcesRequiredExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGExternalResourcesRequired* castedThis = static_cast<JSSVGExternalResourcesRequired*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGExternalResourcesRequired* imp = static_cast<SVGExternalResourcesRequired*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGExternalResourcesRequired* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGExternalResourcesRequired>(exec, globalObject, object, context);
}
SVGExternalResourcesRequired* toSVGExternalResourcesRequired(JSC::JSValue value)
{
    return value.inherits(&JSSVGExternalResourcesRequired::s_info) ? static_cast<JSSVGExternalResourcesRequired*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
