/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(FILTERS)

#include "JSSVGFEMergeElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEMergeElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEMergeElement);

/* Hash table */

static const HashTableValue JSSVGFEMergeElementTableValues[9] =
{
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementResult, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGFEMergeElementStyle, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGFEMergeElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFEMergeElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGFEMergeElementTableValues, 0 };
#else
    { 18, 15, JSSVGFEMergeElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGFEMergeElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFEMergeElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFEMergeElementConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGFEMergeElementConstructorTableValues, 0 };
#endif

class JSSVGFEMergeElementConstructor : public DOMConstructorObject {
public:
    JSSVGFEMergeElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGFEMergeElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGFEMergeElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGFEMergeElementConstructor::s_info = { "SVGFEMergeElementConstructor", 0, &JSSVGFEMergeElementConstructorTable, 0 };

bool JSSVGFEMergeElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEMergeElementConstructor, DOMObject>(exec, &JSSVGFEMergeElementConstructorTable, this, propertyName, slot);
}

bool JSSVGFEMergeElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEMergeElementConstructor, DOMObject>(exec, &JSSVGFEMergeElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEMergeElementPrototypeTableValues[2] =
{
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGFEMergeElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFEMergeElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFEMergeElementPrototypeTableValues, 0 };
#else
    { 2, 1, JSSVGFEMergeElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFEMergeElementPrototype::s_info = { "SVGFEMergeElementPrototype", 0, &JSSVGFEMergeElementPrototypeTable, 0 };

JSObject* JSSVGFEMergeElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEMergeElement>(exec, globalObject);
}

bool JSSVGFEMergeElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFEMergeElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGFEMergeElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGFEMergeElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGFEMergeElement::s_info = { "SVGFEMergeElement", &JSSVGElement::s_info, &JSSVGFEMergeElementTable, 0 };

JSSVGFEMergeElement::JSSVGFEMergeElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEMergeElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGFEMergeElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGFEMergeElementPrototype(JSSVGFEMergeElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEMergeElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEMergeElement, Base>(exec, &JSSVGFEMergeElementTable, this, propertyName, slot);
}

bool JSSVGFEMergeElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEMergeElement, Base>(exec, &JSSVGFEMergeElementTable, this, propertyName, descriptor);
}

JSValue jsSVGFEMergeElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEMergeElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEMergeElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEMergeElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEMergeElementResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEMergeElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEMergeElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* castedThis = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}

JSValue jsSVGFEMergeElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFEMergeElement* domObject = static_cast<JSSVGFEMergeElement*>(asObject(slot.slotBase()));
    return JSSVGFEMergeElement::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGFEMergeElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEMergeElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGFEMergeElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGFEMergeElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFEMergeElement* castedThisObj = static_cast<JSSVGFEMergeElement*>(asObject(thisValue));
    SVGFEMergeElement* imp = static_cast<SVGFEMergeElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}


}

#endif // ENABLE(SVG) && ENABLE(FILTERS)
