/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGFilterPrimitiveStandardAttributes.h"

#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFilterPrimitiveStandardAttributes.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFilterPrimitiveStandardAttributes);

/* Hash table */

static const HashTableValue JSSVGFilterPrimitiveStandardAttributesTableValues[7] =
{
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGFilterPrimitiveStandardAttributesX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGFilterPrimitiveStandardAttributesY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGFilterPrimitiveStandardAttributesWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGFilterPrimitiveStandardAttributesHeight, (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)jsSVGFilterPrimitiveStandardAttributesResult, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGFilterPrimitiveStandardAttributesConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFilterPrimitiveStandardAttributesTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGFilterPrimitiveStandardAttributesTableValues, 0 };
#else
    { 17, 15, JSSVGFilterPrimitiveStandardAttributesTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGFilterPrimitiveStandardAttributesConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFilterPrimitiveStandardAttributesConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFilterPrimitiveStandardAttributesConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGFilterPrimitiveStandardAttributesConstructorTableValues, 0 };
#endif

class JSSVGFilterPrimitiveStandardAttributesConstructor : public DOMConstructorObject {
public:
    JSSVGFilterPrimitiveStandardAttributesConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGFilterPrimitiveStandardAttributesConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGFilterPrimitiveStandardAttributesPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGFilterPrimitiveStandardAttributesConstructor::s_info = { "SVGFilterPrimitiveStandardAttributesConstructor", 0, &JSSVGFilterPrimitiveStandardAttributesConstructorTable, 0 };

bool JSSVGFilterPrimitiveStandardAttributesConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFilterPrimitiveStandardAttributesConstructor, DOMObject>(exec, &JSSVGFilterPrimitiveStandardAttributesConstructorTable, this, propertyName, slot);
}

bool JSSVGFilterPrimitiveStandardAttributesConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFilterPrimitiveStandardAttributesConstructor, DOMObject>(exec, &JSSVGFilterPrimitiveStandardAttributesConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFilterPrimitiveStandardAttributesPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFilterPrimitiveStandardAttributesPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFilterPrimitiveStandardAttributesPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGFilterPrimitiveStandardAttributesPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFilterPrimitiveStandardAttributesPrototype::s_info = { "SVGFilterPrimitiveStandardAttributesPrototype", 0, &JSSVGFilterPrimitiveStandardAttributesPrototypeTable, 0 };

JSObject* JSSVGFilterPrimitiveStandardAttributesPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFilterPrimitiveStandardAttributes>(exec, globalObject);
}

const ClassInfo JSSVGFilterPrimitiveStandardAttributes::s_info = { "SVGFilterPrimitiveStandardAttributes", &JSSVGStylable::s_info, &JSSVGFilterPrimitiveStandardAttributesTable, 0 };

JSSVGFilterPrimitiveStandardAttributes::JSSVGFilterPrimitiveStandardAttributes(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFilterPrimitiveStandardAttributes> impl)
    : JSSVGStylable(structure, globalObject, impl)
{
}

JSObject* JSSVGFilterPrimitiveStandardAttributes::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGFilterPrimitiveStandardAttributesPrototype(JSSVGFilterPrimitiveStandardAttributesPrototype::createStructure(JSSVGStylablePrototype::self(exec, globalObject)));
}

bool JSSVGFilterPrimitiveStandardAttributes::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFilterPrimitiveStandardAttributes, Base>(exec, &JSSVGFilterPrimitiveStandardAttributesTable, this, propertyName, slot);
}

bool JSSVGFilterPrimitiveStandardAttributes::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFilterPrimitiveStandardAttributes, Base>(exec, &JSSVGFilterPrimitiveStandardAttributesTable, this, propertyName, descriptor);
}

JSValue jsSVGFilterPrimitiveStandardAttributesX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterPrimitiveStandardAttributes* castedThis = static_cast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterPrimitiveStandardAttributes* imp = static_cast<SVGFilterPrimitiveStandardAttributes*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFilterPrimitiveStandardAttributesY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterPrimitiveStandardAttributes* castedThis = static_cast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterPrimitiveStandardAttributes* imp = static_cast<SVGFilterPrimitiveStandardAttributes*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFilterPrimitiveStandardAttributesWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterPrimitiveStandardAttributes* castedThis = static_cast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterPrimitiveStandardAttributes* imp = static_cast<SVGFilterPrimitiveStandardAttributes*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFilterPrimitiveStandardAttributesHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterPrimitiveStandardAttributes* castedThis = static_cast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterPrimitiveStandardAttributes* imp = static_cast<SVGFilterPrimitiveStandardAttributes*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFilterPrimitiveStandardAttributesResult(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterPrimitiveStandardAttributes* castedThis = static_cast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGFilterPrimitiveStandardAttributes* imp = static_cast<SVGFilterPrimitiveStandardAttributes*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFilterPrimitiveStandardAttributesConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGFilterPrimitiveStandardAttributes* domObject = static_cast<JSSVGFilterPrimitiveStandardAttributes*>(asObject(slot.slotBase()));
    return JSSVGFilterPrimitiveStandardAttributes::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGFilterPrimitiveStandardAttributes::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFilterPrimitiveStandardAttributesConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
