/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(SVG_FONTS)

#include "JSSVGHKernElement.h"

#include "SVGHKernElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGHKernElement);

/* Hash table */

static const HashTableValue JSSVGHKernElementTableValues[2] =
{
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGHKernElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGHKernElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGHKernElementTableValues, 0 };
#else
    { 2, 1, JSSVGHKernElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGHKernElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGHKernElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGHKernElementConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGHKernElementConstructorTableValues, 0 };
#endif

class JSSVGHKernElementConstructor : public DOMConstructorObject {
public:
    JSSVGHKernElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGHKernElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGHKernElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGHKernElementConstructor::s_info = { "SVGHKernElementConstructor", 0, &JSSVGHKernElementConstructorTable, 0 };

bool JSSVGHKernElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGHKernElementConstructor, DOMObject>(exec, &JSSVGHKernElementConstructorTable, this, propertyName, slot);
}

bool JSSVGHKernElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGHKernElementConstructor, DOMObject>(exec, &JSSVGHKernElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGHKernElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGHKernElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGHKernElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGHKernElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGHKernElementPrototype::s_info = { "SVGHKernElementPrototype", 0, &JSSVGHKernElementPrototypeTable, 0 };

JSObject* JSSVGHKernElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGHKernElement>(exec, globalObject);
}

const ClassInfo JSSVGHKernElement::s_info = { "SVGHKernElement", &JSSVGElement::s_info, &JSSVGHKernElementTable, 0 };

JSSVGHKernElement::JSSVGHKernElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGHKernElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGHKernElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGHKernElementPrototype(JSSVGHKernElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGHKernElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGHKernElement, Base>(exec, &JSSVGHKernElementTable, this, propertyName, slot);
}

bool JSSVGHKernElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGHKernElement, Base>(exec, &JSSVGHKernElementTable, this, propertyName, descriptor);
}

JSValue jsSVGHKernElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGHKernElement* domObject = static_cast<JSSVGHKernElement*>(asObject(slot.slotBase()));
    return JSSVGHKernElement::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGHKernElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGHKernElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FONTS)
