/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGLangSpace.h"

#include "KURL.h"
#include "SVGLangSpace.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGLangSpace);

/* Hash table */

static const HashTableValue JSSVGLangSpaceTableValues[3] =
{
    { "xmllang", DontDelete, (intptr_t)jsSVGLangSpaceXmllang, (intptr_t)setJSSVGLangSpaceXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGLangSpaceXmlspace, (intptr_t)setJSSVGLangSpaceXmlspace },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGLangSpaceTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGLangSpaceTableValues, 0 };
#else
    { 5, 3, JSSVGLangSpaceTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGLangSpacePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGLangSpacePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGLangSpacePrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGLangSpacePrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGLangSpacePrototype::s_info = { "SVGLangSpacePrototype", 0, &JSSVGLangSpacePrototypeTable, 0 };

JSObject* JSSVGLangSpacePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGLangSpace>(exec, globalObject);
}

const ClassInfo JSSVGLangSpace::s_info = { "SVGLangSpace", 0, &JSSVGLangSpaceTable, 0 };

JSSVGLangSpace::JSSVGLangSpace(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGLangSpace> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGLangSpace::~JSSVGLangSpace()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGLangSpace::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGLangSpacePrototype(JSSVGLangSpacePrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGLangSpace::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLangSpace, Base>(exec, &JSSVGLangSpaceTable, this, propertyName, slot);
}

bool JSSVGLangSpace::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGLangSpace, Base>(exec, &JSSVGLangSpaceTable, this, propertyName, descriptor);
}

JSValue jsSVGLangSpaceXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGLangSpace* castedThis = static_cast<JSSVGLangSpace*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGLangSpace* imp = static_cast<SVGLangSpace*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmllang());
    return result;
}

JSValue jsSVGLangSpaceXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGLangSpace* castedThis = static_cast<JSSVGLangSpace*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGLangSpace* imp = static_cast<SVGLangSpace*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmlspace());
    return result;
}

void JSSVGLangSpace::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGLangSpace, Base>(exec, propertyName, value, &JSSVGLangSpaceTable, this, slot);
}

void setJSSVGLangSpaceXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGLangSpace* castedThisObj = static_cast<JSSVGLangSpace*>(thisObject);
    SVGLangSpace* imp = static_cast<SVGLangSpace*>(castedThisObj->impl());
    imp->setXmllang(value.toString(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

void setJSSVGLangSpaceXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGLangSpace* castedThisObj = static_cast<JSSVGLangSpace*>(thisObject);
    SVGLangSpace* imp = static_cast<SVGLangSpace*>(castedThisObj->impl());
    imp->setXmlspace(value.toString(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGLangSpace* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGLangSpace>(exec, globalObject, object, context);
}
SVGLangSpace* toSVGLangSpace(JSC::JSValue value)
{
    return value.inherits(&JSSVGLangSpace::s_info) ? static_cast<JSSVGLangSpace*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
