/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGLinearGradientElement.h"

#include "JSSVGAnimatedLength.h"
#include "SVGLinearGradientElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGLinearGradientElement);

/* Hash table */

static const HashTableValue JSSVGLinearGradientElementTableValues[6] =
{
    { "x1", DontDelete|ReadOnly, (intptr_t)jsSVGLinearGradientElementX1, (intptr_t)0 },
    { "y1", DontDelete|ReadOnly, (intptr_t)jsSVGLinearGradientElementY1, (intptr_t)0 },
    { "x2", DontDelete|ReadOnly, (intptr_t)jsSVGLinearGradientElementX2, (intptr_t)0 },
    { "y2", DontDelete|ReadOnly, (intptr_t)jsSVGLinearGradientElementY2, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGLinearGradientElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGLinearGradientElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSSVGLinearGradientElementTableValues, 0 };
#else
    { 16, 15, JSSVGLinearGradientElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGLinearGradientElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGLinearGradientElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGLinearGradientElementConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGLinearGradientElementConstructorTableValues, 0 };
#endif

class JSSVGLinearGradientElementConstructor : public DOMConstructorObject {
public:
    JSSVGLinearGradientElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGLinearGradientElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGLinearGradientElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGLinearGradientElementConstructor::s_info = { "SVGLinearGradientElementConstructor", 0, &JSSVGLinearGradientElementConstructorTable, 0 };

bool JSSVGLinearGradientElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLinearGradientElementConstructor, DOMObject>(exec, &JSSVGLinearGradientElementConstructorTable, this, propertyName, slot);
}

bool JSSVGLinearGradientElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGLinearGradientElementConstructor, DOMObject>(exec, &JSSVGLinearGradientElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGLinearGradientElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGLinearGradientElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGLinearGradientElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGLinearGradientElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGLinearGradientElementPrototype::s_info = { "SVGLinearGradientElementPrototype", 0, &JSSVGLinearGradientElementPrototypeTable, 0 };

JSObject* JSSVGLinearGradientElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGLinearGradientElement>(exec, globalObject);
}

const ClassInfo JSSVGLinearGradientElement::s_info = { "SVGLinearGradientElement", &JSSVGGradientElement::s_info, &JSSVGLinearGradientElementTable, 0 };

JSSVGLinearGradientElement::JSSVGLinearGradientElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGLinearGradientElement> impl)
    : JSSVGGradientElement(structure, globalObject, impl)
{
}

JSObject* JSSVGLinearGradientElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGLinearGradientElementPrototype(JSSVGLinearGradientElementPrototype::createStructure(JSSVGGradientElementPrototype::self(exec, globalObject)));
}

bool JSSVGLinearGradientElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLinearGradientElement, Base>(exec, &JSSVGLinearGradientElementTable, this, propertyName, slot);
}

bool JSSVGLinearGradientElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGLinearGradientElement, Base>(exec, &JSSVGLinearGradientElementTable, this, propertyName, descriptor);
}

JSValue jsSVGLinearGradientElementX1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGLinearGradientElement* castedThis = static_cast<JSSVGLinearGradientElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGLinearGradientElement* imp = static_cast<SVGLinearGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->x1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGLinearGradientElementY1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGLinearGradientElement* castedThis = static_cast<JSSVGLinearGradientElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGLinearGradientElement* imp = static_cast<SVGLinearGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->y1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGLinearGradientElementX2(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGLinearGradientElement* castedThis = static_cast<JSSVGLinearGradientElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGLinearGradientElement* imp = static_cast<SVGLinearGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->x2Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGLinearGradientElementY2(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGLinearGradientElement* castedThis = static_cast<JSSVGLinearGradientElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGLinearGradientElement* imp = static_cast<SVGLinearGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->y2Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGLinearGradientElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGLinearGradientElement* domObject = static_cast<JSSVGLinearGradientElement*>(asObject(slot.slotBase()));
    return JSSVGLinearGradientElement::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGLinearGradientElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGLinearGradientElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
