/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGNumberList.h"

#include "JSSVGNumber.h"
#include "JSSVGPODListCustom.h"
#include "SVGNumberList.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGNumberList);

/* Hash table */

static const HashTableValue JSSVGNumberListTableValues[3] =
{
    { "numberOfItems", DontDelete|ReadOnly, (intptr_t)jsSVGNumberListNumberOfItems, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGNumberListConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGNumberListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGNumberListTableValues, 0 };
#else
    { 4, 3, JSSVGNumberListTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGNumberListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGNumberListConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGNumberListConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGNumberListConstructorTableValues, 0 };
#endif

class JSSVGNumberListConstructor : public DOMConstructorObject {
public:
    JSSVGNumberListConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGNumberListConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGNumberListPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGNumberListConstructor::s_info = { "SVGNumberListConstructor", 0, &JSSVGNumberListConstructorTable, 0 };

bool JSSVGNumberListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGNumberListConstructor, DOMObject>(exec, &JSSVGNumberListConstructorTable, this, propertyName, slot);
}

bool JSSVGNumberListConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGNumberListConstructor, DOMObject>(exec, &JSSVGNumberListConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGNumberListPrototypeTableValues[8] =
{
    { "clear", DontDelete|Function, (intptr_t)jsSVGNumberListPrototypeFunctionClear, (intptr_t)0 },
    { "initialize", DontDelete|Function, (intptr_t)jsSVGNumberListPrototypeFunctionInitialize, (intptr_t)1 },
    { "getItem", DontDelete|Function, (intptr_t)jsSVGNumberListPrototypeFunctionGetItem, (intptr_t)1 },
    { "insertItemBefore", DontDelete|Function, (intptr_t)jsSVGNumberListPrototypeFunctionInsertItemBefore, (intptr_t)2 },
    { "replaceItem", DontDelete|Function, (intptr_t)jsSVGNumberListPrototypeFunctionReplaceItem, (intptr_t)2 },
    { "removeItem", DontDelete|Function, (intptr_t)jsSVGNumberListPrototypeFunctionRemoveItem, (intptr_t)1 },
    { "appendItem", DontDelete|Function, (intptr_t)jsSVGNumberListPrototypeFunctionAppendItem, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGNumberListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSSVGNumberListPrototypeTableValues, 0 };
#else
    { 18, 15, JSSVGNumberListPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGNumberListPrototype::s_info = { "SVGNumberListPrototype", 0, &JSSVGNumberListPrototypeTable, 0 };

JSObject* JSSVGNumberListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGNumberList>(exec, globalObject);
}

bool JSSVGNumberListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGNumberListPrototypeTable, this, propertyName, slot);
}

bool JSSVGNumberListPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGNumberListPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGNumberList::s_info = { "SVGNumberList", 0, &JSSVGNumberListTable, 0 };

JSSVGNumberList::JSSVGNumberList(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGNumberList> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGNumberList::~JSSVGNumberList()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGNumberList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGNumberListPrototype(JSSVGNumberListPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGNumberList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGNumberList, Base>(exec, &JSSVGNumberListTable, this, propertyName, slot);
}

bool JSSVGNumberList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGNumberList, Base>(exec, &JSSVGNumberListTable, this, propertyName, descriptor);
}

JSValue jsSVGNumberListNumberOfItems(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGNumberList* castedThis = static_cast<JSSVGNumberList*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGNumberList* imp = static_cast<SVGNumberList*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->numberOfItems());
    return result;
}

JSValue jsSVGNumberListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGNumberList* domObject = static_cast<JSSVGNumberList*>(asObject(slot.slotBase()));
    return JSSVGNumberList::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGNumberList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGNumberListConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionClear(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwError(exec, TypeError);
    JSSVGNumberList* castedThisObj = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSSVGPODListCustom::clear<JSSVGNumberList, float>(castedThisObj, exec, args, toSVGNumber);
}

JSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionInitialize(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwError(exec, TypeError);
    JSSVGNumberList* castedThisObj = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSSVGPODListCustom::initialize<JSSVGNumberList, float>(castedThisObj, exec, args, toSVGNumber);
}

JSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionGetItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwError(exec, TypeError);
    JSSVGNumberList* castedThisObj = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSSVGPODListCustom::getItem<JSSVGNumberList, float>(castedThisObj, exec, args, toSVGNumber);
}

JSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionInsertItemBefore(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwError(exec, TypeError);
    JSSVGNumberList* castedThisObj = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSSVGPODListCustom::insertItemBefore<JSSVGNumberList, float>(castedThisObj, exec, args, toSVGNumber);
}

JSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionReplaceItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwError(exec, TypeError);
    JSSVGNumberList* castedThisObj = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSSVGPODListCustom::replaceItem<JSSVGNumberList, float>(castedThisObj, exec, args, toSVGNumber);
}

JSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionRemoveItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwError(exec, TypeError);
    JSSVGNumberList* castedThisObj = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSSVGPODListCustom::removeItem<JSSVGNumberList, float>(castedThisObj, exec, args, toSVGNumber);
}

JSValue JSC_HOST_CALL jsSVGNumberListPrototypeFunctionAppendItem(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGNumberList::s_info))
        return throwError(exec, TypeError);
    JSSVGNumberList* castedThisObj = static_cast<JSSVGNumberList*>(asObject(thisValue));
    return JSSVGPODListCustom::appendItem<JSSVGNumberList, float>(castedThisObj, exec, args, toSVGNumber);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGNumberList* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGNumberList>(exec, globalObject, object, context);
}
SVGNumberList* toSVGNumberList(JSC::JSValue value)
{
    return value.inherits(&JSSVGNumberList::s_info) ? static_cast<JSSVGNumberList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
