/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPathElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGPathSegArcAbs.h"
#include "JSSVGPathSegArcRel.h"
#include "JSSVGPathSegClosePath.h"
#include "JSSVGPathSegCurvetoCubicAbs.h"
#include "JSSVGPathSegCurvetoCubicRel.h"
#include "JSSVGPathSegCurvetoCubicSmoothAbs.h"
#include "JSSVGPathSegCurvetoCubicSmoothRel.h"
#include "JSSVGPathSegCurvetoQuadraticAbs.h"
#include "JSSVGPathSegCurvetoQuadraticRel.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothAbs.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothRel.h"
#include "JSSVGPathSegLinetoAbs.h"
#include "JSSVGPathSegLinetoHorizontalAbs.h"
#include "JSSVGPathSegLinetoHorizontalRel.h"
#include "JSSVGPathSegLinetoRel.h"
#include "JSSVGPathSegLinetoVerticalAbs.h"
#include "JSSVGPathSegLinetoVerticalRel.h"
#include "JSSVGPathSegList.h"
#include "JSSVGPathSegMovetoAbs.h"
#include "JSSVGPathSegMovetoRel.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGPathElement.h"
#include "SVGPathSegArc.h"
#include "SVGPathSegClosePath.h"
#include "SVGPathSegCurvetoCubic.h"
#include "SVGPathSegCurvetoCubicSmooth.h"
#include "SVGPathSegCurvetoQuadratic.h"
#include "SVGPathSegCurvetoQuadraticSmooth.h"
#include "SVGPathSegLineto.h"
#include "SVGPathSegLinetoHorizontal.h"
#include "SVGPathSegLinetoVertical.h"
#include "SVGPathSegList.h"
#include "SVGPathSegMoveto.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGPathElement);

/* Hash table */

static const HashTableValue JSSVGPathElementTableValues[18] =
{
    { "pathLength", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementPathLength, (intptr_t)0 },
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGPathElementXmllang, (intptr_t)setJSSVGPathElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGPathElementXmlspace, (intptr_t)setJSSVGPathElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementStyle, (intptr_t)0 },
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementFarthestViewportElement, (intptr_t)0 },
    { "pathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementPathSegList, (intptr_t)0 },
    { "normalizedPathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementNormalizedPathSegList, (intptr_t)0 },
    { "animatedPathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementAnimatedPathSegList, (intptr_t)0 },
    { "animatedNormalizedPathSegList", DontDelete|ReadOnly, (intptr_t)jsSVGPathElementAnimatedNormalizedPathSegList, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGPathElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPathElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGPathElementTableValues, 0 };
#else
    { 67, 63, JSSVGPathElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGPathElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPathElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGPathElementConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGPathElementConstructorTableValues, 0 };
#endif

class JSSVGPathElementConstructor : public DOMConstructorObject {
public:
    JSSVGPathElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGPathElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGPathElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGPathElementConstructor::s_info = { "SVGPathElementConstructor", 0, &JSSVGPathElementConstructorTable, 0 };

bool JSSVGPathElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathElementConstructor, DOMObject>(exec, &JSSVGPathElementConstructorTable, this, propertyName, slot);
}

bool JSSVGPathElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathElementConstructor, DOMObject>(exec, &JSSVGPathElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathElementPrototypeTableValues[29] =
{
    { "getTotalLength", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetTotalLength, (intptr_t)0 },
    { "getPointAtLength", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetPointAtLength, (intptr_t)1 },
    { "getPathSegAtLength", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetPathSegAtLength, (intptr_t)1 },
    { "createSVGPathSegClosePath", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegClosePath, (intptr_t)0 },
    { "createSVGPathSegMovetoAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoAbs, (intptr_t)2 },
    { "createSVGPathSegMovetoRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoRel, (intptr_t)2 },
    { "createSVGPathSegLinetoAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoAbs, (intptr_t)2 },
    { "createSVGPathSegLinetoRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoRel, (intptr_t)2 },
    { "createSVGPathSegCurvetoCubicAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicAbs, (intptr_t)6 },
    { "createSVGPathSegCurvetoCubicRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicRel, (intptr_t)6 },
    { "createSVGPathSegCurvetoQuadraticAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticAbs, (intptr_t)4 },
    { "createSVGPathSegCurvetoQuadraticRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticRel, (intptr_t)4 },
    { "createSVGPathSegArcAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcAbs, (intptr_t)7 },
    { "createSVGPathSegArcRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcRel, (intptr_t)7 },
    { "createSVGPathSegLinetoHorizontalAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalAbs, (intptr_t)1 },
    { "createSVGPathSegLinetoHorizontalRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalRel, (intptr_t)1 },
    { "createSVGPathSegLinetoVerticalAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalAbs, (intptr_t)1 },
    { "createSVGPathSegLinetoVerticalRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalRel, (intptr_t)1 },
    { "createSVGPathSegCurvetoCubicSmoothAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothAbs, (intptr_t)4 },
    { "createSVGPathSegCurvetoCubicSmoothRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothRel, (intptr_t)4 },
    { "createSVGPathSegCurvetoQuadraticSmoothAbs", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothAbs, (intptr_t)2 },
    { "createSVGPathSegCurvetoQuadraticSmoothRel", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothRel, (intptr_t)2 },
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGPathElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPathElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSSVGPathElementPrototypeTableValues, 0 };
#else
    { 69, 63, JSSVGPathElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGPathElementPrototype::s_info = { "SVGPathElementPrototype", 0, &JSSVGPathElementPrototypeTable, 0 };

JSObject* JSSVGPathElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathElement>(exec, globalObject);
}

bool JSSVGPathElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPathElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGPathElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGPathElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGPathElement::s_info = { "SVGPathElement", &JSSVGElement::s_info, &JSSVGPathElementTable, 0 };

JSSVGPathElement::JSSVGPathElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPathElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGPathElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGPathElementPrototype(JSSVGPathElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGPathElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathElement, Base>(exec, &JSSVGPathElementTable, this, propertyName, slot);
}

bool JSSVGPathElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathElement, Base>(exec, &JSSVGPathElementTable, this, propertyName, descriptor);
}

JSValue jsSVGPathElementPathLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->pathLengthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGPathElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredFeatures()), imp);
    return result;
}

JSValue jsSVGPathElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredExtensions()), imp);
    return result;
}

JSValue jsSVGPathElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->systemLanguage()), imp);
    return result;
}

JSValue jsSVGPathElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmllang());
    return result;
}

JSValue jsSVGPathElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmlspace());
    return result;
}

JSValue jsSVGPathElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGPathElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGPathElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}

JSValue jsSVGPathElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGPathElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nearestViewportElement()));
    return result;
}

JSValue jsSVGPathElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->farthestViewportElement()));
    return result;
}

JSValue jsSVGPathElementPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->pathSegList()), imp);
    return result;
}

JSValue jsSVGPathElementNormalizedPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->normalizedPathSegList()), imp);
    return result;
}

JSValue jsSVGPathElementAnimatedPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->animatedPathSegList()), imp);
    return result;
}

JSValue jsSVGPathElementAnimatedNormalizedPathSegList(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* castedThis = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->animatedNormalizedPathSegList()), imp);
    return result;
}

JSValue jsSVGPathElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathElement* domObject = static_cast<JSSVGPathElement*>(asObject(slot.slotBase()));
    return JSSVGPathElement::getConstructor(exec, domObject->globalObject());
}
void JSSVGPathElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGPathElement, Base>(exec, propertyName, value, &JSSVGPathElementTable, this, slot);
}

void setJSSVGPathElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(thisObject);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    imp->setXmllang(value.toString(exec));
}

void setJSSVGPathElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(thisObject);
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    imp->setXmlspace(value.toString(exec));
}

JSValue JSSVGPathElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetTotalLength(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());


    JSC::JSValue result = jsNumber(exec, imp->getTotalLength());
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetPointAtLength(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float distance = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<FloatPoint>::create(imp->getPointAtLength(distance)).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetPathSegAtLength(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    float distance = args.at(0).toFloat(exec);


    JSC::JSValue result = jsNumber(exec, imp->getPathSegAtLength(distance, ec));
    setDOMException(exec, ec);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegClosePath(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegClosePath()), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoAbs(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegMovetoAbs(x, y)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoRel(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegMovetoRel(x, y)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoAbs(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegLinetoAbs(x, y)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoRel(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegLinetoRel(x, y)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicAbs(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float x1 = args.at(2).toFloat(exec);
    float y1 = args.at(3).toFloat(exec);
    float x2 = args.at(4).toFloat(exec);
    float y2 = args.at(5).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegCurvetoCubicAbs(x, y, x1, y1, x2, y2)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicRel(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float x1 = args.at(2).toFloat(exec);
    float y1 = args.at(3).toFloat(exec);
    float x2 = args.at(4).toFloat(exec);
    float y2 = args.at(5).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegCurvetoCubicRel(x, y, x1, y1, x2, y2)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticAbs(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float x1 = args.at(2).toFloat(exec);
    float y1 = args.at(3).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticAbs(x, y, x1, y1)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticRel(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float x1 = args.at(2).toFloat(exec);
    float y1 = args.at(3).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticRel(x, y, x1, y1)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcAbs(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float r1 = args.at(2).toFloat(exec);
    float r2 = args.at(3).toFloat(exec);
    float angle = args.at(4).toFloat(exec);
    bool largeArcFlag = args.at(5).toBoolean(exec);
    bool sweepFlag = args.at(6).toBoolean(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegArcAbs(x, y, r1, r2, angle, largeArcFlag, sweepFlag)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcRel(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float r1 = args.at(2).toFloat(exec);
    float r2 = args.at(3).toFloat(exec);
    float angle = args.at(4).toFloat(exec);
    bool largeArcFlag = args.at(5).toBoolean(exec);
    bool sweepFlag = args.at(6).toBoolean(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegArcRel(x, y, r1, r2, angle, largeArcFlag, sweepFlag)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalAbs(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegLinetoHorizontalAbs(x)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalRel(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegLinetoHorizontalRel(x)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalAbs(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float y = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegLinetoVerticalAbs(y)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalRel(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float y = args.at(0).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegLinetoVerticalRel(y)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothAbs(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float x2 = args.at(2).toFloat(exec);
    float y2 = args.at(3).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegCurvetoCubicSmoothAbs(x, y, x2, y2)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothRel(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);
    float x2 = args.at(2).toFloat(exec);
    float y2 = args.at(3).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegCurvetoCubicSmoothRel(x, y, x2, y2)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothAbs(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticSmoothAbs(x, y)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothRel(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    float x = args.at(0).toFloat(exec);
    float y = args.at(1).toFloat(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->createSVGPathSegCurvetoQuadraticSmoothRel(x, y)), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    const UString& extension = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getCTM()).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getScreenCTM()).get(), 0 /* no context on purpose */);
    return result;
}

JSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwError(exec, TypeError);
    JSSVGPathElement* castedThisObj = static_cast<JSSVGPathElement*>(asObject(thisValue));
    SVGPathElement* imp = static_cast<SVGPathElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(0));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<AffineTransform>::create(imp->getTransformToElement(element, ec)).get(), 0 /* no context on purpose */);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
