/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPathSegArcRel.h"

#include "SVGPathSegArc.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGPathSegArcRel);

/* Hash table */

static const HashTableValue JSSVGPathSegArcRelTableValues[9] =
{
    { "x", DontDelete, (intptr_t)jsSVGPathSegArcRelX, (intptr_t)setJSSVGPathSegArcRelX },
    { "y", DontDelete, (intptr_t)jsSVGPathSegArcRelY, (intptr_t)setJSSVGPathSegArcRelY },
    { "r1", DontDelete, (intptr_t)jsSVGPathSegArcRelR1, (intptr_t)setJSSVGPathSegArcRelR1 },
    { "r2", DontDelete, (intptr_t)jsSVGPathSegArcRelR2, (intptr_t)setJSSVGPathSegArcRelR2 },
    { "angle", DontDelete, (intptr_t)jsSVGPathSegArcRelAngle, (intptr_t)setJSSVGPathSegArcRelAngle },
    { "largeArcFlag", DontDelete, (intptr_t)jsSVGPathSegArcRelLargeArcFlag, (intptr_t)setJSSVGPathSegArcRelLargeArcFlag },
    { "sweepFlag", DontDelete, (intptr_t)jsSVGPathSegArcRelSweepFlag, (intptr_t)setJSSVGPathSegArcRelSweepFlag },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGPathSegArcRelConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPathSegArcRelTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGPathSegArcRelTableValues, 0 };
#else
    { 17, 15, JSSVGPathSegArcRelTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGPathSegArcRelConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPathSegArcRelConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGPathSegArcRelConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGPathSegArcRelConstructorTableValues, 0 };
#endif

class JSSVGPathSegArcRelConstructor : public DOMConstructorObject {
public:
    JSSVGPathSegArcRelConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGPathSegArcRelConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGPathSegArcRelPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGPathSegArcRelConstructor::s_info = { "SVGPathSegArcRelConstructor", 0, &JSSVGPathSegArcRelConstructorTable, 0 };

bool JSSVGPathSegArcRelConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathSegArcRelConstructor, DOMObject>(exec, &JSSVGPathSegArcRelConstructorTable, this, propertyName, slot);
}

bool JSSVGPathSegArcRelConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathSegArcRelConstructor, DOMObject>(exec, &JSSVGPathSegArcRelConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegArcRelPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPathSegArcRelPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGPathSegArcRelPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGPathSegArcRelPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGPathSegArcRelPrototype::s_info = { "SVGPathSegArcRelPrototype", 0, &JSSVGPathSegArcRelPrototypeTable, 0 };

JSObject* JSSVGPathSegArcRelPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathSegArcRel>(exec, globalObject);
}

const ClassInfo JSSVGPathSegArcRel::s_info = { "SVGPathSegArcRel", &JSSVGPathSeg::s_info, &JSSVGPathSegArcRelTable, 0 };

JSSVGPathSegArcRel::JSSVGPathSegArcRel(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPathSegArcRel> impl)
    : JSSVGPathSeg(structure, globalObject, impl)
{
}

JSObject* JSSVGPathSegArcRel::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGPathSegArcRelPrototype(JSSVGPathSegArcRelPrototype::createStructure(JSSVGPathSegPrototype::self(exec, globalObject)));
}

bool JSSVGPathSegArcRel::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathSegArcRel, Base>(exec, &JSSVGPathSegArcRelTable, this, propertyName, slot);
}

bool JSSVGPathSegArcRel::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathSegArcRel, Base>(exec, &JSSVGPathSegArcRelTable, this, propertyName, descriptor);
}

JSValue jsSVGPathSegArcRelX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathSegArcRel* castedThis = static_cast<JSSVGPathSegArcRel*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->x());
    return result;
}

JSValue jsSVGPathSegArcRelY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathSegArcRel* castedThis = static_cast<JSSVGPathSegArcRel*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->y());
    return result;
}

JSValue jsSVGPathSegArcRelR1(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathSegArcRel* castedThis = static_cast<JSSVGPathSegArcRel*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->r1());
    return result;
}

JSValue jsSVGPathSegArcRelR2(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathSegArcRel* castedThis = static_cast<JSSVGPathSegArcRel*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->r2());
    return result;
}

JSValue jsSVGPathSegArcRelAngle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathSegArcRel* castedThis = static_cast<JSSVGPathSegArcRel*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->angle());
    return result;
}

JSValue jsSVGPathSegArcRelLargeArcFlag(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathSegArcRel* castedThis = static_cast<JSSVGPathSegArcRel*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThis->impl());
    JSValue result = jsBoolean(imp->largeArcFlag());
    return result;
}

JSValue jsSVGPathSegArcRelSweepFlag(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathSegArcRel* castedThis = static_cast<JSSVGPathSegArcRel*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThis->impl());
    JSValue result = jsBoolean(imp->sweepFlag());
    return result;
}

JSValue jsSVGPathSegArcRelConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPathSegArcRel* domObject = static_cast<JSSVGPathSegArcRel*>(asObject(slot.slotBase()));
    return JSSVGPathSegArcRel::getConstructor(exec, domObject->globalObject());
}
void JSSVGPathSegArcRel::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGPathSegArcRel, Base>(exec, propertyName, value, &JSSVGPathSegArcRelTable, this, slot);
}

void setJSSVGPathSegArcRelX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGPathSegArcRel* castedThisObj = static_cast<JSSVGPathSegArcRel*>(thisObject);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThisObj->impl());
    imp->setX(value.toFloat(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

void setJSSVGPathSegArcRelY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGPathSegArcRel* castedThisObj = static_cast<JSSVGPathSegArcRel*>(thisObject);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThisObj->impl());
    imp->setY(value.toFloat(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

void setJSSVGPathSegArcRelR1(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGPathSegArcRel* castedThisObj = static_cast<JSSVGPathSegArcRel*>(thisObject);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThisObj->impl());
    imp->setR1(value.toFloat(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

void setJSSVGPathSegArcRelR2(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGPathSegArcRel* castedThisObj = static_cast<JSSVGPathSegArcRel*>(thisObject);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThisObj->impl());
    imp->setR2(value.toFloat(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

void setJSSVGPathSegArcRelAngle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGPathSegArcRel* castedThisObj = static_cast<JSSVGPathSegArcRel*>(thisObject);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThisObj->impl());
    imp->setAngle(value.toFloat(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

void setJSSVGPathSegArcRelLargeArcFlag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGPathSegArcRel* castedThisObj = static_cast<JSSVGPathSegArcRel*>(thisObject);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThisObj->impl());
    imp->setLargeArcFlag(value.toBoolean(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

void setJSSVGPathSegArcRelSweepFlag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGPathSegArcRel* castedThisObj = static_cast<JSSVGPathSegArcRel*>(thisObject);
    SVGPathSegArcRel* imp = static_cast<SVGPathSegArcRel*>(castedThisObj->impl());
    imp->setSweepFlag(value.toBoolean(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

JSValue JSSVGPathSegArcRel::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegArcRelConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
