/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPreserveAspectRatio.h"

#include "SVGPreserveAspectRatio.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGPreserveAspectRatio);

/* Hash table */

static const HashTableValue JSSVGPreserveAspectRatioTableValues[4] =
{
    { "align", DontDelete, (intptr_t)jsSVGPreserveAspectRatioAlign, (intptr_t)setJSSVGPreserveAspectRatioAlign },
    { "meetOrSlice", DontDelete, (intptr_t)jsSVGPreserveAspectRatioMeetOrSlice, (intptr_t)setJSSVGPreserveAspectRatioMeetOrSlice },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPreserveAspectRatioTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSSVGPreserveAspectRatioTableValues, 0 };
#else
    { 8, 7, JSSVGPreserveAspectRatioTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGPreserveAspectRatioConstructorTableValues[15] =
{
    { "SVG_PRESERVEASPECTRATIO_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_UNKNOWN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_NONE", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_NONE, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMAX, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMAX, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMAX, (intptr_t)0 },
    { "SVG_MEETORSLICE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_UNKNOWN, (intptr_t)0 },
    { "SVG_MEETORSLICE_MEET", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_MEET, (intptr_t)0 },
    { "SVG_MEETORSLICE_SLICE", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_SLICE, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPreserveAspectRatioConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSSVGPreserveAspectRatioConstructorTableValues, 0 };
#else
    { 35, 31, JSSVGPreserveAspectRatioConstructorTableValues, 0 };
#endif

class JSSVGPreserveAspectRatioConstructor : public DOMConstructorObject {
public:
    JSSVGPreserveAspectRatioConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGPreserveAspectRatioConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGPreserveAspectRatioPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGPreserveAspectRatioConstructor::s_info = { "SVGPreserveAspectRatioConstructor", 0, &JSSVGPreserveAspectRatioConstructorTable, 0 };

bool JSSVGPreserveAspectRatioConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPreserveAspectRatioConstructor, DOMObject>(exec, &JSSVGPreserveAspectRatioConstructorTable, this, propertyName, slot);
}

bool JSSVGPreserveAspectRatioConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPreserveAspectRatioConstructor, DOMObject>(exec, &JSSVGPreserveAspectRatioConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPreserveAspectRatioPrototypeTableValues[15] =
{
    { "SVG_PRESERVEASPECTRATIO_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_UNKNOWN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_NONE", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_NONE, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMIN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMIN, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMID", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMID, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMINYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMAX, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMAX, (intptr_t)0 },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMAX", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMAX, (intptr_t)0 },
    { "SVG_MEETORSLICE_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_UNKNOWN, (intptr_t)0 },
    { "SVG_MEETORSLICE_MEET", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_MEET, (intptr_t)0 },
    { "SVG_MEETORSLICE_SLICE", DontDelete|ReadOnly, (intptr_t)jsSVGPreserveAspectRatioSVG_MEETORSLICE_SLICE, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGPreserveAspectRatioPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSSVGPreserveAspectRatioPrototypeTableValues, 0 };
#else
    { 35, 31, JSSVGPreserveAspectRatioPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGPreserveAspectRatioPrototype::s_info = { "SVGPreserveAspectRatioPrototype", 0, &JSSVGPreserveAspectRatioPrototypeTable, 0 };

JSObject* JSSVGPreserveAspectRatioPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPreserveAspectRatio>(exec, globalObject);
}

bool JSSVGPreserveAspectRatioPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPreserveAspectRatioPrototype, JSObject>(exec, &JSSVGPreserveAspectRatioPrototypeTable, this, propertyName, slot);
}

bool JSSVGPreserveAspectRatioPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPreserveAspectRatioPrototype, JSObject>(exec, &JSSVGPreserveAspectRatioPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGPreserveAspectRatio::s_info = { "SVGPreserveAspectRatio", 0, &JSSVGPreserveAspectRatioTable, 0 };

JSSVGPreserveAspectRatio::JSSVGPreserveAspectRatio(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<JSSVGPODTypeWrapper<SVGPreserveAspectRatio> > impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGPreserveAspectRatio::~JSSVGPreserveAspectRatio()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGPreserveAspectRatio::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGPreserveAspectRatioPrototype(JSSVGPreserveAspectRatioPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGPreserveAspectRatio::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPreserveAspectRatio, Base>(exec, &JSSVGPreserveAspectRatioTable, this, propertyName, slot);
}

bool JSSVGPreserveAspectRatio::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPreserveAspectRatio, Base>(exec, &JSSVGPreserveAspectRatioTable, this, propertyName, descriptor);
}

JSValue jsSVGPreserveAspectRatioAlign(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPreserveAspectRatio* castedThis = static_cast<JSSVGPreserveAspectRatio*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPreserveAspectRatio imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.align());
    return result;
}

JSValue jsSVGPreserveAspectRatioMeetOrSlice(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPreserveAspectRatio* castedThis = static_cast<JSSVGPreserveAspectRatio*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGPreserveAspectRatio imp(*castedThis->impl());
    JSValue result =  jsNumber(exec, imp.meetOrSlice());
    return result;
}

JSValue jsSVGPreserveAspectRatioConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGPreserveAspectRatio* domObject = static_cast<JSSVGPreserveAspectRatio*>(asObject(slot.slotBase()));
    return JSSVGPreserveAspectRatio::getConstructor(exec, domObject->globalObject());
}
void JSSVGPreserveAspectRatio::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGPreserveAspectRatio, Base>(exec, propertyName, value, &JSSVGPreserveAspectRatioTable, this, slot);
}

void setJSSVGPreserveAspectRatioAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGPreserveAspectRatio* castedThisObj = static_cast<JSSVGPreserveAspectRatio*>(thisObject);
    JSSVGPODTypeWrapper<SVGPreserveAspectRatio> * imp = static_cast<JSSVGPODTypeWrapper<SVGPreserveAspectRatio> *>(castedThisObj->impl());
    SVGPreserveAspectRatio podImp(*imp);
    podImp.setAlign(value.toInt32(exec));
    imp->commitChange(podImp, castedThisObj);
}

void setJSSVGPreserveAspectRatioMeetOrSlice(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGPreserveAspectRatio* castedThisObj = static_cast<JSSVGPreserveAspectRatio*>(thisObject);
    JSSVGPODTypeWrapper<SVGPreserveAspectRatio> * imp = static_cast<JSSVGPODTypeWrapper<SVGPreserveAspectRatio> *>(castedThisObj->impl());
    SVGPreserveAspectRatio podImp(*imp);
    podImp.setMeetOrSlice(value.toInt32(exec));
    imp->commitChange(podImp, castedThisObj);
}

JSValue JSSVGPreserveAspectRatio::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPreserveAspectRatioConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_NONE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMIN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMIN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(3));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMIN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(4));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMID(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(5));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMID(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(6));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMID(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(7));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMAX(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(8));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMAX(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(9));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMAX(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(10));
}

JSValue jsSVGPreserveAspectRatioSVG_MEETORSLICE_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsSVGPreserveAspectRatioSVG_MEETORSLICE_MEET(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsSVGPreserveAspectRatioSVG_MEETORSLICE_SLICE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, JSSVGPODTypeWrapper<SVGPreserveAspectRatio>* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGPreserveAspectRatio, JSSVGPODTypeWrapper<SVGPreserveAspectRatio> >(exec, globalObject, object, context);
}
SVGPreserveAspectRatio toSVGPreserveAspectRatio(JSC::JSValue value)
{
    return value.inherits(&JSSVGPreserveAspectRatio::s_info) ? (SVGPreserveAspectRatio) *static_cast<JSSVGPreserveAspectRatio*>(asObject(value))->impl() : SVGPreserveAspectRatio();
}

}

#endif // ENABLE(SVG)
