/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGStylable.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedString.h"
#include "SVGStylable.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGStylable);

/* Hash table */

static const HashTableValue JSSVGStylableTableValues[3] =
{
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGStylableClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGStylableStyle, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGStylableTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGStylableTableValues, 0 };
#else
    { 4, 3, JSSVGStylableTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGStylablePrototypeTableValues[2] =
{
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGStylablePrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGStylablePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGStylablePrototypeTableValues, 0 };
#else
    { 2, 1, JSSVGStylablePrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGStylablePrototype::s_info = { "SVGStylablePrototype", 0, &JSSVGStylablePrototypeTable, 0 };

JSObject* JSSVGStylablePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGStylable>(exec, globalObject);
}

bool JSSVGStylablePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGStylablePrototypeTable, this, propertyName, slot);
}

bool JSSVGStylablePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGStylablePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGStylable::s_info = { "SVGStylable", 0, &JSSVGStylableTable, 0 };

JSSVGStylable::JSSVGStylable(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGStylable> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGStylable::~JSSVGStylable()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGStylable::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGStylablePrototype(JSSVGStylablePrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGStylable::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGStylable, Base>(exec, &JSSVGStylableTable, this, propertyName, slot);
}

bool JSSVGStylable::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGStylable, Base>(exec, &JSSVGStylableTable, this, propertyName, descriptor);
}

JSValue jsSVGStylableClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGStylable* castedThis = static_cast<JSSVGStylable*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGStylable* imp = static_cast<SVGStylable*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGStylableStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGStylable* castedThis = static_cast<JSSVGStylable*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGStylable* imp = static_cast<SVGStylable*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}

JSValue JSC_HOST_CALL jsSVGStylablePrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGStylable::s_info))
        return throwError(exec, TypeError);
    JSSVGStylable* castedThisObj = static_cast<JSSVGStylable*>(asObject(thisValue));
    SVGStylable* imp = static_cast<SVGStylable*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGStylable* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGStylable>(exec, globalObject, object, context);
}
SVGStylable* toSVGStylable(JSC::JSValue value)
{
    return value.inherits(&JSSVGStylable::s_info) ? static_cast<JSSVGStylable*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
