/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTests.h"

#include "JSSVGStringList.h"
#include "SVGStringList.h"
#include "SVGTests.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGTests);

/* Hash table */

static const HashTableValue JSSVGTestsTableValues[4] =
{
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGTestsRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGTestsRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGTestsSystemLanguage, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGTestsTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSSVGTestsTableValues, 0 };
#else
    { 8, 7, JSSVGTestsTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGTestsPrototypeTableValues[2] =
{
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGTestsPrototypeFunctionHasExtension, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGTestsPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGTestsPrototypeTableValues, 0 };
#else
    { 2, 1, JSSVGTestsPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGTestsPrototype::s_info = { "SVGTestsPrototype", 0, &JSSVGTestsPrototypeTable, 0 };

JSObject* JSSVGTestsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTests>(exec, globalObject);
}

bool JSSVGTestsPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGTestsPrototypeTable, this, propertyName, slot);
}

bool JSSVGTestsPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGTestsPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGTests::s_info = { "SVGTests", 0, &JSSVGTestsTable, 0 };

JSSVGTests::JSSVGTests(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTests> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGTests::~JSSVGTests()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGTests::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGTestsPrototype(JSSVGTestsPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGTests::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTests, Base>(exec, &JSSVGTestsTable, this, propertyName, slot);
}

bool JSSVGTests::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTests, Base>(exec, &JSSVGTestsTable, this, propertyName, descriptor);
}

JSValue jsSVGTestsRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGTests* castedThis = static_cast<JSSVGTests*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGTests* imp = static_cast<SVGTests*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredFeatures()), JSSVGContextCache::svgContextForDOMObject(castedThis));
    return result;
}

JSValue jsSVGTestsRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGTests* castedThis = static_cast<JSSVGTests*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGTests* imp = static_cast<SVGTests*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredExtensions()), JSSVGContextCache::svgContextForDOMObject(castedThis));
    return result;
}

JSValue jsSVGTestsSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGTests* castedThis = static_cast<JSSVGTests*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGTests* imp = static_cast<SVGTests*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->systemLanguage()), JSSVGContextCache::svgContextForDOMObject(castedThis));
    return result;
}

JSValue JSC_HOST_CALL jsSVGTestsPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGTests::s_info))
        return throwError(exec, TypeError);
    JSSVGTests* castedThisObj = static_cast<JSSVGTests*>(asObject(thisValue));
    SVGTests* imp = static_cast<SVGTests*>(castedThisObj->impl());
    const UString& extension = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGTests* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGTests>(exec, globalObject, object, context);
}
SVGTests* toSVGTests(JSC::JSValue value)
{
    return value.inherits(&JSSVGTests::s_info) ? static_cast<JSSVGTests*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
