/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGZoomAndPan.h"

#include "SVGZoomAndPan.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGZoomAndPan);

/* Hash table */

static const HashTableValue JSSVGZoomAndPanTableValues[3] =
{
    { "zoomAndPan", DontDelete, (intptr_t)jsSVGZoomAndPanZoomAndPan, (intptr_t)setJSSVGZoomAndPanZoomAndPan },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsSVGZoomAndPanConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGZoomAndPanTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSSVGZoomAndPanTableValues, 0 };
#else
    { 4, 3, JSSVGZoomAndPanTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGZoomAndPanConstructorTableValues[4] =
{
    { "SVG_ZOOMANDPAN_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGZoomAndPanSVG_ZOOMANDPAN_UNKNOWN, (intptr_t)0 },
    { "SVG_ZOOMANDPAN_DISABLE", DontDelete|ReadOnly, (intptr_t)jsSVGZoomAndPanSVG_ZOOMANDPAN_DISABLE, (intptr_t)0 },
    { "SVG_ZOOMANDPAN_MAGNIFY", DontDelete|ReadOnly, (intptr_t)jsSVGZoomAndPanSVG_ZOOMANDPAN_MAGNIFY, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGZoomAndPanConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGZoomAndPanConstructorTableValues, 0 };
#else
    { 9, 7, JSSVGZoomAndPanConstructorTableValues, 0 };
#endif

class JSSVGZoomAndPanConstructor : public DOMConstructorObject {
public:
    JSSVGZoomAndPanConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGZoomAndPanConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGZoomAndPanPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGZoomAndPanConstructor::s_info = { "SVGZoomAndPanConstructor", 0, &JSSVGZoomAndPanConstructorTable, 0 };

bool JSSVGZoomAndPanConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGZoomAndPanConstructor, DOMObject>(exec, &JSSVGZoomAndPanConstructorTable, this, propertyName, slot);
}

bool JSSVGZoomAndPanConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGZoomAndPanConstructor, DOMObject>(exec, &JSSVGZoomAndPanConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGZoomAndPanPrototypeTableValues[4] =
{
    { "SVG_ZOOMANDPAN_UNKNOWN", DontDelete|ReadOnly, (intptr_t)jsSVGZoomAndPanSVG_ZOOMANDPAN_UNKNOWN, (intptr_t)0 },
    { "SVG_ZOOMANDPAN_DISABLE", DontDelete|ReadOnly, (intptr_t)jsSVGZoomAndPanSVG_ZOOMANDPAN_DISABLE, (intptr_t)0 },
    { "SVG_ZOOMANDPAN_MAGNIFY", DontDelete|ReadOnly, (intptr_t)jsSVGZoomAndPanSVG_ZOOMANDPAN_MAGNIFY, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGZoomAndPanPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGZoomAndPanPrototypeTableValues, 0 };
#else
    { 9, 7, JSSVGZoomAndPanPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGZoomAndPanPrototype::s_info = { "SVGZoomAndPanPrototype", 0, &JSSVGZoomAndPanPrototypeTable, 0 };

JSObject* JSSVGZoomAndPanPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGZoomAndPan>(exec, globalObject);
}

bool JSSVGZoomAndPanPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGZoomAndPanPrototype, JSObject>(exec, &JSSVGZoomAndPanPrototypeTable, this, propertyName, slot);
}

bool JSSVGZoomAndPanPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGZoomAndPanPrototype, JSObject>(exec, &JSSVGZoomAndPanPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGZoomAndPan::s_info = { "SVGZoomAndPan", 0, &JSSVGZoomAndPanTable, 0 };

JSSVGZoomAndPan::JSSVGZoomAndPan(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGZoomAndPan> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSSVGZoomAndPan::~JSSVGZoomAndPan()
{
    forgetDOMObject(this, impl());
    JSSVGContextCache::forgetWrapper(this);
}

JSObject* JSSVGZoomAndPan::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGZoomAndPanPrototype(JSSVGZoomAndPanPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGZoomAndPan::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGZoomAndPan, Base>(exec, &JSSVGZoomAndPanTable, this, propertyName, slot);
}

bool JSSVGZoomAndPan::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGZoomAndPan, Base>(exec, &JSSVGZoomAndPanTable, this, propertyName, descriptor);
}

JSValue jsSVGZoomAndPanZoomAndPan(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGZoomAndPan* castedThis = static_cast<JSSVGZoomAndPan*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGZoomAndPan* imp = static_cast<SVGZoomAndPan*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->zoomAndPan());
    return result;
}

JSValue jsSVGZoomAndPanConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGZoomAndPan* domObject = static_cast<JSSVGZoomAndPan*>(asObject(slot.slotBase()));
    return JSSVGZoomAndPan::getConstructor(exec, domObject->globalObject());
}
void JSSVGZoomAndPan::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGZoomAndPan, Base>(exec, propertyName, value, &JSSVGZoomAndPanTable, this, slot);
}

void setJSSVGZoomAndPanZoomAndPan(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGZoomAndPan* castedThisObj = static_cast<JSSVGZoomAndPan*>(thisObject);
    SVGZoomAndPan* imp = static_cast<SVGZoomAndPan*>(castedThisObj->impl());
    imp->setZoomAndPan(value.toInt32(exec));
    JSSVGContextCache::propagateSVGDOMChange(castedThisObj, imp->associatedAttributeName());
}

JSValue JSSVGZoomAndPan::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGZoomAndPanConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGZoomAndPanSVG_ZOOMANDPAN_UNKNOWN(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsSVGZoomAndPanSVG_ZOOMANDPAN_DISABLE(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsSVGZoomAndPanSVG_ZOOMANDPAN_MAGNIFY(ExecState* exec, const Identifier&, const PropertySlot&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGZoomAndPan* object, SVGElement* context)
{
    return getDOMObjectWrapper<JSSVGZoomAndPan>(exec, globalObject, object, context);
}
SVGZoomAndPan* toSVGZoomAndPan(JSC::JSValue value)
{
    return value.inherits(&JSSVGZoomAndPan::s_info) ? static_cast<JSSVGZoomAndPan*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
