/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTextEvent.h"

#include "JSDOMWindow.h"
#include "KURL.h"
#include "TextEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSTextEvent);

/* Hash table */

static const HashTableValue JSTextEventTableValues[3] =
{
    { "data", DontDelete|ReadOnly, (intptr_t)jsTextEventData, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsTextEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSTextEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSTextEventTableValues, 0 };
#else
    { 4, 3, JSTextEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSTextEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSTextEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSTextEventConstructorTableValues, 0 };
#else
    { 1, 0, JSTextEventConstructorTableValues, 0 };
#endif

class JSTextEventConstructor : public DOMConstructorObject {
public:
    JSTextEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSTextEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSTextEventPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSTextEventConstructor::s_info = { "TextEventConstructor", 0, &JSTextEventConstructorTable, 0 };

bool JSTextEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextEventConstructor, DOMObject>(exec, &JSTextEventConstructorTable, this, propertyName, slot);
}

bool JSTextEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTextEventConstructor, DOMObject>(exec, &JSTextEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSTextEventPrototypeTableValues[2] =
{
    { "initTextEvent", DontDelete|Function, (intptr_t)jsTextEventPrototypeFunctionInitTextEvent, (intptr_t)5 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSTextEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSTextEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSTextEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSTextEventPrototype::s_info = { "TextEventPrototype", 0, &JSTextEventPrototypeTable, 0 };

JSObject* JSTextEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTextEvent>(exec, globalObject);
}

bool JSTextEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSTextEventPrototypeTable, this, propertyName, slot);
}

bool JSTextEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTextEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSTextEvent::s_info = { "TextEvent", &JSUIEvent::s_info, &JSTextEventTable, 0 };

JSTextEvent::JSTextEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<TextEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
}

JSObject* JSTextEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSTextEventPrototype(JSTextEventPrototype::createStructure(JSUIEventPrototype::self(exec, globalObject)));
}

bool JSTextEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextEvent, Base>(exec, &JSTextEventTable, this, propertyName, slot);
}

bool JSTextEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTextEvent, Base>(exec, &JSTextEventTable, this, propertyName, descriptor);
}

JSValue jsTextEventData(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSTextEvent* castedThis = static_cast<JSTextEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    TextEvent* imp = static_cast<TextEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->data());
    return result;
}

JSValue jsTextEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSTextEvent* domObject = static_cast<JSTextEvent*>(asObject(slot.slotBase()));
    return JSTextEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSTextEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsTextEventPrototypeFunctionInitTextEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSTextEvent::s_info))
        return throwError(exec, TypeError);
    JSTextEvent* castedThisObj = static_cast<JSTextEvent*>(asObject(thisValue));
    TextEvent* imp = static_cast<TextEvent*>(castedThisObj->impl());
    const UString& typeArg = args.at(0).toString(exec);
    bool canBubbleArg = args.at(1).toBoolean(exec);
    bool cancelableArg = args.at(2).toBoolean(exec);
    DOMWindow* viewArg = toDOMWindow(args.at(3));
    const UString& dataArg = args.at(4).toString(exec);

    imp->initTextEvent(typeArg, canBubbleArg, cancelableArg, viewArg, dataArg);
    return jsUndefined();
}


}
