/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(3D_CANVAS)

#include "JSWebGLArrayBuffer.h"

#include "WebGLArrayBuffer.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebGLArrayBuffer);

/* Hash table */

static const HashTableValue JSWebGLArrayBufferTableValues[2] =
{
    { "byteLength", DontDelete|ReadOnly, (intptr_t)jsWebGLArrayBufferByteLength, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWebGLArrayBufferTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebGLArrayBufferTableValues, 0 };
#else
    { 2, 1, JSWebGLArrayBufferTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSWebGLArrayBufferPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWebGLArrayBufferPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebGLArrayBufferPrototypeTableValues, 0 };
#else
    { 1, 0, JSWebGLArrayBufferPrototypeTableValues, 0 };
#endif

const ClassInfo JSWebGLArrayBufferPrototype::s_info = { "WebGLArrayBufferPrototype", 0, &JSWebGLArrayBufferPrototypeTable, 0 };

JSObject* JSWebGLArrayBufferPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLArrayBuffer>(exec, globalObject);
}

const ClassInfo JSWebGLArrayBuffer::s_info = { "WebGLArrayBuffer", 0, &JSWebGLArrayBufferTable, 0 };

JSWebGLArrayBuffer::JSWebGLArrayBuffer(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLArrayBuffer> impl)
    : DOMObjectWithGlobalPointer(structure, globalObject)
    , m_impl(impl)
{
}

JSWebGLArrayBuffer::~JSWebGLArrayBuffer()
{
    forgetDOMObject(this, impl());
}

JSObject* JSWebGLArrayBuffer::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWebGLArrayBufferPrototype(JSWebGLArrayBufferPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSWebGLArrayBuffer::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLArrayBuffer, Base>(exec, &JSWebGLArrayBufferTable, this, propertyName, slot);
}

bool JSWebGLArrayBuffer::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLArrayBuffer, Base>(exec, &JSWebGLArrayBufferTable, this, propertyName, descriptor);
}

JSValue jsWebGLArrayBufferByteLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWebGLArrayBuffer* castedThis = static_cast<JSWebGLArrayBuffer*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WebGLArrayBuffer* imp = static_cast<WebGLArrayBuffer*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->byteLength());
    return result;
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLArrayBuffer* object)
{
    return getDOMObjectWrapper<JSWebGLArrayBuffer>(exec, globalObject, object);
}
WebGLArrayBuffer* toWebGLArrayBuffer(JSC::JSValue value)
{
    return value.inherits(&JSWebGLArrayBuffer::s_info) ? static_cast<JSWebGLArrayBuffer*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(3D_CANVAS)
