/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSWebGLContextAttributes_h
#define JSWebGLContextAttributes_h

#if ENABLE(3D_CANVAS)

#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class WebGLContextAttributes;

class JSWebGLContextAttributes : public DOMObjectWithGlobalPointer {
    typedef DOMObjectWithGlobalPointer Base;
public:
    JSWebGLContextAttributes(NonNullPassRefPtr<JSC::Structure>, JSDOMGlobalObject*, PassRefPtr<WebGLContextAttributes>);
    virtual ~JSWebGLContextAttributes();
    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    virtual void put(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::JSValue, JSC::PutPropertySlot&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }

    WebGLContextAttributes* impl() const { return m_impl.get(); }

private:
    RefPtr<WebGLContextAttributes> m_impl;
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, WebGLContextAttributes*);
WebGLContextAttributes* toWebGLContextAttributes(JSC::JSValue);

class JSWebGLContextAttributesPrototype : public JSC::JSObject {
    typedef JSC::JSObject Base;
public:
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
    JSWebGLContextAttributesPrototype(NonNullPassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
protected:
    static const unsigned StructureFlags = Base::StructureFlags;
};

// Attributes

JSC::JSValue jsWebGLContextAttributesAlpha(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSWebGLContextAttributesAlpha(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWebGLContextAttributesDepth(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSWebGLContextAttributesDepth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWebGLContextAttributesStencil(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSWebGLContextAttributesStencil(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWebGLContextAttributesAntialias(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSWebGLContextAttributesAntialias(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsWebGLContextAttributesPremultipliedAlpha(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
void setJSWebGLContextAttributesPremultipliedAlpha(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);

} // namespace WebCore

#endif // ENABLE(3D_CANVAS)

#endif
