/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSWebGLRenderingContext_h
#define JSWebGLRenderingContext_h

#if ENABLE(3D_CANVAS)

#include "JSCanvasRenderingContext.h"

namespace WebCore {

class WebGLRenderingContext;

class JSWebGLRenderingContext : public JSCanvasRenderingContext {
    typedef JSCanvasRenderingContext Base;
public:
    JSWebGLRenderingContext(NonNullPassRefPtr<JSC::Structure>, JSDOMGlobalObject*, PassRefPtr<WebGLRenderingContext>);
    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;

    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);

    // Custom functions
    JSC::JSValue bufferData(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue bufferSubData(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue getBufferParameter(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue getFramebufferAttachmentParameter(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue getParameter(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue getProgramParameter(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue getRenderbufferParameter(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue getShaderParameter(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue getTexParameter(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue getUniform(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue getVertexAttrib(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue texImage2D(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue texSubImage2D(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform1fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform1iv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform2fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform2iv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform3fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform3iv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform4fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniform4iv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniformMatrix2fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniformMatrix3fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue uniformMatrix4fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue vertexAttrib1fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue vertexAttrib2fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue vertexAttrib3fv(JSC::ExecState*, const JSC::ArgList&);
    JSC::JSValue vertexAttrib4fv(JSC::ExecState*, const JSC::ArgList&);
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};


class JSWebGLRenderingContextPrototype : public JSC::JSObject {
    typedef JSC::JSObject Base;
public:
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
    {
        return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount);
    }
    JSWebGLRenderingContextPrototype(NonNullPassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionSizeInBytes(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionActiveTexture(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionAttachShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBindAttribLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBindBuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBindFramebuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBindRenderbuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBindTexture(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBlendColor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBlendEquation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBlendEquationSeparate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBlendFunc(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBlendFuncSeparate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBufferData(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionBufferSubData(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCheckFramebufferStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionClear(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionClearColor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionClearDepth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionClearStencil(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionColorMask(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCompileShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCopyTexImage2D(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCopyTexSubImage2D(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateBuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateFramebuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateRenderbuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCreateTexture(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionCullFace(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteBuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteFramebuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteRenderbuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDeleteTexture(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDepthFunc(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDepthMask(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDepthRange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDetachShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDisable(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDisableVertexAttribArray(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDrawArrays(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionDrawElements(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionEnable(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionEnableVertexAttribArray(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionFinish(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionFlush(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionFramebufferRenderbuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionFramebufferTexture2D(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionFrontFace(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGenerateMipmap(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetActiveAttrib(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetActiveUniform(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetAttribLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetBufferParameter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetContextAttributes(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetError(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetFramebufferAttachmentParameter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetParameter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetProgramParameter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetProgramInfoLog(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetRenderbufferParameter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetShaderParameter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetShaderInfoLog(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetShaderSource(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetString(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetTexParameter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetUniform(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetUniformLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetVertexAttrib(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionGetVertexAttribOffset(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionHint(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsBuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsEnabled(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsFramebuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsRenderbuffer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsShader(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionIsTexture(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionLineWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionLinkProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionPixelStorei(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionPolygonOffset(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionReadPixels(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionReleaseShaderCompiler(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionRenderbufferStorage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionSampleCoverage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionScissor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionShaderSource(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilFunc(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilFuncSeparate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilMask(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilMaskSeparate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilOp(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionStencilOpSeparate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionTexParameterf(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionTexParameteri(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionTexImage2D(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionTexSubImage2D(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform1f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform1fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform1i(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform1iv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform2f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform2fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform2i(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform2iv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform3f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform3fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform3i(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform3iv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform4f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform4fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform4i(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniform4iv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniformMatrix2fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniformMatrix3fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUniformMatrix4fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionUseProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionValidateProgram(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib1f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib1fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib2f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib2fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib3f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib3fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib4f(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttrib4fv(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionVertexAttribPointer(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
JSC::JSValue JSC_HOST_CALL jsWebGLRenderingContextPrototypeFunctionViewport(JSC::ExecState*, JSC::JSObject*, JSC::JSValue, const JSC::ArgList&);
// Attributes

JSC::JSValue jsWebGLRenderingContextConstructor(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
// Constants

JSC::JSValue jsWebGLRenderingContextDEPTH_BUFFER_BIT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BUFFER_BIT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCOLOR_BUFFER_BIT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFALSE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTRUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextPOINTS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLINES(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLINE_LOOP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLINE_STRIP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTRIANGLES(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTRIANGLE_STRIP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTRIANGLE_FAN(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextZERO(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextONE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSRC_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_SRC_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSRC_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_SRC_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDST_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_DST_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDST_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_DST_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSRC_ALPHA_SATURATE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFUNC_ADD(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBLEND_EQUATION(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBLEND_EQUATION_RGB(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBLEND_EQUATION_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFUNC_SUBTRACT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFUNC_REVERSE_SUBTRACT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBLEND_DST_RGB(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBLEND_SRC_RGB(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBLEND_DST_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBLEND_SRC_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCONSTANT_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_CONSTANT_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCONSTANT_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextONE_MINUS_CONSTANT_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBLEND_COLOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextARRAY_BUFFER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextELEMENT_ARRAY_BUFFER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextARRAY_BUFFER_BINDING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextELEMENT_ARRAY_BUFFER_BINDING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTREAM_DRAW(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTATIC_DRAW(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDYNAMIC_DRAW(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBUFFER_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBUFFER_USAGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCURRENT_VERTEX_ATTRIB(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRONT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBACK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRONT_AND_BACK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_2D(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCULL_FACE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBLEND(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDITHER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_TEST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDEPTH_TEST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSCISSOR_TEST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextPOLYGON_OFFSET_FILL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSAMPLE_ALPHA_TO_COVERAGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSAMPLE_COVERAGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextNO_ERROR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINVALID_ENUM(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINVALID_VALUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINVALID_OPERATION(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextOUT_OF_MEMORY(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCW(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCCW(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLINE_WIDTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextALIASED_POINT_SIZE_RANGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextALIASED_LINE_WIDTH_RANGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCULL_FACE_MODE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRONT_FACE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDEPTH_RANGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDEPTH_WRITEMASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDEPTH_CLEAR_VALUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDEPTH_FUNC(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_CLEAR_VALUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_FUNC(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_FAIL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_PASS_DEPTH_FAIL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_PASS_DEPTH_PASS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_REF(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_VALUE_MASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_WRITEMASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_FUNC(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_FAIL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_PASS_DEPTH_FAIL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_PASS_DEPTH_PASS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_REF(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_VALUE_MASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BACK_WRITEMASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVIEWPORT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSCISSOR_BOX(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCOLOR_CLEAR_VALUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCOLOR_WRITEMASK(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextUNPACK_ALIGNMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextPACK_ALIGNMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMAX_TEXTURE_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMAX_VIEWPORT_DIMS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSUBPIXEL_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRED_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextGREEN_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBLUE_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextALPHA_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDEPTH_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_BITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextPOLYGON_OFFSET_UNITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextPOLYGON_OFFSET_FACTOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_BINDING_2D(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSAMPLE_BUFFERS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSAMPLES(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSAMPLE_COVERAGE_VALUE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSAMPLE_COVERAGE_INVERT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextNUM_COMPRESSED_TEXTURE_FORMATS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCOMPRESSED_TEXTURE_FORMATS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDONT_CARE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFASTEST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextNICEST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextGENERATE_MIPMAP_HINT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBYTE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_BYTE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSHORT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_SHORT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_INT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFLOAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFIXED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDEPTH_COMPONENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRGB(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRGBA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLUMINANCE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLUMINANCE_ALPHA(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_SHORT_4_4_4_4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_SHORT_5_5_5_1(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextUNSIGNED_SHORT_5_6_5(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAGMENT_SHADER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVERTEX_SHADER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMAX_VERTEX_ATTRIBS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMAX_VERTEX_UNIFORM_VECTORS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMAX_VARYING_VECTORS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMAX_COMBINED_TEXTURE_IMAGE_UNITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMAX_VERTEX_TEXTURE_IMAGE_UNITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMAX_TEXTURE_IMAGE_UNITS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMAX_FRAGMENT_UNIFORM_VECTORS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSHADER_TYPE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDELETE_STATUS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLINK_STATUS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVALIDATE_STATUS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextATTACHED_SHADERS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextACTIVE_UNIFORMS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextACTIVE_UNIFORM_MAX_LENGTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextACTIVE_ATTRIBUTES(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextACTIVE_ATTRIBUTE_MAX_LENGTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSHADING_LANGUAGE_VERSION(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCURRENT_PROGRAM(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextNEVER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLESS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextEQUAL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLEQUAL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextGREATER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextNOTEQUAL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextGEQUAL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextALWAYS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextKEEP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextREPLACE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINCR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDECR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINVERT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINCR_WRAP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDECR_WRAP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVENDOR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVERSION(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextEXTENSIONS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextNEAREST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLINEAR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextNEAREST_MIPMAP_NEAREST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLINEAR_MIPMAP_NEAREST(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextNEAREST_MIPMAP_LINEAR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLINEAR_MIPMAP_LINEAR(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_MAG_FILTER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_MIN_FILTER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_WRAP_S(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_WRAP_T(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_BINDING_CUBE_MAP(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_POSITIVE_X(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_NEGATIVE_X(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_POSITIVE_Y(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_NEGATIVE_Y(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_POSITIVE_Z(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE_CUBE_MAP_NEGATIVE_Z(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMAX_CUBE_MAP_TEXTURE_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE0(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE1(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE2(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE3(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE5(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE6(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE7(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE8(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE9(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE10(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE11(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE12(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE13(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE14(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE15(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE16(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE17(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE18(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE19(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE20(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE21(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE22(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE23(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE24(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE25(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE26(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE27(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE28(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE29(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE30(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextTEXTURE31(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextACTIVE_TEXTURE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextREPEAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCLAMP_TO_EDGE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMIRRORED_REPEAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFLOAT_VEC2(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFLOAT_VEC3(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFLOAT_VEC4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINT_VEC2(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINT_VEC3(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINT_VEC4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBOOL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBOOL_VEC2(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBOOL_VEC3(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextBOOL_VEC4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFLOAT_MAT2(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFLOAT_MAT3(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFLOAT_MAT4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSAMPLER_2D(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSAMPLER_CUBE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_ENABLED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_STRIDE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_TYPE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_NORMALIZED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_POINTER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextVERTEX_ATTRIB_ARRAY_BUFFER_BINDING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextIMPLEMENTATION_COLOR_READ_TYPE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextIMPLEMENTATION_COLOR_READ_FORMAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCOMPILE_STATUS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINFO_LOG_LENGTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSHADER_SOURCE_LENGTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSHADER_COMPILER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSHADER_BINARY_FORMATS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextNUM_SHADER_BINARY_FORMATS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLOW_FLOAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMEDIUM_FLOAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextHIGH_FLOAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextLOW_INT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMEDIUM_INT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextHIGH_INT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRGBA4(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRGB5_A1(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRGB565(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDEPTH_COMPONENT16(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_INDEX(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_INDEX8(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_WIDTH(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_HEIGHT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_INTERNAL_FORMAT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_RED_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_GREEN_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_BLUE_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_ALPHA_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_DEPTH_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_STENCIL_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_ATTACHMENT_OBJECT_TYPE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_ATTACHMENT_OBJECT_NAME(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextCOLOR_ATTACHMENT0(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextDEPTH_ATTACHMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextSTENCIL_ATTACHMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextNONE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_COMPLETE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_INCOMPLETE_ATTACHMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_INCOMPLETE_DIMENSIONS(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_UNSUPPORTED(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextFRAMEBUFFER_BINDING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextRENDERBUFFER_BINDING(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextMAX_RENDERBUFFER_SIZE(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);
JSC::JSValue jsWebGLRenderingContextINVALID_FRAMEBUFFER_OPERATION(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);

} // namespace WebCore

#endif // ENABLE(3D_CANVAS)

#endif
