/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(3D_CANVAS)

#include "JSWebGLShortArray.h"

#include "WebGLShortArray.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebGLShortArray);

/* Hash table for prototype */

static const HashTableValue JSWebGLShortArrayPrototypeTableValues[3] =
{
    { "get", DontDelete|Function, (intptr_t)jsWebGLShortArrayPrototypeFunctionGet, (intptr_t)1 },
    { "set", DontDelete|Function, (intptr_t)jsWebGLShortArrayPrototypeFunctionSet, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWebGLShortArrayPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSWebGLShortArrayPrototypeTableValues, 0 };
#else
    { 4, 3, JSWebGLShortArrayPrototypeTableValues, 0 };
#endif

const ClassInfo JSWebGLShortArrayPrototype::s_info = { "WebGLShortArrayPrototype", 0, &JSWebGLShortArrayPrototypeTable, 0 };

JSObject* JSWebGLShortArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLShortArray>(exec, globalObject);
}

bool JSWebGLShortArrayPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSWebGLShortArrayPrototypeTable, this, propertyName, slot);
}

bool JSWebGLShortArrayPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWebGLShortArrayPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSWebGLShortArray::s_info = { "WebGLShortArray", &JSWebGLArray::s_info, 0, 0 };

JSWebGLShortArray::JSWebGLShortArray(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLShortArray> impl)
    : JSWebGLArray(structure, globalObject, impl)
{
}

JSObject* JSWebGLShortArray::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWebGLShortArrayPrototype(JSWebGLShortArrayPrototype::createStructure(JSWebGLArrayPrototype::self(exec, globalObject)));
}

bool JSWebGLShortArray::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<WebGLShortArray*>(impl())->length()) {
        slot.setValue(getByIndex(exec, index));
        return true;
    }
    return Base::getOwnPropertySlot(exec, propertyName, slot);
}

bool JSWebGLShortArray::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<WebGLShortArray*>(impl())->length()) {
        descriptor.setDescriptor(getByIndex(exec, index), DontDelete);
        return true;
    }
    return Base::getOwnPropertyDescriptor(exec, propertyName, descriptor);
}

bool JSWebGLShortArray::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<WebGLShortArray*>(impl())->length()) {
        slot.setValue(getByIndex(exec, propertyName));
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

void JSWebGLShortArray::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    Base::put(exec, propertyName, value, slot);
}

void JSWebGLShortArray::put(ExecState* exec, unsigned propertyName, JSValue value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void JSWebGLShortArray::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    for (unsigned i = 0; i < static_cast<WebGLShortArray*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSC_HOST_CALL jsWebGLShortArrayPrototypeFunctionGet(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSWebGLShortArray::s_info))
        return throwError(exec, TypeError);
    JSWebGLShortArray* castedThisObj = static_cast<JSWebGLShortArray*>(asObject(thisValue));
    WebGLShortArray* imp = static_cast<WebGLShortArray*>(castedThisObj->impl());
    unsigned index = args.at(0).toInt32(exec);


    JSC::JSValue result = jsNumber(exec, imp->get(index));
    return result;
}

JSValue JSC_HOST_CALL jsWebGLShortArrayPrototypeFunctionSet(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSWebGLShortArray::s_info))
        return throwError(exec, TypeError);
    JSWebGLShortArray* castedThisObj = static_cast<JSWebGLShortArray*>(asObject(thisValue));
    return castedThisObj->set(exec, args);
}


JSValue JSWebGLShortArray::getByIndex(ExecState* exec, unsigned index)
{
    return jsNumber(exec, static_cast<WebGLShortArray*>(impl())->item(index));
}
WebGLShortArray* toWebGLShortArray(JSC::JSValue value)
{
    return value.inherits(&JSWebGLShortArray::s_info) ? static_cast<JSWebGLShortArray*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(3D_CANVAS)
