/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWheelEvent.h"

#include "WheelEvent.h"
#include <runtime/JSNumberCell.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWheelEvent);

/* Hash table */

static const HashTableValue JSWheelEventTableValues[17] =
{
    { "screenX", DontDelete|ReadOnly, (intptr_t)jsWheelEventScreenX, (intptr_t)0 },
    { "screenY", DontDelete|ReadOnly, (intptr_t)jsWheelEventScreenY, (intptr_t)0 },
    { "clientX", DontDelete|ReadOnly, (intptr_t)jsWheelEventClientX, (intptr_t)0 },
    { "clientY", DontDelete|ReadOnly, (intptr_t)jsWheelEventClientY, (intptr_t)0 },
    { "ctrlKey", DontDelete|ReadOnly, (intptr_t)jsWheelEventCtrlKey, (intptr_t)0 },
    { "shiftKey", DontDelete|ReadOnly, (intptr_t)jsWheelEventShiftKey, (intptr_t)0 },
    { "altKey", DontDelete|ReadOnly, (intptr_t)jsWheelEventAltKey, (intptr_t)0 },
    { "metaKey", DontDelete|ReadOnly, (intptr_t)jsWheelEventMetaKey, (intptr_t)0 },
    { "wheelDelta", DontDelete|ReadOnly, (intptr_t)jsWheelEventWheelDelta, (intptr_t)0 },
    { "wheelDeltaX", DontDelete|ReadOnly, (intptr_t)jsWheelEventWheelDeltaX, (intptr_t)0 },
    { "wheelDeltaY", DontDelete|ReadOnly, (intptr_t)jsWheelEventWheelDeltaY, (intptr_t)0 },
    { "offsetX", DontDelete|ReadOnly, (intptr_t)jsWheelEventOffsetX, (intptr_t)0 },
    { "offsetY", DontDelete|ReadOnly, (intptr_t)jsWheelEventOffsetY, (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)jsWheelEventX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsWheelEventY, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsWheelEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWheelEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSWheelEventTableValues, 0 };
#else
    { 33, 31, JSWheelEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSWheelEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWheelEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWheelEventConstructorTableValues, 0 };
#else
    { 1, 0, JSWheelEventConstructorTableValues, 0 };
#endif

class JSWheelEventConstructor : public DOMConstructorObject {
public:
    JSWheelEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSWheelEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSWheelEventPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSWheelEventConstructor::s_info = { "WheelEventConstructor", 0, &JSWheelEventConstructorTable, 0 };

bool JSWheelEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWheelEventConstructor, DOMObject>(exec, &JSWheelEventConstructorTable, this, propertyName, slot);
}

bool JSWheelEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWheelEventConstructor, DOMObject>(exec, &JSWheelEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWheelEventPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWheelEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWheelEventPrototypeTableValues, 0 };
#else
    { 1, 0, JSWheelEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSWheelEventPrototype::s_info = { "WheelEventPrototype", 0, &JSWheelEventPrototypeTable, 0 };

JSObject* JSWheelEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWheelEvent>(exec, globalObject);
}

const ClassInfo JSWheelEvent::s_info = { "WheelEvent", &JSUIEvent::s_info, &JSWheelEventTable, 0 };

JSWheelEvent::JSWheelEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<WheelEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
}

JSObject* JSWheelEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWheelEventPrototype(JSWheelEventPrototype::createStructure(JSUIEventPrototype::self(exec, globalObject)));
}

bool JSWheelEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWheelEvent, Base>(exec, &JSWheelEventTable, this, propertyName, slot);
}

bool JSWheelEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWheelEvent, Base>(exec, &JSWheelEventTable, this, propertyName, descriptor);
}

JSValue jsWheelEventScreenX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->screenX());
    return result;
}

JSValue jsWheelEventScreenY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->screenY());
    return result;
}

JSValue jsWheelEventClientX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->clientX());
    return result;
}

JSValue jsWheelEventClientY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->clientY());
    return result;
}

JSValue jsWheelEventCtrlKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsBoolean(imp->ctrlKey());
    return result;
}

JSValue jsWheelEventShiftKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsBoolean(imp->shiftKey());
    return result;
}

JSValue jsWheelEventAltKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsBoolean(imp->altKey());
    return result;
}

JSValue jsWheelEventMetaKey(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsBoolean(imp->metaKey());
    return result;
}

JSValue jsWheelEventWheelDelta(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->wheelDelta());
    return result;
}

JSValue jsWheelEventWheelDeltaX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->wheelDeltaX());
    return result;
}

JSValue jsWheelEventWheelDeltaY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->wheelDeltaY());
    return result;
}

JSValue jsWheelEventOffsetX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->offsetX());
    return result;
}

JSValue jsWheelEventOffsetY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->offsetY());
    return result;
}

JSValue jsWheelEventX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->x());
    return result;
}

JSValue jsWheelEventY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* castedThis = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WheelEvent* imp = static_cast<WheelEvent*>(castedThis->impl());
    JSValue result = jsNumber(exec, imp->y());
    return result;
}

JSValue jsWheelEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWheelEvent* domObject = static_cast<JSWheelEvent*>(asObject(slot.slotBase()));
    return JSWheelEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSWheelEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWheelEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
