/*
** Copyright 2002/03, Thomas Kurschel. All rights reserved.
** Distributed under the terms of the OpenBeOS License.
*/

/*
	Part of Open IDE bus manager

	OP-Codes of IDE commands
*/

#ifndef __IDE_CMDS_H__
#define __IDE_CMDS_H__


#define IDE_CMD_WRITE_DMA 0xca
#define IDE_CMD_WRITE_DMA_QUEUED 0xcc
#define IDE_CMD_WRITE_MULTIPLE 0xc5
#define IDE_CMD_WRITE_SECTORS 0x30

#define IDE_CMD_READ_DMA 0xc8
#define IDE_CMD_READ_DMA_QUEUED 0xc7
#define IDE_CMD_READ_MULTIPLE 0xc4
#define IDE_CMD_READ_SECTORS 0x20

#define IDE_CMD_WRITE_DMA_EXT 0x35
#define IDE_CMD_WRITE_DMA_QUEUED_EXT 0x36
#define IDE_CMD_WRITE_MULTIPLE_EXT 0x39
#define IDE_CMD_WRITE_SECTORS_EXT 0x34

#define IDE_CMD_READ_DMA_EXT 0x25
#define IDE_CMD_READ_DMA_QUEUED_EXT 0x26
#define IDE_CMD_READ_MULTIPLE_EXT 0x29
#define IDE_CMD_READ_SECTORS_EXT 0x24

#define IDE_CMD_PACKET 0xa0
#define IDE_CMD_DEVICE_RESET 0x08

#define IDE_CMD_SERVICE 0xa2
#define IDE_CMD_NOP 0

#define IDE_CMD_NOP_NOP 0
#define IDE_CMD_NOP_NOP_AUTOPOLL 1


#define IDE_CMD_GET_MEDIA_STATUS 0xda

#define IDE_CMD_FLUSH_CACHE 0xe7
#define IDE_CMD_FLUSH_CACHE_EXT 0xea

#define IDE_CMD_MEDIA_EJECT 0xed

#define IDE_CMD_IDENTIFY_PACKET_DEVICE 0xa1
#define IDE_CMD_IDENTIFY_DEVICE 0xec

#define IDE_CMD_SET_FEATURES 0xef
#define IDE_CMD_SET_FEATURES_ENABLE_REL_INT 0x5d
#define IDE_CMD_SET_FEATURES_ENABLE_SERV_INT 0x5e
#define IDE_CMD_SET_FEATURES_DISABLE_REL_INT 0xdd
#define IDE_CMD_SET_FEATURES_DISABLE_SERV_INT 0xde
#define IDE_CMD_SET_FEATURES_ENABLE_MSN 0x95


#endif
