/*
 * Copyright 2007-2008, Haiku, Inc. All Rights Reserved.
 * Distributed under the terms of the MIT License.
 *
 * Authors:
 *		Ithamar Adema, ithamar AT unet DOT nl
 *		Axel Dörfler, axeld@pinc-software.de
 */
#ifndef HDA_CODEC_H
#define HDA_CODEC_H

enum hda_widget_type {
	WT_AUDIO_OUTPUT		= 0,
	WT_AUDIO_INPUT		= 1,
	WT_AUDIO_MIXER		= 2,
	WT_AUDIO_SELECTOR	= 3,
	WT_PIN_COMPLEX		= 4,
	WT_POWER			= 5,
	WT_VOLUME_KNOB		= 6,
	WT_BEEP_GENERATOR	= 7,
	WT_VENDOR_DEFINED	= 15
};

enum pin_connectivity_type {
	PIN_CONN_JACK,
	PIN_CONN_NONE,
	PIN_CONN_FIXED,
	PIN_CONN_BOTH
};

enum pin_dev_type {
	PIN_DEV_LINE_OUT = 0,
	PIN_DEV_SPEAKER,
	PIN_DEV_HEAD_PHONE_OUT,
	PIN_DEV_CD,
	PIN_DEV_SPDIF_OUT,
	PIN_DEV_DIGITAL_OTHER_OUT,
	PIN_DEV_MODEM_LINE_SIDE,
	PIN_DEV_MODEM_HAND_SIDE,
	PIN_DEV_LINE_IN,
	PIN_DEV_AUX,
	PIN_DEV_MIC_IN,
	PIN_DEV_TELEPHONY,
	PIN_DEV_SPDIF_IN,
	PIN_DEV_DIGITAL_OTHER_IN,
	PIN_DEV_RESERVED,
	PIN_DEV_OTHER
};


/* Verb Helper Macro */
#define MAKE_VERB(cad, nid, vid, payload) \
	(((cad) << 28) | ((nid) << 20) | (vid) | (payload))

/* Verb IDs */
#define VID_GET_PARAMETER					0xf0000
#define VID_GET_CONNECTION_SELECT			0xf0100
#define VID_SET_CONNECTION_SELECT			0x70100
#define VID_GET_CONNECTION_LIST_ENTRY		0xf0200
#define VID_GET_PROCESSING_STATE			0xf0300
#define VID_SET_PROCESSING_STATE			0x70300
#define VID_GET_COEFFICIENT_INDEX			0xd0000
#define VID_SET_COEFFICIENT_INDEX			0x50000
#define VID_GET_PROCESSING_COEFFICIENT		0xc0000
#define VID_SET_PROCESSING_COEFFICIENT		0x40000
#define VID_GET_AMPLIFIER_GAIN_MUTE			0xb0000
#define VID_SET_AMPLIFIER_GAIN_MUTE			0x30000
#define VID_GET_CONVERTER_FORMAT			0xa0000
#define VID_SET_CONVERTER_FORMAT			0x20000
#define VID_GET_CONVERTER_STREAM_CHANNEL	0xf0600
#define VID_SET_CONVERTER_STREAM_CHANNEL	0x70600
#define VID_GET_DIGITAL_CONVERTER_CONTROL	0xf0d00
#define VID_SET_DIGITAL_CONVERTER_CONTROL1	0x70d00
#define VID_SET_DIGITAL_CONVERTER_CONTROL2	0x70e00
#define VID_GET_POWER_STATE					0xf0500
#define VID_SET_POWER_STATE					0x70500
#define VID_GET_SDI_SELECT					0xf0400
#define VID_SET_SDI_SELECT					0x70400
#define VID_GET_PIN_WIDGET_CONTROL			0xf0700
#define VID_SET_PIN_WIDGET_CONTROL			0x70700
#define VID_GET_UNSOLRESP		0xF0800
#define VID_SET_UNSOLRESP		0x70800
#define VID_GET_PINSENSE		0xF0900
#define VID_SET_PINSENSE		0x70900
#define VID_GET_EAPDBTL_EN		0xF0C00
#define VID_SET_EAPDBTL_EN		0x70C00
#define VID_GET_VOLUME_KNOB_CONTROL	0xF0F00
#define VID_SET_VOLUME_KNOB_CONTROL	0x70F00
#define VID_GET_GPIDATA			0xF1000
#define VID_SET_GPIDATA			0x71000
#define VID_GET_GPIWAKE_EN		0xF1100
#define VID_SET_GPIWAKE_EN		0x71100
#define VID_GET_GPIUNSOL		0xF1200
#define VID_SET_GPIUNSOL		0x71200
#define VID_GET_GPISTICKY		0xF1300
#define VID_SET_GPISTICKY		0x71300
#define VID_GET_GPO_DATA		0xF1400
#define VID_SET_GPO_DATA		0x71400
#define VID_GET_GPIO_DATA		0xF1500
#define VID_SET_GPIO_DATA		0x71500
#define VID_GET_GPIO_EN			0xF1600
#define VID_SET_GPIO_EN			0x71600
#define VID_GET_GPIO_DIR		0xF1700
#define VID_SET_GPIO_DIR		0x71700
#define VID_GET_GPIOWAKE_EN		0xF1800
#define VID_SET_GPIOWAKE_EN		0x71800
#define VID_GET_GPIOUNSOL_EN	0xF1900
#define VID_SET_GPIOUNSOL_EN	0x71900
#define VID_GET_GPIOSTICKY		0xF1A00
#define VID_SET_GPIOSTICKY		0x71A00
#define VID_GET_BEEPGEN			0xF0A00
#define VID_SET_BEEPGEN			0x70A00
#define VID_GET_VOLUME_KNOB					0xf0f00
#define VID_SET_VOLUME_KNOB					0x70f00
#define VID_GET_SUBSYSTEMID		0xF2000
#define VID_SET_SUBSYSTEMID1	0x72000
#define VID_SET_SUBSYSTEMID2	0x72100
#define VID_SET_SUBSYSTEMID3	0x72200
#define VID_SET_SUBSYSTEMID4	0x72300
#define VID_GET_CONFIGURATION_DEFAULT		0xf1c00
#define VID_SET_CONFIGURATION_DEFAULT1		0x71c00
#define VID_SET_CONFIGURATION_DEFAULT2		0x71d00
#define VID_SET_CONFIGURATION_DEFAULT3		0x71e00
#define VID_SET_CONFIGURATION_DEFAULT4		0x71f00
#define VID_GET_STRIPE_CONTROL				0xf2400
#define VID_SET_STRIPE_CONTROL				0x72000
#define VID_FUNCTION_RESET					0x7ff00

/* Parameter IDs */
#define PID_VENDOR_ID					0x00
#define PID_REVISION_ID					0x02
#define PID_SUB_NODE_COUNT				0x04
#define PID_FUNCTION_GROUP_TYPE			0x05
#define PID_AUDIO_GROUP_CAP				0x08
#define PID_AUDIO_WIDGET_CAP			0x09
#define PID_PCM_SUPPORT					0x0a
#define PID_STREAM_SUPPORT				0x0b
#define PID_PIN_CAP						0x0c
#define PID_INPUT_AMPLIFIER_CAP			0x0d
#define PID_CONNECTION_LIST_LENGTH		0x0e
#define PID_POWERSTATE_SUPPORT			0x0f
#define PID_PROCESSING_CAP				0x10
#define PID_GPIO_COUNT					0x11
#define PID_OUTPUT_AMPLIFIER_CAP		0x12
#define PID_VOLUME_KNOB_CAP				0x13

/* Subordinate node count */
#define SUB_NODE_COUNT_TOTAL_MASK		0x000000ff
#define SUB_NODE_COUNT_TOTAL_SHIFT		0
#define SUB_NODE_COUNT_START_MASK		0x00ff0000
#define SUB_NODE_COUNT_START_SHIFT		16

#define SUB_NODE_COUNT_TOTAL(c)	((c & SUB_NODE_COUNT_TOTAL_MASK) \
					>> SUB_NODE_COUNT_TOTAL_SHIFT)
#define SUB_NODE_COUNT_START(c)	((c & SUB_NODE_COUNT_START_MASK) \
					>> SUB_NODE_COUNT_START_SHIFT)

/* Function group type */
#define FUNCTION_GROUP_NODETYPE_MASK		0x000000ff
#define FUNCTION_GROUP_UNSOLCAPABLE_MASK	0x00000100

#define FUNCTION_GROUP_NODETYPE_AUDIO		0x00000001
#define FUNCTION_GROUP_NODETYPE_MODEM		0x00000002

/* Audio Function group capabilities */
#define AUDIO_GROUP_CAP_OUTPUT_DELAY_MASK	0x0000000f
#define AUDIO_GROUP_CAP_OUTPUT_DELAY_SHIFT	0
#define AUDIO_GROUP_CAP_INPUT_DELAY_MASK	0x00000f00
#define AUDIO_GROUP_CAP_INPUT_DELAY_SHIFT	8
#define AUDIO_GROUP_CAP_BEEPGEN_MASK		0x00010000
#define AUDIO_GROUP_CAP_BEEPGEN_SHIFT		16

#define AUDIO_GROUP_CAP_OUTPUT_DELAY(c)	((c & AUDIO_GROUP_CAP_OUTPUT_DELAY_MASK) \
					>> AUDIO_GROUP_CAP_OUTPUT_DELAY_SHIFT)
#define AUDIO_GROUP_CAP_INPUT_DELAY(c)	((c & AUDIO_GROUP_CAP_INPUT_DELAY_MASK) \
					>> AUDIO_GROUP_CAP_INPUT_DELAY_SHIFT)
#define AUDIO_GROUP_CAP_BEEPGEN(c)	((c & AUDIO_GROUP_CAP_BEEPGEN_MASK) \
					>> AUDIO_GROUP_CAP_BEEPGEN_SHIFT)


/* Audio widget capabilities */
#define AUDIO_CAP_DELAY_MASK			0x000f0000
#define AUDIO_CAP_DELAY_SHIFT			16
#define AUDIO_CAP_TYPE_MASK				0x00f00000
#define AUDIO_CAP_TYPE_SHIFT			20

#define AUDIO_CAP_STEREO				(1L << 0)
#define AUDIO_CAP_INPUT_AMPLIFIER		(1L << 1)
#define AUDIO_CAP_OUTPUT_AMPLIFIER		(1L << 2)
#define AUDIO_CAP_AMPLIFIER_OVERRIDE	(1L << 3)
#define AUDIO_CAP_FORMAT_OVERRIDE		(1L << 4)
#define AUDIO_CAP_STRIPE				(1L << 5)
#define AUDIO_CAP_PROCESSING_CONTROLS	(1L << 6)
#define AUDIO_CAP_UNSOLICITED_RESPONSES	(1L << 7)
#define AUDIO_CAP_CONNECTION_LIST		(1L << 8)
#define AUDIO_CAP_DIGITAL				(1L << 9)
#define AUDIO_CAP_POWER_CONTROL			(1L << 10)
#define AUDIO_CAP_LEFT_RIGHT_SWAP		(1L << 11)

/* Amplifier capabilities */
#define AMP_CAP_MUTE					0xf0000000
#define AMP_CAP_STEP_SIZE_MASK			0x007f0000
#define AMP_CAP_STEP_SIZE_SHIFT			16
#define AMP_CAP_NUM_STEPS_MASK			0x00007f00
#define AMP_CAP_NUM_STEPS_SHIFT			8
#define AMP_CAP_OFFSET_MASK				0x0000007f

#define AMP_CAP_STEP_SIZE(c)	((((c & AMP_CAP_STEP_SIZE_MASK) \
					>> AMP_CAP_STEP_SIZE_SHIFT) + 1) / 4.0)
#define AMP_CAP_NUM_STEPS(c)	((c & AMP_CAP_NUM_STEPS_MASK) \
					>> AMP_CAP_NUM_STEPS_SHIFT)
#define AMP_CAP_OFFSET(c)	(c & AMP_CAP_OFFSET_MASK)

/* Pin capabilities */
#define PIN_CAP_IMP_SENSE				(1L << 0)
#define PIN_CAP_TRIGGER_REQ				(1L << 1)
#define PIN_CAP_PRES_DETECT				(1L << 2)
#define PIN_CAP_HP_DRIVE				(1L << 3)
#define PIN_CAP_OUTPUT					(1L << 4)
#define PIN_CAP_INPUT					(1L << 5)
#define PIN_CAP_BALANCE					(1L << 6)
#define PIN_CAP_VREF_CTRL_HIZ				(1L << 8)
#define PIN_CAP_VREF_CTRL_50				(1L << 9)
#define PIN_CAP_VREF_CTRL_GROUND				(1L << 10)
#define PIN_CAP_VREF_CTRL_80				(1L << 12)
#define PIN_CAP_VREF_CTRL_100				(1L << 13)
#define PIN_CAP_EAPD_CAP				(1L << 16)

#define PIN_CAP_IS_PRES_DETECT_CAP(c)	((c & PIN_CAP_PRES_DETECT) != 0)
#define PIN_CAP_IS_OUTPUT(c)	((c & PIN_CAP_OUTPUT) != 0)
#define PIN_CAP_IS_INPUT(c)	((c & PIN_CAP_INPUT) != 0)
#define PIN_CAP_IS_VREF_CTRL_50_CAP(c)	((c & PIN_CAP_VREF_CTRL_50) != 0)
#define PIN_CAP_IS_VREF_CTRL_80_CAP(c)	((c & PIN_CAP_VREF_CTRL_80) != 0)
#define PIN_CAP_IS_VREF_CTRL_100_CAP(c)	((c & PIN_CAP_VREF_CTRL_100) != 0)
#define PIN_CAP_IS_EAPD_CAP(c)	((c & PIN_CAP_EAPD_CAP) != 0)

/* PCM support */
#define PCM_8_BIT						(1L << 16)
#define PCM_16_BIT						(1L << 17)
#define PCM_20_BIT						(1L << 18)
#define PCM_24_BIT						(1L << 19)
#define PCM_32_BIT						(1L << 20)

/* stream support */
#define STREAM_AC3						0x00000004
#define STREAM_FLOAT					0x00000002
#define STREAM_PCM						0x00000001

/* Amplifier Gain/Mute */
#define AMP_GET_OUTPUT					(1L << 15)
#define AMP_GET_INPUT					(0L << 15)
#define AMP_GET_LEFT_CHANNEL			(1L << 13)
#define AMP_GET_RIGHT_CHANNEL			(0L << 13)
#define AMP_GET_INPUT_INDEX_MASK		0x0000000f
#define AMP_GET_INPUT_INDEX_SHIFT		0

#define AMP_GET_INPUT_INDEX(x)	((x << AMP_GET_INPUT_INDEX_SHIFT) & AMP_GET_INPUT_INDEX_MASK)

#define AMP_SET_OUTPUT					(1L << 15)
#define AMP_SET_INPUT					(1L << 14)
#define AMP_SET_LEFT_CHANNEL			(1L << 13)
#define AMP_SET_RIGHT_CHANNEL			(1L << 12)
#define AMP_SET_INPUT_INDEX_MASK		0x00000f00
#define AMP_SET_INPUT_INDEX_SHIFT		8

#define AMP_SET_INPUT_INDEX(x)	((x << AMP_SET_INPUT_INDEX_SHIFT) & AMP_SET_INPUT_INDEX_MASK)

#define AMP_GAIN_MASK					0x0000007f
#define AMP_MUTE						(1L << 7)

/* Pin Widget Control */
#define PIN_ENABLE_HEAD_PHONE			(1L << 7)
#define PIN_ENABLE_OUTPUT				(1L << 6)
#define PIN_ENABLE_INPUT				(1L << 5)
#define PIN_ENABLE_VREF_HIZ				0
#define PIN_ENABLE_VREF_50				1
#define PIN_ENABLE_VREF_GROUND			2
#define PIN_ENABLE_VREF_80				4
#define PIN_ENABLE_VREF_100				5

/* Unsolicited Response */
#define UNSOLRESP_ENABLE				(1L << 7)

/* Pin sense */
#define PIN_SENSE_PRESENCE_DETECT		(1L << 31)

/* Supported power states */
#define POWER_STATE_D0					(1L << 0)
#define POWER_STATE_D1					(1L << 1)
#define POWER_STATE_D2					(1L << 2)
#define POWER_STATE_D3					(1L << 3)

/* Configuration default */
#define CONF_DEFAULT_SEQUENCE_MASK			0x0000000f
#define CONF_DEFAULT_SEQUENCE_SHIFT			0
#define CONF_DEFAULT_ASSOCIATION_MASK			0x000000f0
#define CONF_DEFAULT_ASSOCIATION_SHIFT			4
#define CONF_DEFAULT_MISC_MASK				0x00000f00
#define CONF_DEFAULT_MISC_SHIFT				8
#define CONF_DEFAULT_COLOR_MASK				0x0000f000
#define CONF_DEFAULT_COLOR_SHIFT			12
#define CONF_DEFAULT_CONNTYPE_MASK			0x000f0000
#define CONF_DEFAULT_CONNTYPE_SHIFT			16
#define CONF_DEFAULT_DEVICE_MASK			0x00f00000
#define CONF_DEFAULT_DEVICE_SHIFT			20
#define CONF_DEFAULT_LOCATION_MASK			0x3f000000
#define CONF_DEFAULT_LOCATION_SHIFT			24
#define CONF_DEFAULT_CONNECTIVITY_MASK			0xc0000000
#define CONF_DEFAULT_CONNECTIVITY_SHIFT			30

#define CONF_DEFAULT_SEQUENCE(c) ((c & CONF_DEFAULT_SEQUENCE_MASK) >> CONF_DEFAULT_SEQUENCE_SHIFT)
#define CONF_DEFAULT_ASSOCIATION(c) ((c & CONF_DEFAULT_ASSOCIATION_MASK) >> CONF_DEFAULT_ASSOCIATION_SHIFT)
#define CONF_DEFAULT_MISC(c) ((c & CONF_DEFAULT_MISC_MASK) >> CONF_DEFAULT_MISC_SHIFT)
#define CONF_DEFAULT_COLOR(c) ((c & CONF_DEFAULT_COLOR_MASK) >> CONF_DEFAULT_COLOR_SHIFT)
#define CONF_DEFAULT_CONNTYPE(c) ((c & CONF_DEFAULT_CONNTYPE_MASK) >> CONF_DEFAULT_CONNTYPE_SHIFT)
#define CONF_DEFAULT_DEVICE(c) ((c & CONF_DEFAULT_DEVICE_MASK) >> CONF_DEFAULT_DEVICE_SHIFT)
#define CONF_DEFAULT_LOCATION(c) ((c & CONF_DEFAULT_LOCATION_MASK) >> CONF_DEFAULT_LOCATION_SHIFT)
#define CONF_DEFAULT_CONNECTIVITY(c) ((c & CONF_DEFAULT_CONNECTIVITY_MASK) >> CONF_DEFAULT_CONNECTIVITY_SHIFT)

/* EAPD/BTL enable */
#define EAPDBTL_ENABLE_BTL			0x1
#define EAPDBTL_ENABLE_EAPD			0x2
#define EAPDBTL_ENABLE_LRSWAP			0x4

/* GP I/O count */
#define GPIO_COUNT_NUM_GPIO_MASK	0x000000ff
#define GPIO_COUNT_NUM_GPIO_SHIFT	0
#define GPIO_COUNT_NUM_GPO_MASK		0x0000ff00
#define GPIO_COUNT_NUM_GPO_SHIFT	8
#define GPIO_COUNT_NUM_GPI_MASK		0x00ff0000
#define GPIO_COUNT_NUM_GPI_SHIFT	16
#define GPIO_COUNT_GPIUNSOL_MASK	0x40000000
#define GPIO_COUNT_GPIUNSOL_SHIFT	30
#define GPIO_COUNT_GPIWAKE_MASK		0x80000000
#define GPIO_COUNT_GPIWAKE_SHIFT	31

#define GPIO_COUNT_NUM_GPIO(c) ((c & GPIO_COUNT_NUM_GPIO_MASK) >> GPIO_COUNT_NUM_GPIO_SHIFT)
#define GPIO_COUNT_NUM_GPO(c) ((c & GPIO_COUNT_NUM_GPO_MASK) >> GPIO_COUNT_NUM_GPO_SHIFT)
#define GPIO_COUNT_NUM_GPI(c) ((c & GPIO_COUNT_NUM_GPI_MASK) >> GPIO_COUNT_NUM_GPI_SHIFT)
#define GPIO_COUNT_GPIUNSOL(c) ((c & GPIO_COUNT_GPIUNSOL_MASK) >> GPIO_COUNT_GPIUNSOL_SHIFT)
#define GPIO_COUNT_GPIWAKE(c) ((c & GPIO_COUNT_GPIWAKE_MASK) >> GPIO_COUNT_GPIWAKE_SHIFT)


#endif /* HDA_CODEC_H */
